(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    539814,      10884]
NotebookOptionsPosition[    527128,      10478]
NotebookOutlinePosition[    527547,      10494]
CellTagsIndexPosition[    527504,      10491]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Chapter 4", "Title",
 Editable->False,
 CellChangeTimes->{{3.412330917225179*^9, 3.412330918767397*^9}}],

Cell["Poisson Fibre Processes I: Fibre Phase", "Subtitle",
 Editable->False,
 CellChangeTimes->{{3.3979872211263776`*^9, 3.3979872252523108`*^9}, 
   3.4119880476021442`*^9, {3.4124102745954733`*^9, 3.412410299471243*^9}}],

Cell["\[Copyright]W.W.Sampson, Manchester, 2008", "Subsubtitle",
 Editable->False,
 CellChangeTimes->{{3.412935407213834*^9, 3.412935418490048*^9}}],

Cell[CellGroupData[{

Cell["4.2 Planar Fibre Networks", "Section",
 Editable->False,
 CellChangeTimes->{{3.412330943933584*^9, 3.4123309539079266`*^9}}],

Cell[CellGroupData[{

Cell["Buffon's Needle", "Subsubsection",
 Editable->False,
 CellChangeTimes->{{3.397993527574605*^9, 3.3979935307892275`*^9}, 
   3.4119880476021442`*^9}],

Cell[TextData[{
 "Buffon's needle problem asks the probability that a needle of length \
\[Lambda] intersects a line if dropped at random on a plane marked with \
equally spaced parallel lines separated by a distance ",
 StyleBox["d",
  FontSlant->"Italic"],
 " where ",
 StyleBox["d",
  FontSlant->"Italic"],
 " < \[Lambda]. The distance of the centre of the needle from a line is a \
uniformly distributed random variable, ",
 StyleBox["x",
  FontSlant->"Italic"],
 "; the orientation of the needle to one of the lines is a uniformly \
distributed random variable \[Theta]. Their probability densities are \
therefore:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123306194570093`*^9, 3.4123307798376255`*^9}, {
  3.412415876090027*^9, 3.4124158871359105`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pdfx", " ", "=", " ", 
   RowBox[{"2", "/", "d"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pdf\[Theta]", " ", "=", " ", 
   RowBox[{"2", "/", "\[Pi]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.3905637081395073`*^9, 3.3905637203370466`*^9}, {
   3.397994081030435*^9, 3.397994081571213*^9}, 3.4119880476021442`*^9}],

Cell[TextData[{
 "The probability that the needle crosses a line is given by integrating the \
product of these probability densities, first with respect to ",
 StyleBox["x ",
  FontSlant->"Italic"],
 "and then with respect to \[Theta]. Note the order in which these integrals \
are stated in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123308058350077`*^9, 3.4123308915682864`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"pdfx", " ", "pdf\[Theta]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", " ", "0", ",", " ", 
     RowBox[{"\[Pi]", "/", "2"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"\[Lambda]", " ", 
      RowBox[{
       RowBox[{"Sin", "[", "\[Theta]", "]"}], "/", "2"}]}]}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.3905637363600864`*^9, 3.390563798028762*^9}, {
   3.3905638580650897`*^9, 3.3905638899609537`*^9}, {3.3905639341444864`*^9, 
   3.3905639517197585`*^9}, 3.4119880476021442`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[Lambda]"}], 
  RowBox[{"d", " ", "\[Pi]"}]]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.397995656986549*^9, 3.398078072953125*^9, 3.398078279*^9,
   3.398078503375*^9, 3.3981426220319057`*^9, 3.4119880476021442`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Two-dimensional networks", "Subsubsection",
 Editable->False,
 CellChangeTimes->{{3.3980776175*^9, 3.398077625328125*^9}, 
   3.4119880476021442`*^9}],

Cell[TextData[{
 "Kallmes and Corte defined two-dimensional networks as those where the \
fraction of the network with coverage greater than 2 is less than 1 %. We \
obtain the Poisson probability that coverage is greater than 2 in a network \
with mean coverage ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["c", "_"], TraditionalForm]]],
 " as follows:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123310057624893`*^9, 3.4123311060166483`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"P", "[", "c_", "]"}], ":=", " ", 
  RowBox[{"PDF", "[", 
   RowBox[{
    RowBox[{"PoissonDistribution", "[", "cbar", "]"}], ",", " ", "c"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Pgt2", " ", "=", " ", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"1", " ", "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"P", "[", "0", "]"}], "+", 
      RowBox[{"P", "[", "1", "]"}], "+", 
      RowBox[{"P", "[", "2", "]"}]}], ")"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.39807770634375*^9, 3.39807777*^9}, {
   3.398077830546875*^9, 3.398077921796875*^9}, {3.3980780014375*^9, 
   3.398078014109375*^9}, {3.39807814725*^9, 3.39807816084375*^9}, {
   3.39807825553125*^9, 3.398078255796875*^9}, {3.398078357984375*^9, 
   3.398078365109375*^9}, 3.4119880476021442`*^9}],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     RowBox[{"cbar", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "cbar"}], ")"}]}]}], ")"}], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "cbar"}]]}]}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.398077778796875*^9, {3.398077854015625*^9, 3.398077881765625*^9}, 
   3.39807792384375*^9, 3.398078014828125*^9, 3.398078073078125*^9, 
   3.398078161890625*^9, 3.398078279046875*^9, {3.3980783615*^9, 
   3.39807836590625*^9}, 3.39807850375*^9, 3.398142622622755*^9, 
   3.4119880476021442`*^9}]
}, Open  ]],

Cell[TextData[{
 "The mean coverage at which this fraction is 1% is obtained using ",
 StyleBox["FindRoot", "Input"],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123311166919985`*^9, 3.4123311455835423`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Pgt2", "\[Equal]", 
    RowBox[{"(", 
     RowBox[{"1", "/", "100"}], ")"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"cbar", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.39807770634375*^9, 3.398077811671875*^9}, {
   3.398077975015625*^9, 3.398078042984375*^9}, 3.4119880476021442`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"cbar", "\[Rule]", "0.43604516507829383`"}], "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.398077712171875*^9, 3.39807772475*^9}, {
   3.398077804328125*^9, 3.398077814921875*^9}, 3.398077893140625*^9, 
   3.39807792746875*^9, {3.398077987734375*^9, 3.398078073484375*^9}, 
   3.398078279109375*^9, 3.39807850378125*^9, 3.398142625446816*^9, 
   3.4119880476021442`*^9}]
}, Open  ]],

Cell[TextData[{
 "Often, two-dimensional networks are considered to be those with mean \
coverage ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["c", "_"], " ", "=", " ", "1.", " "}], TraditionalForm]]],
 "In such networks, the fraction with coverage greater than 3 is about 2%:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.41233115839196*^9, 3.412331205810144*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", " ", "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"P", "[", "0", "]"}], "+", 
     RowBox[{"P", "[", "1", "]"}], "+", 
     RowBox[{"P", "[", "2", "]"}], "+", 
     RowBox[{"P", "[", "3", "]"}]}], ")"}]}], "/.", 
  RowBox[{"cbar", "\[Rule]", "1."}]}]], "Input",
 CellChangeTimes->{{3.3981444428200703`*^9, 3.39814446068576*^9}, 
   3.3981444958463182`*^9, 3.3981457037331743`*^9, 3.4119880476021442`*^9}],

Cell[BoxData["0.018988156876153794`"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.398144448448163*^9, 3.398144461006221*^9}, 
   3.3981444960966787`*^9, {3.398145704424168*^9, 3.3981457154700513`*^9}, 
   3.4119880476021442`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.2.1 Probability of Crossing", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.398157503009701*^9, 3.398157506674971*^9}, 
   3.4119880476021442`*^9, {3.4123312313068066`*^9, 3.4123312366244526`*^9}}],\


Cell[TextData[{
 "With reference to Figure 4.3, we observe that the probability that a \
crossing occurs between fibres with angle \[Theta] to each other within an \
area ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "2"], TraditionalForm]]],
 "is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Lambda]", "^", "2"}], " ", 
    RowBox[{
     RowBox[{"Sin", "(", "\[Theta]", ")"}], "/", 
     SuperscriptBox["x", "2"]}]}], TraditionalForm]]],
 ". The probability that fibres with any angle uniformly distributed on the \
interval [0, \[Pi]/2] cross is"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123312609294014`*^9, 3.4123314494504814`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Pcross\[Theta]", " ", "=", " ", 
   RowBox[{
    SuperscriptBox["\[Lambda]", "2"], " ", 
    RowBox[{
     RowBox[{"Sin", "[", "\[Theta]", "]"}], "/", 
     SuperscriptBox["x", "2"]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g\[Theta]", " ", "=", " ", 
   RowBox[{"2", "/", "\[Pi]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Pcross", " ", "=", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"Pcross\[Theta]", " ", "g\[Theta]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"\[Theta]", ",", " ", "0", ",", " ", 
      RowBox[{"\[Pi]", "/", "2"}]}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.39815475949472*^9, 3.398154829415261*^9}, {
   3.3981560396955585`*^9, 3.3981560615569935`*^9}, {3.3981588582484384`*^9, 
   3.398158866129771*^9}, 3.3981598917845907`*^9, 3.40473731260525*^9, 
   3.4119880476021442`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SuperscriptBox["\[Lambda]", "2"]}], 
  RowBox[{"\[Pi]", " ", 
   SuperscriptBox["x", "2"]}]]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.3981599368794336`*^9, 3.3981639384534144`*^9, {3.399017470466674*^9, 
   3.3990174951922274`*^9}, 3.404737316558375*^9, 3.4119880476021442`*^9}]
}, Open  ]],

Cell[TextData[{
 "If there are ",
 StyleBox["nfib", "Input"],
 " fibres in an area ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "2"], TraditionalForm]]],
 ", then the number of pairs per unit area is ",
 StyleBox["npairs", "Input"],
 ". The expected number of crossings per unit area is therefore:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.41233147810168*^9, 3.4123316155393057`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"npairs", " ", "=", " ", 
   RowBox[{
    SuperscriptBox["nfib", "2"], "/", 
    RowBox[{"(", 
     RowBox[{"2", " ", 
      SuperscriptBox["x", "2"]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nfib", " ", "=", " ", 
   RowBox[{"cbar", " ", 
    RowBox[{
     SuperscriptBox["x", "2"], "/", 
     RowBox[{"(", 
      RowBox[{"\[Lambda]", " ", "\[Omega]"}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ncrosspua", " ", "=", " ", 
  RowBox[{"npairs", " ", "Pcross"}]}]}], "Input",
 CellChangeTimes->{{3.3981588305185647`*^9, 3.398158875833725*^9}, {
   3.398159082530941*^9, 3.398159085365016*^9}, {3.3981592171645346`*^9, 
   3.398159222211792*^9}, {3.398159842914318*^9, 3.3981598507956514`*^9}, 
   3.3981598917845907`*^9, 3.404737323589625*^9, 3.4119880476021442`*^9}],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["cbar", "2"], 
  RowBox[{"\[Pi]", " ", 
   SuperscriptBox["\[Omega]", "2"]}]]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.3981599370396643`*^9, 3.398163939494912*^9, {3.3990174705868464`*^9, 
   3.399017495873206*^9}, 3.404737330683375*^9, 3.4119880476021442`*^9}]
}, Open  ]],

Cell[TextData[{
 "So the expected number of crossings ",
 StyleBox["per fibre ",
  FontSlant->"Italic"],
 " is:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.41233163198295*^9, 3.412331642357869*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", " ", "ncrosspua", " ", 
  RowBox[{
   SuperscriptBox["x", "2"], "/", "nfib"}]}]], "Input",
 CellChangeTimes->{{3.398159265624216*^9, 3.398159289308272*^9}, {
   3.3981593573160625`*^9, 3.3981593574362354`*^9}, 3.398159448697462*^9, 
   3.3981598917845907`*^9, 3.4119880476021442`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "cbar", " ", "\[Lambda]"}], 
  RowBox[{"\[Pi]", " ", "\[Omega]"}]]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.398159937069707*^9, 3.398163939625099*^9, {3.399017470626904*^9, 
   3.3990174959132643`*^9}, 3.404737334558375*^9, 3.4119880476021442`*^9}]
}, Open  ]],

Cell["\<\
An alternative approach is to compute the fraction of the network involved in \
crossings, assuming that the fraction of the network with coverage greater \
than 3 is negligible. This fraction is\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4123316575597277`*^9, 3.412331720970909*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"P", "[", "c_", "]"}], ":=", " ", 
  RowBox[{"PDF", "[", 
   RowBox[{
    RowBox[{"PoissonDistribution", "[", "cbar", "]"}], ",", " ", "c"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P", "[", "2", "]"}], " ", "+", " ", 
  RowBox[{"2", " ", 
   RowBox[{"P", "[", "3", "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.398162041615896*^9, 3.3981620456016273`*^9}, {
   3.398162269092992*^9, 3.398162269243208*^9}, 3.4119880476021442`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["cbar", "2"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "cbar"}]]}], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   SuperscriptBox["cbar", "3"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "cbar"}]]}]}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.3981626212093105`*^9, 3.398163903342928*^9, 3.398163939675171*^9, {
   3.3990174707671056`*^9, 3.399017495963336*^9}, 3.4119880476021442`*^9}]
}, Open  ]],

Cell[TextData[{
 "Crossings generate parallelograms, so the area of a crossing between fibres \
with width \[Omega] that cross with angle \[Phi] is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Omega]", "2"], "/", 
    RowBox[{"Sin", "(", "\[Phi]", ")"}]}], TraditionalForm]]],
 "and the expected number of such \[Phi]-crossings is:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.41233175015287*^9, 3.412331838770296*^9}, {
  3.4124159009657965`*^9, 3.412415907625373*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"%", " ", 
   RowBox[{
    RowBox[{"Sin", "[", "\[Phi]", "]"}], "/", 
    SuperscriptBox["\[Omega]", "2"]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.398162064769189*^9, 3.3981620772170877`*^9}, {
   3.3981622421442413`*^9, 3.398162247161456*^9}, 3.4119880476021442`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["cbar", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"3", "+", 
     RowBox[{"2", " ", "cbar"}]}], ")"}], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "cbar"}]], " ", 
   RowBox[{"Sin", "[", "\[Phi]", "]"}]}], 
  RowBox[{"6", " ", 
   SuperscriptBox["\[Omega]", "2"]}]]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.3981620806820707`*^9, {3.3981622475019455`*^9, 3.398162272117341*^9}, {
   3.3981629736260605`*^9, 3.398162999893832*^9}, 3.3981639047649727`*^9, 
   3.398163939715229*^9, {3.3990174708271923`*^9, 3.3990174960234222`*^9}, 
   3.4119880476021442`*^9}]
}, Open  ]],

Cell["\<\
To obtain the expected number of crossings per unit area, we must integrate \
for all \[Phi], and \[Phi] has probability density Sin(\[Phi]), so we have:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412331848484264*^9, 3.4123318862986383`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"%", " ", 
    RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", " ", "0", ",", " ", 
     RowBox[{"\[Pi]", "/", "2"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{3.4119880476021442`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["cbar", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"3", "+", 
     RowBox[{"2", " ", "cbar"}]}], ")"}], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "cbar"}]], " ", "\[Pi]"}], 
  RowBox[{"24", " ", 
   SuperscriptBox["\[Omega]", "2"]}]]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.398163183978533*^9, {3.3981638980753536`*^9, 3.3981639071484003`*^9}, 
   3.3981639400056467`*^9, {3.399017471157667*^9, 3.39901749631384*^9}, 
   3.4119880476021442`*^9}]
}, Open  ]],

Cell["\<\
This differs from our earlier estimate of the expected number of crossings \
per unit area by a factor: \
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4123318990169263`*^9, 3.412331920017123*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/", "ncrosspua"}]], "Input",
 CellChangeTimes->{{3.3981635213836975`*^9, 3.3981635303165426`*^9}, {
   3.398163569382717*^9, 3.398163605885205*^9}, {3.39816384931524*^9, 
   3.398163895341422*^9}, 3.4119880476021442`*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "24"], " ", 
  RowBox[{"(", 
   RowBox[{"3", "+", 
    RowBox[{"2", " ", "cbar"}]}], ")"}], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", "cbar"}]], " ", 
  SuperscriptBox["\[Pi]", "2"]}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.3981638830737824`*^9, 3.3981639085904737`*^9}, 
   3.3981639400256753`*^9, {3.399017471197725*^9, 3.3990174963438835`*^9}, 
   3.4119880476021442`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"%", ",", " ", 
   RowBox[{"{", 
    RowBox[{"cbar", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellChangeTimes->{3.4119880476021442`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVzWs0FGgAxnFElLNqSJ0hiUiipjSplB6iy1Js0ZFtaEspdSphNylqClsu
224rlHKdtjRhZagOQia1cktKF0MzO40x9zGNicS+++E5//P79NjtO77jgIGe
nl4A2f/1OyB+2Ti0c/2s9MRn6+o1MPSxih6g0uGvTzn/sE6DFQW5N6qovjjI
8XWjE/u3996/SQ3GlZzsWJdaDUL26+qvUPfjOntRAvWRBjzarz6Z1DjEtjtd
03A0KLQMTE2jJoMfeplWeE8DpkmV0yVqFq6WCH0/5GmwK7SoQqVmQTd3StTY
LxqYTjIZm+dVAIeCM5RBGjhuV4ib0zm43TF3xHS5Bic71iD38yOw0ju8WNM1
mMOh9OvrN0A3IzcwUDSMGoFPW+e6J0g4FfY8+vEwnhy+aR0q48Jj996zr7OH
oV3oOaPs6DOU2GazmCeGYTDKnmnt2IpIdljQrS3DcJ/8qSaovA38Dc7BLvbD
aEumd7Qs7kSpPe+PxeNq2P4uHS1VdEGc4D3B6lZDqhvof72sG9qbF6zusNVg
SWpbzX57heqkoqWLmGqY2dxWCoU9aF45mLY6RI2MqOrIQoc3qD8dWqymqTHi
xRYeOtuLG927H9KM1Ihz43JmN7/FrNzx3oU8FQbKuekv7d6j55M64k6lCl8P
9+Q5J3zAnk98V16qCi7exhORtX2Ir3SazQ9XYXOx3cHKOf0oLsvRJKxQ4aTN
Hns+YwAGs8YclNNVcJXtNO3d9hEWbwM8f2xRwmKGyoQ79hGK1CNh1tFKGDbk
VSy4wUf+54Eatq0SR+i176b5C9Dy+p8fsp4rwP5+X+HjEQEcni5uc4tVQCu1
minK/henI47n3V+gQHXQ5ilZvkK8GPnLqrRdjrNbUgo4IiH2JxVoLyXKYcfz
e1uS8gkXWulf3GhyeKxKzqK6ifBOp5sX814GxrzOUf1XIhQLvroUpcugbc0U
RDMHsbdbIUpylyHXMDxuh4MYTt+W+AcOSmHRX11swBWD7x23ZvyaFEaJzOA1
J4aQ2a70SdgkhV5peIXAXAKTjOZi0RcJYq5XZJo/kaAyhwHckqDe5aIJ5ZgU
ohBLWWaQBBS/GNfzZjLQAn42bTKWoG9J16tTdTJwLP3yjWqG8Hc+HIThciSl
nQl2PjyEsAp3is2EHCMzZ+evnj+EcylFzL67CkyD2cakLjHKxDZ5ZluVGOq8
HHIlVYztFLPVz8aUaOyaWDXmLkaakYF1H/HFxsY6FTF3VPtNRaxrSPYeJHYX
8JqtvirRJjf37yG2qioLPEYca7QlvJxYELztoOW4ElpHy5R9xHG5GdkR35RY
unJtT+tK8p9x7lQ88da5CG0iFp2LY2QSe1ps7H9AvCuKYf+A+M9lIWIWsaeH
a/n0CSU2OWeNJxFP7XvxtJJYZ3HCcQUxuhrutBC3fLl615k4nluV/oH4jLyO
Np9Yci9vu9GkEgVTKR7fEXckHuHtIlbpXgYM0sUwjtnTeJSYyjDu4RF7RQaV
nCd261of2kN8P2Bt1D3i9eKqiCZi6Qba1iZieoZa/IDYYdUC2hvi+V7Lj5UT
h7vMMZcSGxrGaljEObam2klifm9NfB7xfyrIi08=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0.8},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.398163916702138*^9, 3.398163940095776*^9}, {
   3.399017471247797*^9, 3.3990174968446035`*^9}, 3.4119880476121583`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.2.2 Fractional Contact Area", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.3981666232940254`*^9, 3.3981666235944576`*^9}, 
   3.4119880476121583`*^9, {3.412331943791309*^9, 3.4123319486382785`*^9}}],

Cell[TextData[{
 "For two-dimensional networks, we can assume that fibres make contact \
wherever they cross. In a region with coverage ",
 StyleBox["c ",
  FontSlant->"Italic"],
 " the number of surfaces making contact is (",
 StyleBox["c ",
  FontSlant->"Italic"],
 "- 1), so the fractional contact area of a two-dimensional network is:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412331975146395*^9, 3.4123320730671988`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"P", "[", "c_", "]"}], ":=", 
  RowBox[{"PDF", "[", 
   RowBox[{
    RowBox[{"PoissonDistribution", "[", "cbar", "]"}], ",", " ", "c"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"\[CapitalPhi]2d", " ", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "-", "1"}], ")"}], 
       RowBox[{"P", "[", "c", "]"}]}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"c", ",", " ", "2", ",", " ", "\[Infinity]"}], "}"}]}], "]"}], 
    "/", "cbar"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.399017644356715*^9, 3.3990176953900976`*^9}, 
   3.4119880476121583`*^9}],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox[
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "cbar"}]]}], "cbar"]}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.3990177109324465`*^9, 3.4119880476121583`*^9}]
}, Open  ]],

Cell[TextData[{
 "It is convenient to express the fractional contact area in terms of the \
fractional ",
 StyleBox["open",
  FontSlant->"Italic"],
 " area, \[Epsilon]. By definition, \[Epsilon] is the fraction of the network \
with coverage zero, ",
 StyleBox["i.e.",
  FontSlant->"Italic"],
 " \[Epsilon] = ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     OverscriptBox["c", "_"]}]], TraditionalForm]]],
 ", so we have:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123320874979486`*^9, 3.4123321670022707`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"cbar", " ", "=", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "/", "\[Epsilon]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Apart", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{"\[CapitalPhi]2d", ",", " ", 
    RowBox[{"0", "<", "\[Epsilon]", "<", "1"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.399017723600662*^9, 3.39901774241772*^9}, 
   3.4119880476121583`*^9}],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox[
   RowBox[{"1", "-", "\[Epsilon]"}], 
   RowBox[{"Log", "[", "\[Epsilon]", "]"}]]}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.39901774382975*^9, 3.4119880476121583`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.2.3 Fractional Between-Zones Variance", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.3990177526524367`*^9, 3.3990177584708033`*^9}, 
   3.4119880476121583`*^9, {3.4123321762455616`*^9, 3.4123321831254544`*^9}}],\


Cell[CellGroupData[{

Cell["\<\
Point Autocorrelation Function, \[Alpha](r)\
\>", "Subsubsection",
 Editable->False,
 CellChangeTimes->{{3.412332557223381*^9, 3.412332565935909*^9}, {
  3.4123327021718063`*^9, 3.4123327064579697`*^9}}],

Cell[TextData[{
 "The area ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", "pq"], TraditionalForm]]],
 "is defined according to Equation 4.40. We integrate ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", "pq"], TraditionalForm]]],
 "for three cases, as illustrated in Figure 4.6. First, we deal with Cases A \
and B:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412332346280059*^9, 3.412332460784709*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Apq", " ", "=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Omega]", "-", " ", 
      RowBox[{"r", " ", 
       RowBox[{"Abs", "[", 
        RowBox[{"Sin", "[", "\[Phi]", "]"}], "]"}]}]}], ")"}], 
    RowBox[{"(", 
     RowBox[{"\[Lambda]", " ", "-", " ", 
      RowBox[{"r", " ", 
       RowBox[{"Abs", "[", 
        RowBox[{"Cos", "[", "\[Phi]", "]"}], "]"}]}]}], ")"}]}]}], 
  ";"}], "\n", 
 RowBox[{"\[Alpha]1", " ", "=", " ", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", " ", "\[Lambda]", " ", "\[Omega]"}], ")"}]}], ")"}], 
    RowBox[{"Integrate", "[", 
     RowBox[{"Apq", ",", " ", 
      RowBox[{"{", 
       RowBox[{"\[Phi]", ",", " ", 
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", " ", 
        RowBox[{"\[Pi]", "/", "2"}]}], "}"}]}], "]"}]}], "]"}]}], "\n", 
 RowBox[{"\[Alpha]2", " ", "=", " ", 
  RowBox[{"Expand", "[", 
   RowBox[{"PowerExpand", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"\[Pi]", " ", "\[Lambda]", " ", "\[Omega]"}], ")"}]}], ")"}], 
     
     RowBox[{"Integrate", "[", 
      RowBox[{"Apq", ",", " ", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", " ", 
         RowBox[{"-", 
          RowBox[{"ArcSin", "[", 
           RowBox[{"\[Omega]", "/", "r"}], "]"}]}], ",", " ", 
         RowBox[{"ArcSin", "[", 
          RowBox[{"\[Omega]", "/", "r"}], "]"}]}], "}"}], ",", " ", 
       RowBox[{"GenerateConditions", "\[Rule]", "False"}]}], "]"}]}], "]"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.3984912754375024`*^9, 3.398491314103101*^9}, {
   3.3984915439736385`*^9, 3.398491555980904*^9}, {3.3984917748456163`*^9, 
   3.3984917811446733`*^9}, {3.3984932792488413`*^9, 3.398493312376477*^9}, 
   3.3990191686485395`*^9, 3.399019201465728*^9, {3.3990195165988674`*^9, 
   3.3990195251812077`*^9}, 3.4119880476121583`*^9}],

Cell[BoxData[
 RowBox[{"1", "-", 
  FractionBox[
   RowBox[{"2", " ", "r"}], 
   RowBox[{"\[Pi]", " ", "\[Lambda]"}]], "-", 
  FractionBox[
   RowBox[{"2", " ", "r"}], 
   RowBox[{"\[Pi]", " ", "\[Omega]"}]], "+", 
  FractionBox[
   SuperscriptBox["r", "2"], 
   RowBox[{"\[Pi]", " ", "\[Lambda]", " ", "\[Omega]"}]]}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.3990148733321776`*^9, 3.3990183884366493`*^9, 
  3.399019088002576*^9, 3.3990195391512957`*^9, 3.3990317928712797`*^9, 
  3.3990952216573954`*^9, 3.3991072515655537`*^9, 3.3991079108335342`*^9, 
  3.399183091978712*^9, 3.404739160074*^9, 3.4119880476121583`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"2", " ", "r"}], 
    RowBox[{"\[Pi]", " ", "\[Omega]"}]]}], "-", 
  FractionBox["\[Omega]", 
   RowBox[{"\[Pi]", " ", "\[Lambda]"}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["r", "2"], "-", 
      SuperscriptBox["\[Omega]", "2"]}]]}], 
   RowBox[{"\[Pi]", " ", "\[Omega]"}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"ArcSin", "[", 
     FractionBox["\[Omega]", "r"], "]"}]}], "\[Pi]"]}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.3990148733321776`*^9, 3.3990183884366493`*^9, 
  3.399019088002576*^9, 3.3990195391512957`*^9, 3.3990317928712797`*^9, 
  3.3990952216573954`*^9, 3.3991072515655537`*^9, 3.3991079108335342`*^9, 
  3.399183091978712*^9, 3.404739231808375*^9, 3.4119880476121583`*^9}]
}, Open  ]],

Cell["For Case C, we take advantage of symmetry:", "Text",
 Editable->False,
 CellChangeTimes->{{3.412332508293022*^9, 3.4123325374649696`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Alpha]3", " ", "=", " ", 
  RowBox[{"Expand", "[", 
   RowBox[{"PowerExpand", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "/", 
       RowBox[{"(", 
        RowBox[{"\[Pi]", " ", "\[Lambda]", " ", "\[Omega]"}], ")"}]}], ")"}], 
     
     RowBox[{"Integrate", "[", 
      RowBox[{"Apq", ",", " ", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", " ", 
         RowBox[{"ArcCos", "[", 
          RowBox[{"\[Lambda]", "/", "r"}], "]"}], ",", " ", 
         RowBox[{"ArcSin", "[", 
          RowBox[{"\[Omega]", "/", "r"}], "]"}]}], "}"}], ",", " ", 
       RowBox[{"GenerateConditions", "\[Rule]", "False"}]}], "]"}]}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.3984930277972717`*^9, 3.3984930401750703`*^9}, {
   3.398493329320842*^9, 3.398493330632728*^9}, {3.398493383318486*^9, 
   3.3984933865030656`*^9}, {3.3984935976967473`*^9, 
   3.3984936003305345`*^9}, {3.398493678332696*^9, 3.39849369270336*^9}, {
   3.3984938576405277`*^9, 3.398493863248592*^9}, {3.398494087851555*^9, 
   3.398494108701536*^9}, 3.3984941693287134`*^9, {3.3990192338122396`*^9, 
   3.3990192429453726`*^9}, {3.3990195299180193`*^9, 3.399019530038192*^9}, 
   3.4119880476121583`*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["r", "2"], "-", 
      SuperscriptBox["\[Lambda]", "2"]}]]}], 
   RowBox[{"\[Pi]", " ", "\[Lambda]"}]], "-", 
  FractionBox[
   SuperscriptBox["r", "2"], 
   RowBox[{"\[Pi]", " ", "\[Lambda]", " ", "\[Omega]"}]], "-", 
  FractionBox["\[Lambda]", 
   RowBox[{"\[Pi]", " ", "\[Omega]"}]], "-", 
  FractionBox["\[Omega]", 
   RowBox[{"\[Pi]", " ", "\[Lambda]"}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["r", "2"], "-", 
      SuperscriptBox["\[Omega]", "2"]}]]}], 
   RowBox[{"\[Pi]", " ", "\[Omega]"}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"ArcCos", "[", 
     FractionBox["\[Lambda]", "r"], "]"}]}], "\[Pi]"], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"ArcSin", "[", 
     FractionBox["\[Omega]", "r"], "]"}]}], "\[Pi]"]}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.399019847204254*^9, 3.3990320052867184`*^9, 
  3.399095585831051*^9, 3.399107478762246*^9, 3.3991081485753903`*^9, 
  3.3991834398789682`*^9, 3.404739375464625*^9, 3.4119880476121583`*^9}]
}, Open  ]],

Cell[TextData[{
 "We combine the outputs in a Piecewise function to give the point \
autocorrelation function as a function of fibre length (\[Lambda]), fibre \
width (\[Omega]) and the separation of pairs of points (",
 StyleBox["r",
  FontSlant->"Italic"],
 "):"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123325459471664`*^9, 3.412332638099675*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Alpha]", "[", 
   RowBox[{"\[Lambda]_", ",", "\[Omega]_", ",", "r_"}], "]"}], " ", ":=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "-", 
        FractionBox[
         RowBox[{"2", " ", "r"}], 
         RowBox[{"\[Pi]", " ", "\[Lambda]"}]], "-", 
        FractionBox[
         RowBox[{"2", " ", "r"}], 
         RowBox[{"\[Pi]", " ", "\[Omega]"}]], "+", 
        FractionBox[
         SuperscriptBox["r", "2"], 
         RowBox[{"\[Pi]", " ", "\[Lambda]", " ", "\[Omega]"}]]}], ",", " ", 
       RowBox[{"0", "\[LessEqual]", "r", "\[LessEqual]", "\[Omega]"}]}], 
      "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", "r"}], 
          RowBox[{"\[Pi]", " ", "\[Omega]"}]]}], "-", 
        FractionBox["\[Omega]", 
         RowBox[{"\[Pi]", " ", "\[Lambda]"}]], "+", 
        FractionBox[
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["r", "2"], "-", 
            SuperscriptBox["\[Omega]", "2"]}]]}], 
         RowBox[{"\[Pi]", " ", "\[Omega]"}]], "+", 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"ArcSin", "[", 
           FractionBox["\[Omega]", "r"], "]"}]}], "\[Pi]"]}], ",", " ", 
       RowBox[{"\[Omega]", "<", "r", "\[LessEqual]", "\[Lambda]"}]}], "}"}], 
     ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        FractionBox[
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["r", "2"], "-", 
            SuperscriptBox["\[Lambda]", "2"]}]]}], 
         RowBox[{"\[Pi]", " ", "\[Lambda]"}]], "-", 
        FractionBox[
         SuperscriptBox["r", "2"], 
         RowBox[{"\[Pi]", " ", "\[Lambda]", " ", "\[Omega]"}]], "-", 
        FractionBox["\[Lambda]", 
         RowBox[{"\[Pi]", " ", "\[Omega]"}]], "-", 
        FractionBox["\[Omega]", 
         RowBox[{"\[Pi]", " ", "\[Lambda]"}]], "+", 
        FractionBox[
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["r", "2"], "-", 
            SuperscriptBox["\[Omega]", "2"]}]]}], 
         RowBox[{"\[Pi]", " ", "\[Omega]"}]], "-", 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"ArcCos", "[", 
           FractionBox["\[Lambda]", "r"], "]"}]}], "\[Pi]"], "+", 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"ArcSin", "[", 
           FractionBox["\[Omega]", "r"], "]"}]}], "\[Pi]"]}], ",", " ", 
       RowBox[{"\[Lambda]", "<", "r", "\[LessEqual]", " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["\[Lambda]", "2"], "+", 
          SuperscriptBox["\[Omega]", "2"]}]]}]}], "}"}]}], "}"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.399021925212283*^9, 3.399022026998645*^9}, {
   3.399022082177989*^9, 3.399022088016384*^9}, 3.399107085286456*^9, 
   3.4119880476121583`*^9}],

Cell[TextData[{
 "Here we plot the point autocorrelation function for fibres of aspect ratio \
",
 StyleBox["A",
  FontSlant->"Italic"],
 " = 50."
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123326598409376`*^9, 3.412332691726787*^9}, 
   3.4124159107098083`*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", " ", "=", " ", "50"}], ";", 
  RowBox[{"\[Lambda]", " ", "=", " ", "1"}], ";", 
  RowBox[{"\[Omega]", " ", "=", " ", 
   RowBox[{"\[Lambda]", "/", "A"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"\[Alpha]", "[", 
    RowBox[{"\[Lambda]", ",", "\[Omega]", ",", "r"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"r", ",", " ", "0", ",", " ", ".4"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<r\>\"", ",", " ", "\"\<\[Alpha](r)\>\""}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Clear", "[", 
  RowBox[{"\[Lambda]", ",", "\[Omega]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.399021925212283*^9, 3.399022026998645*^9}, {
   3.399022082177989*^9, 3.399022088016384*^9}, {3.3990222624271746`*^9, 
   3.3990223532878256`*^9}, {3.3990223906916094`*^9, 
   3.3990224620942817`*^9}, {3.3990231904816513`*^9, 3.399023222768077*^9}, 
   3.399027609235507*^9, {3.3990277170204945`*^9, 3.3990277222279825`*^9}, {
   3.3991070930976877`*^9, 3.3991070966327715`*^9}, 3.4119880476121583`*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{{8.163265306122449*^-9, 0.9999997349582999}, {
      0.00012268716822385072`, 0.9960168806298068}, {0.0002453661731823953, 
      0.9920345053620931}, {0.0004907241830994845, 0.9840711920090046}, {
      0.0009814402029336628, 0.9681503140321827}, {0.0019628722426020197`, 
      0.9363315529959588}, {0.0039257363219387335`, 0.8727860105931908}, {
      0.00785146448061216, 0.7460628444663752}, {0.007984462579886713, 
      0.7417782346520956}, {0.008117460679161264, 0.7374941878800803}, {
      0.008383456877710367, 0.7289277834628424}, {0.008915449274808572, 
      0.7118017311355379}, {0.009979434069004985, 0.6775766525096134}, {
      0.01210740365739781, 0.6092345993725026}, {0.012240401756672362`, 
      0.6049680069106795}, {0.012373399855946914`, 0.6007019774911204}, {
      0.012639396054496016`, 0.5921716077787955}, {0.013171388451594223`, 
      0.5751176248613163}, {0.014235373245790637`, 0.5410366850550428}, {
      0.01636334283418346, 0.4729829095572339}, {0.016487527374712797`, 
      0.4690158629038087}, {0.01661171191524213, 0.4650493071415275}, {
      0.0168600809963008, 0.4571176682903957}, {0.017356819158418135`, 
      0.4412602812818561}, {0.018350295482652806`, 0.409569070039673}, {
      0.018474480023182138`, 0.4056098776445468}, {0.018598664563711474`, 
      0.4016511761405639}, {0.01884703364477014, 0.3937352458060296}, {
      0.019343771806887476`, 0.37790927583068457`}, {0.019467956347416812`, 
      0.37395401056470734`}, {0.019592140887946145`, 0.36999923618987407`}, {
      0.019840509969004813`, 0.3620911601136382}, {0.019872448979591836`, 
      0.36107436392097747`}}], LineBox[CompressedData["
1:eJwd1Xk01OsfB/BvUZcumjYkSaJQSaI9b2mVFi2IiDapqxtd6ibXHVnrytbM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      "]]}, {}}, {{}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"r\"", TraditionalForm], 
    FormBox["\"\[Alpha](r)\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.3990219266443424`*^9, {3.3990219703872414`*^9, 3.3990220281703296`*^9}, 
   3.399022307812435*^9, {3.3990223420917263`*^9, 3.399022353738474*^9}, {
   3.3990223926644464`*^9, 3.3990224622845554`*^9}, 3.399023190832155*^9, 
   3.399023228436227*^9, 3.399027643354568*^9, 3.3990276819700947`*^9, 
   3.3990277325928864`*^9, 3.3990320060678415`*^9, 3.3990955882745647`*^9, 
   3.399107098305176*^9, 3.399107480424637*^9, 3.3991081495367727`*^9, 
   3.39918344193192*^9, 3.404739375808375*^9, 3.4119880476121583`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fractional Between-Zones Variance", "Subsubsection",
 Editable->False,
 CellChangeTimes->{{3.412332741488341*^9, 3.4123327554083567`*^9}}],

Cell[TextData[{
 "The fractional between zones variance for square inspection zones of side \
",
 StyleBox["x",
  FontSlant->"Italic"],
 " is given by\n\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Rho]", "x"], " ", "=", " ", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", 
      RowBox[{
       SqrtBox["2"], "x"}]], 
     RowBox[{
      RowBox[{"\[Alpha]", "(", "r", ")"}], " ", 
      RowBox[{"b", "(", "r", ")"}], " ", 
      RowBox[{"\[DifferentialD]", "r"}]}]}]}], TraditionalForm]]],
 "\n\nwhere ",
 StyleBox["b",
  FontSlant->"Italic"],
 "(",
 StyleBox["r",
  FontSlant->"Italic"],
 ") is the probability density function for separation of pairs of points by \
a distance ",
 StyleBox["r",
  FontSlant->"Italic"],
 ". We derived this in Chapter 3 as:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412332763249632*^9, 3.4123328836327343`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "[", 
   RowBox[{"x_", ",", "r_"}], "]"}], ":=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "r", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox["x", "2"]}], " ", "-", " ", 
           RowBox[{"4", " ", "x", " ", "r"}], " ", "+", " ", 
           SuperscriptBox["r", "2"]}], ")"}], "/", 
         SuperscriptBox["x", "4"]}]}], ",", " ", 
       RowBox[{"0", "<", "r", "\[LessEqual]", " ", "x"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "r", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", "x", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["r", "2"], "-", 
              SuperscriptBox["x", "2"]}]]}], "-", 
           SuperscriptBox["r", "2"], "-", 
           RowBox[{
            SuperscriptBox["x", "2"], 
            RowBox[{"(", 
             RowBox[{"2", "+", "\[Pi]", "-", 
              RowBox[{"4", 
               RowBox[{"ArcSin", "[", 
                RowBox[{"x", "/", "r"}], "]"}]}]}], ")"}]}]}], ")"}], "/", 
         SuperscriptBox["x", "4"]}]}], ",", 
       RowBox[{"x", "<", "r", "\[LessEqual]", 
        RowBox[{
         SqrtBox["2"], "x"}]}]}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.399021925212283*^9, 3.399022026998645*^9}, {
   3.399022082177989*^9, 3.399022088016384*^9}, {3.3991058949248*^9, 
   3.3991059016444626`*^9}, {3.3991059391984625`*^9, 
   3.3991059747295537`*^9}, {3.399106178512579*^9, 3.399106190910406*^9}, {
   3.3991069364023714`*^9, 3.3991069466671314`*^9}, {3.399106978432808*^9, 
   3.399106988977971*^9}, {3.3991070805396304`*^9, 3.3991070818214736`*^9}, {
   3.3991849769491663`*^9, 3.3991849969779663`*^9}, {3.404739534074*^9, 
   3.404739534777125*^9}, 3.4119880476121583`*^9}],

Cell[TextData[{
 "For certain cases, we can determine ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Rho]", "x"], " "}], TraditionalForm]]],
 "analytically:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123328925655794`*^9, 3.4123329141566257`*^9}, 
   3.412415913143307*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"PiecewiseExpand", "[", 
     RowBox[{
      RowBox[{"\[Alpha]", "[", 
       RowBox[{"\[Lambda]", ",", "\[Omega]", ",", "r"}], "]"}], " ", 
      RowBox[{"b", "[", 
       RowBox[{"x", ",", "r"}], "]"}]}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"r", ",", " ", "0", ",", " ", "\[Omega]"}], "}"}], ",", " ", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"0", "\[LessEqual]", "r", "<", "\[Omega]", "<", "x"}]}]}], "]"}],
   "]"}]], "Input",
 CellChangeTimes->{{3.3990265728853087`*^9, 3.3990265810270157`*^9}, {
   3.3990267522732563`*^9, 3.3990268010834417`*^9}, {3.3990314997598066`*^9, 
   3.39903155002208*^9}, {3.3990315849322786`*^9, 3.399031585493085*^9}, 
   3.3990317486076317`*^9, {3.399107054402046*^9, 3.3991070646868353`*^9}, 
   3.4119880476121583`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"4", " ", 
     SuperscriptBox["\[Omega]", "2"]}], 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "2"]}]]}], "+", 
  FractionBox[
   RowBox[{"\[Pi]", " ", 
    SuperscriptBox["\[Omega]", "2"]}], 
   SuperscriptBox["x", "2"]], "-", 
  FractionBox[
   RowBox[{"8", " ", 
    SuperscriptBox["\[Omega]", "3"]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["x", "3"]}]], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    SuperscriptBox["\[Omega]", "3"]}], 
   RowBox[{"\[Pi]", " ", 
    SuperscriptBox["x", "3"]}]], "-", 
  FractionBox[
   RowBox[{"5", " ", 
    SuperscriptBox["\[Omega]", "3"]}], 
   RowBox[{"6", " ", 
    SuperscriptBox["x", "2"], " ", "\[Lambda]"}]], "+", 
  FractionBox[
   SuperscriptBox["\[Omega]", "4"], 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "4"]}]], "-", 
  FractionBox[
   RowBox[{"4", " ", 
    SuperscriptBox["\[Omega]", "4"]}], 
   RowBox[{"5", " ", "\[Pi]", " ", 
    SuperscriptBox["x", "4"]}]], "+", 
  FractionBox[
   RowBox[{"12", " ", 
    SuperscriptBox["\[Omega]", "4"]}], 
   RowBox[{"5", " ", "\[Pi]", " ", 
    SuperscriptBox["x", "3"], " ", "\[Lambda]"}]], "-", 
  FractionBox[
   RowBox[{"7", " ", 
    SuperscriptBox["\[Omega]", "5"]}], 
   RowBox[{"15", " ", "\[Pi]", " ", 
    SuperscriptBox["x", "4"], " ", "\[Lambda]"}]]}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.39902656977083*^9, 3.399026581888254*^9}, 
   3.3990266763540897`*^9, 3.3990267613563166`*^9, 3.399026872606286*^9, {
   3.399031504506632*^9, 3.3990315782827168`*^9}, 3.399031652118888*^9, 
   3.3990317523830605`*^9, 3.3990320087016287`*^9, 3.3990955908983374`*^9, 
   3.3991070676410832`*^9, 3.3991074837494173`*^9, 3.3991081535124893`*^9, 
   3.3991834487016544`*^9, 3.4047393785115*^9, 3.411988047622173*^9}]
}, Open  ]],

Cell[TextData[{
 "but typically, we require numerical methods so we define a function ",
 StyleBox["\[Rho]x", "Input"],
 " to carry out the integral using ",
 StyleBox["NIntegrate", "Input"],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123329191638255`*^9, 3.412332943008112*^9}, {
  3.4123331352845917`*^9, 3.412333168602501*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Rho]x", "[", 
   RowBox[{"\[Lambda]_", ",", "\[Omega]_", ",", "x_", ",", "r_"}], "]"}], ":=",
   " ", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Alpha]", "[", 
      RowBox[{"\[Lambda]", ",", "\[Omega]", ",", "r"}], "]"}], " ", 
     RowBox[{"b", "[", 
      RowBox[{"x", ",", "r"}], "]"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"r", ",", " ", "0", ",", " ", 
      RowBox[{
       SqrtBox["2"], "x"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.399105986676733*^9, 3.3991060239603443`*^9}, {
   3.399106209196701*^9, 3.3991062255402017`*^9}, {3.399107167704968*^9, 
   3.399107172682125*^9}, {3.3991078808404064`*^9, 3.3991078820421343`*^9}, 
   3.411988047622173*^9}],

Cell[TextData[{
 "We need to input values of \[Lambda], \[Omega], and ",
 StyleBox["x",
  FontSlant->"Italic"],
 " in the same units. So for fibres of length 10 mm and width 20 \[Mu]m, the \
fractional between zones variance at the 1 mm scale of inspection is:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123329576191216`*^9, 3.4123330229330387`*^9}, {
  3.412334842920051*^9, 3.412334843921491*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Rho]x", "[", 
  RowBox[{"10", ",", ".02", ",", "1", ",", "r"}], "]"}]], "Input",
 CellChangeTimes->{
  3.399107179722248*^9, {3.3991078054319744`*^9, 3.399107805602219*^9}, {
   3.3991079169923906`*^9, 3.3991079187348957`*^9}, {3.399108269959933*^9, 
   3.3991082734249153`*^9}, 3.411988047622173*^9}],

Cell[BoxData["0.01828268833968635`"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.3991071628579984`*^9, 3.3991071801228237`*^9}, 
   3.3991078067338467`*^9, {3.399108277771165*^9, 3.3991082851918354`*^9}, 
   3.399108449147592*^9, 3.3991834501437283`*^9, 3.40473937929275*^9, 
   3.411988047622173*^9}]
}, Open  ]],

Cell[TextData[{
 "We investigate the influence of inspection zone size by evaluating ",
 StyleBox["\[Rho]x", "Input"],
 " for the range of ",
 StyleBox["x",
  FontSlant->"Italic"],
 " specified in ",
 StyleBox["xtab", "Input"],
 ". Our example assumes fibre length of 1 mm and fibre width 20 \[Mu]m:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123348532048397`*^9, 3.412334907713219*^9}, {
  3.412334940710667*^9, 3.412334959427581*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"xtab", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{".05", ",", ".5", ",", ".05"}], "]"}], ",", 
     RowBox[{"Range", "[", 
      RowBox[{".6", ",", "1", ",", ".1"}], "]"}], ",", " ", 
     RowBox[{"Range", "[", 
      RowBox[{"1", ",", "5", ",", "1"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x\[Rho]tab", " ", "=", " ", 
   RowBox[{"Prepend", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"xtab", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", " ", 
         RowBox[{"\[Rho]x", "[", 
          RowBox[{"1", ",", ".02", ",", 
           RowBox[{"xtab", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", "r"}], "]"}]}], "}"}], ",", 
       " ", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "xtab", "]"}]}], "}"}]}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"x\[Rho]tab", ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", " ", "\"\<\[Rho]x\>\""}], "}"}]}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.3991060320820227`*^9, 3.3991060377702017`*^9}, {
   3.3991062305674305`*^9, 3.399106303392147*^9}, 3.399106334997594*^9, {
   3.399109120112392*^9, 3.399109259232437*^9}, {3.3991094609324675`*^9, 
   3.39910948333468*^9}, {3.39910951954675*^9, 3.39910952088868*^9}, 
   3.399109555618619*^9, 3.411988047622173*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{0., 1.}, {0.05, 0.3423925557993018}, {0.1, 
     0.17807906717769517`}, {0.15000000000000002`, 0.11820390190768607`}, {
     0.2, 0.08753918379670783}, {0.25, 0.06894975656059499}, {0.3, 
     0.056488988390756355`}, {0.35000000000000003`, 0.047559313470693955`}, {
     0.4, 0.04084782978719298}, {0.45, 0.03562015258659504}, {0.5, 
     0.031433609273651096`}, {0.6, 0.02514715458290411}, {0.7, 
     0.020652463947689423`}, {0.8, 0.01727941798697287}, {0.9, 
     0.014656662886222105`}, {1., 0.012565220737551137`}, {1., 
     0.012565220737551137`}, {2., 0.004004311506754401}, {3., 
     0.001920651203440577}, {4., 0.0011213926205054698`}, {5., 
     0.0007337284387523373}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"\[Rho]x\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.3991062860171633`*^9, 3.3991063414368525`*^9}, 
   3.399109229790101*^9, 3.3991092669134817`*^9, {3.399109490474947*^9, 
   3.399109514669738*^9}, {3.3991095580320897`*^9, 3.3991095675457697`*^9}, 
   3.3991834548504963`*^9, 3.404739380558375*^9, 3.411988047622173*^9}]
}, Open  ]],

Cell["\<\
Similarly, we obtain the influence fibre length 0.05 \[LessEqual] \[Lambda] \
\[LessEqual] 10 mm for fibres of width 20 \[Mu]m at the 1 mm scale of \
inspection:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.41233492915405*^9, 3.4123349343515234`*^9}, {
  3.412334976532176*^9, 3.4123350285970416`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Lambda]tab", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{".05", ",", ".5", ",", ".05"}], "]"}], ",", 
     RowBox[{"Range", "[", 
      RowBox[{".6", ",", "2", ",", ".1"}], "]"}], ",", " ", 
     RowBox[{"Range", "[", 
      RowBox[{"3", ",", "10", ",", "1"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Lambda]\[Rho]tab", " ", "=", " ", 
   RowBox[{"Prepend", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Lambda]tab", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", " ", 
         RowBox[{"\[Rho]x", "[", 
          RowBox[{
           RowBox[{"\[Lambda]tab", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", ".02", ",", "1", ",", "r"}], 
          "]"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "\[Lambda]tab", "]"}]}], "}"}]}], "]"}], ",", 
     " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"\[Lambda]\[Rho]tab", ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<\[Lambda]\>\"", ",", " ", "\"\<\[Rho]x\>\""}], "}"}]}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.3991060320820227`*^9, 3.3991060377702017`*^9}, {
   3.3991062305674305`*^9, 3.399106303392147*^9}, 3.399106334997594*^9, {
   3.399109120112392*^9, 3.399109259232437*^9}, {3.3991094609324675`*^9, 
   3.39910948333468*^9}, {3.39910951954675*^9, 3.39910952088868*^9}, 
   3.399109555618619*^9, {3.3991103237130847`*^9, 3.399110440881565*^9}, 
   3.399111202797146*^9, 3.411988047622173*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{0., 0.}, {0.05, 0.0009758013118518457}, {0.1, 
     0.0019120379499242839`}, {0.15000000000000002`, 0.002807830869406773}, {
     0.2, 0.003663748359204501}, {0.25, 0.00448050848004591}, {0.3, 
     0.005258871070239646}, {0.35000000000000003`, 0.005999612293891365}, {
     0.4, 0.0067035160450782715`}, {0.45, 0.007371370353613283}, {0.5, 
     0.008003965663717989}, {0.6, 0.009166548071262}, {0.7, 
     0.010197608939908141`}, {0.8, 0.011103502124760505`}, {0.9, 
     0.011890585820191401`}, {1., 0.012565220737551137`}, {1.1, 
     0.013135117479890317`}, {1.2000000000000002`, 0.013615378925329873`}, {
     1.3, 0.014023125953766188`}, {1.4, 0.014372834741384075`}, {1.5, 
     0.014675924160899292`}, {1.6, 0.014941127404889681`}, {
     1.7000000000000002`, 0.015175130267188131`}, {1.8000000000000003`, 
     0.015383132811496385`}, {1.9, 0.015569240351137836`}, {2., 
     0.015736737170429088`}, {3., 0.016797550157620647`}, {4., 
     0.017327956651213606`}, {5., 0.017646200547371767`}, {6., 
     0.017858363144811956`}, {7., 0.01800990785726473}, {8., 
     0.018123566391607174`}, {9., 0.018211967473875722`}, {10., 
     0.01828268833968635}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"\[Lambda]\"", TraditionalForm], 
    FormBox["\"\[Rho]x\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.399110357191224*^9, 3.3991104441162157`*^9}, {
   3.3991112054609756`*^9, 3.399111218790142*^9}, 3.3991834611896114`*^9, 
   3.404739382839625*^9, 3.411988047622173*^9}]
}, Open  ]],

Cell["\<\
Here we investigate the influence of fibre width 1 \[LessEqual] \[Omega] \
\[LessEqual]100 \[Mu]m for fibre length and inspection zone size 1mm and \
observe an approximately linear dependence:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4123350467431345`*^9, 3.412335118656541*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Omega]tab", " ", "=", " ", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"Range", "[", 
       RowBox[{"1", ",", "10", ",", "1"}], "]"}], ",", " ", 
      RowBox[{"Range", "[", 
       RowBox[{"20", ",", "100", ",", "10"}], "]"}]}], "]"}], "/", "1000"}]}],
   ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Omega]\[Rho]tab", " ", "=", " ", 
   RowBox[{"Prepend", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Omega]tab", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", " ", 
         RowBox[{"\[Rho]x", "[", 
          RowBox[{"1", ",", 
           RowBox[{"\[Omega]tab", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", "1", ",", "r"}], "]"}]}], 
        "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "\[Omega]tab", "]"}]}], "}"}]}], "]"}], ",", 
     " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"\[Omega]\[Rho]tab", ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<\[Omega]\>\"", ",", " ", "\"\<\[Rho]x\>\""}], "}"}]}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.3991060320820227`*^9, 3.3991060377702017`*^9}, {
   3.3991062305674305`*^9, 3.399106303392147*^9}, 3.399106334997594*^9, {
   3.399109120112392*^9, 3.399109259232437*^9}, {3.3991094609324675`*^9, 
   3.39910948333468*^9}, {3.39910951954675*^9, 3.39910952088868*^9}, 
   3.399109555618619*^9, {3.3991103237130847`*^9, 3.399110440881565*^9}, 
   3.399111202797146*^9, {3.3991113610547085`*^9, 3.3991114745579185`*^9}, {
   3.399111529727248*^9, 3.399111530648573*^9}, 3.411988047622173*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{0., 0.}, {0.001, 0.0006286368884429198}, {0.002, 
     0.001257265485773073}, {0.003, 0.0018858790910358872`}, {0.004, 
     0.0025144717043210775`}, {0.005, 0.003143037770013307}, {0.006, 
     0.0037715720547252833`}, {0.007, 0.004400069581214959}, {0.008, 
     0.005028525584431388}, {0.009, 0.005656935480243567}, {0.01, 
     0.006285294843151179}, {0.02, 0.012565220737549926`}, {0.03, 
     0.018835977878478582`}, {0.04, 0.025094455916428067`}, {0.05, 
     0.031337966508896496`}, {0.06, 0.037564126800309294`}, {0.07, 
     0.043770792371979325`}, {0.08, 0.0499560134191195}, {0.09, 
     0.05611800380735822}, {0.1, 0.06225511804326644}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"\[Omega]\"", TraditionalForm], 
    FormBox["\"\[Rho]x\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.399110357191224*^9, 3.3991104441162157`*^9}, 
   3.3991112054609756`*^9, 3.399111463001301*^9, {3.399111533262331*^9, 
   3.399111541213765*^9}, 3.39918346621684*^9, 3.40473938429275*^9, 
   3.411988047632187*^9}]
}, Open  ]],

Cell[TextData[{
 "To determine the variance and coefficient of variation of local areal \
density, ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["\[Beta]", "~"], TraditionalForm]]],
 " we define the functions ",
 StyleBox["var\[Beta]", "Input"],
 " and ",
 StyleBox["CV\[Beta]", "Input"],
 " according to Equations 4.34 and 4.35 respectively:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412335138394923*^9, 3.412335217168194*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Var\[Beta]", "[", 
   RowBox[{
   "\[Lambda]_", ",", "\[Omega]_", ",", "x_", ",", "\[Beta]bar_", ",", 
    "\[Delta]_"}], "]"}], ":=", 
  RowBox[{"\[Delta]", " ", "\[Beta]bar", " ", 
   RowBox[{
    RowBox[{"\[Rho]x", "[", 
     RowBox[{"\[Lambda]", ",", "\[Omega]", ",", "x", ",", "r"}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"\[Omega]", " ", "/", "1000"}], 
     ")"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CV\[Beta]", "[", 
   RowBox[{
   "\[Lambda]_", ",", "\[Omega]_", ",", "x_", ",", "\[Beta]bar_", ",", 
    "\[Delta]_"}], "]"}], ":=", 
  SqrtBox[
   RowBox[{"\[Delta]", " ", 
    RowBox[{
     RowBox[{"\[Rho]x", "[", 
      RowBox[{"\[Lambda]", ",", "\[Omega]", ",", "x", ",", "r"}], "]"}], "/", 
     
     RowBox[{"(", 
      RowBox[{"\[Omega]", " ", 
       RowBox[{"\[Beta]bar", "/", "1000"}]}], ")"}]}]}]]}]}], "Input",
 CellChangeTimes->{{3.3991851125741854`*^9, 3.3991851498277535`*^9}, {
   3.399185188273035*^9, 3.399185229642522*^9}, {3.399187096757301*^9, 
   3.3991871142925153`*^9}, {3.3991871455474577`*^9, 3.399187154259986*^9}, {
   3.3991872289674096`*^9, 3.399187240063365*^9}, 3.411988047632187*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Var\[Beta]", "[", 
  RowBox[{"4", ",", ".01", ",", "1", ",", "60", ",", 
   RowBox[{"1.5", " ", 
    SuperscriptBox["10", 
     RowBox[{"-", "4"}]]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"CV\[Beta]", "[", 
  RowBox[{"4", ",", ".01", ",", "1", ",", "60", ",", 
   RowBox[{"1.5", " ", 
    SuperscriptBox["10", 
     RowBox[{"-", "4"}]]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.3991852330273886`*^9, 3.3991852459259357`*^9}, {
   3.3991852911609807`*^9, 3.3991852940050707`*^9}, {3.3991857601954193`*^9, 
   3.399185760946499*^9}, {3.3991871623215775`*^9, 3.399187225973104*^9}, {
   3.399187709057746*^9, 3.399187730628763*^9}, 3.411988047632187*^9}],

Cell[BoxData["7.800328532416876`"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.399185296027979*^9, 3.399185762028054*^9, 3.3991871687007504`*^9, 
   3.399187242246504*^9, {3.3991877118517632`*^9, 3.3991877309892817`*^9}, 
   3.3991878429102163`*^9, 3.404739384449*^9, 3.411988047632187*^9}],

Cell[BoxData["0.04654844708120084`"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.399185296027979*^9, 3.399185762028054*^9, 3.3991871687007504`*^9, 
   3.399187242246504*^9, {3.3991877118517632`*^9, 3.3991877309892817`*^9}, 
   3.3991878429102163`*^9, 3.4047393845115*^9, 3.411988047632187*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.3 Layered Fibre Networks", "Section",
 Editable->False,
 CellChangeTimes->{{3.399885942736195*^9, 3.3998859673015184`*^9}, {
  3.412335275131541*^9, 3.4123352852661133`*^9}}],

Cell[CellGroupData[{

Cell["4.3.1 Fractional Contact Area", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.399885969825147*^9, 3.399885974481843*^9}, {
  3.412335296322011*^9, 3.4123353020802913`*^9}}],

Cell["\<\
From Equations 4.50 and 4.53, we obtain the fractional contact area of a \
network with infinite mean coverage in terms of network porosity only:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4123353332050467`*^9, 3.4123353742440577`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalPhi]2d", " ", "=", " ", 
   RowBox[{"1", " ", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Epsilon]"}], ")"}], "/", 
     RowBox[{"Log", "[", "\[Epsilon]", "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CapitalPhi]inf", " ", "=", " ", 
   RowBox[{"\[CapitalPhi]2d", " ", "+", " ", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "\[Epsilon]"}], ")"}], "2"], 
     RowBox[{"(", 
      RowBox[{"1", " ", "-", " ", "\[CapitalPhi]2d"}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"\[CapitalPhi]inf", " ", "=", " ", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"\[CapitalPhi]inf", ",", " ", 
    RowBox[{"0", "<", "\[Epsilon]", "<", "1"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.3998858710330915`*^9, 3.399885890771474*^9}, {
  3.399886012085915*^9, 3.399886022540949*^9}, {3.3998864025573854`*^9, 
  3.39988646315452*^9}}],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox[
   RowBox[{"\[Epsilon]", " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", "\[Epsilon]"}], ")"}], " ", 
       "\[Epsilon]"}]}], ")"}]}], 
   RowBox[{"Log", "[", "\[Epsilon]", "]"}]]}]], "Output",
 CellChangeTimes->{
  3.399886098640374*^9, {3.399886181028843*^9, 3.399886187478117*^9}, 
   3.399886403548811*^9, {3.3998864451386147`*^9, 3.3998864635851393`*^9}, 
   3.3998865199461823`*^9, 3.3998919911634064`*^9, 3.399892961979371*^9, 
   3.3998930350945053`*^9, 3.400921274458331*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"\[CapitalPhi]inf", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Epsilon]", ",", "0.0001", ",", "1"}], "}"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Epsilon]\>\"", ",", " ", 
      "\"\<\!\(\*SubscriptBox[\(\[CapitalPhi]\), \(\[Infinity]\)]\)\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.3998861887699747`*^9, 3.3998862746935263`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd1Hk81Hkcx/HZaii1UZS7HJNKB4lImreSe5OjQjkqRzqITmqdhUmLDkda
NWqFJE2nSocsiW3liIY0BmMMjfkNKbOOmZ3xx/fxfTwfn8f3n8/j+3jp7jvi
HjSNRCLtkx7ZHZFnFLPJQgPsN5onmiQEDvv3hKkUWqJFNaRwidR+h7QxZ489
oidSYwLEBDwjLJfSXu6Am7lSxfMJAobblFbUVu7C6R/MmZ/HCYhXclcr1PrD
L1ihhT9GwGPEQfPdQCD+rFVXJv9HwKpn7XVu6H6U58X+NVNEwKBp0WL5oQPw
XTFXSX6UwNj9ET2H0TBojBpX/xgh0GjmuqA3/jheOefb3xQSsLtnu/PE3yew
hZ/ZnEAQeEHZkE0mn4KAoSjYIyCQr2ygbkCLwh1Lc3tlPoHIoXGt/WkxYGYe
dPPoI3Cx1ePy8a3n8GxIl+H2lYDT5fqHVoJz8NS0jpLrIEB2cWyekZ6IcqMm
0bN2AqerqSqZDUlodNKyVWUSCHy8POuJx3mk/T6h9aKJgMVlSc5P7zRUf/fp
p9cQEBa0uFqtzcCa2mUXVBkEHgtPnwxIycD70pjw8FICpyx1clO6MhD2x5a0
mhLpvv492MdMz8SFOyaJ4XcIzP4hiT7Bz8Kjc03Me7ek+7ExvFt6OwfpF1cl
tWUQ8OmMIeuq0UHzfeQ+J5IAZ7bK1wRxPqKNs+tCLQncz13OyjK8j4lIVmda
uQBiB5vxukuPUeD/wUhnrQByCcKvZ8aew8d0psKqjEFQ+5qDq+TeQLD7sMW6
UT5CyZr6dFSCGvbAVNeWj93C68yFRBWOtd+k70n/hr1DG/buCq+BwmSbWxJ7
AFfd1DOfLq3DZPyKQoH2ALg183JZjA9gkOgG1MB+7FDtCNm06iPaqiM8J4p5
GOs+Gs4iGuBb6SUkWH3YaUteOM2kCVZsV9LKRX1w8jSfZ5LeDJ1ESj7FmYv6
He5HJL2fcJWebOd9uhd+nWNPHy5pxc+4+uArTzlIVrPZfjTuM14YKzXGd/Xg
ZYfaF9UqJj5Gr3zvotGD865pZbV67dicXGAUs7kbXAb/p9qZL2BzLjROP9KF
bbnMxS4vOzDssNzpQDFb+q8Db6SrsZClkdxwt6QT/r7RcmW+nch7buHlpM+C
uOwNb6MLGwNmc3Ju53dAPUcpymCcjRL9mXKxs77gBZaJ43O7YBFbNaCU1oal
rxVLA5y7sch7/FdF0Wd0PDykqDLajchbRW0eR1qhGpoWZJ7dg7mUQOFbuRYs
ksRx2Vs4YNYNk2hJzbi709JnksvBOZXpy58bNCGOEnKWl9gLl5TUiLJPDdCr
C2rxNuGCY1nRaN1RD0czQy1qMxfHXx0y9Nn2ARsjX6cWxfdhRqqLs+ONWpTF
qY8kUnh4Txv12rqqBlES3myTKh4iR5K6Ge1VkN9JcwmM6ActiRXUd7ASmkcF
ibOUB1Bx6ZZWxPoKjAdReKaVA7C2T+bKd5VDv6F+fHXYNxj3nR3uzyxDowQz
cufyIQrJb/SrfARn+Xjz9Jd87Fky+LqKfh/On2j+P/wG4WqTI9K5XYQrquT1
huJB6Pg7yAesvoUiE7eNvcUC5E1GOW83y4aNcuA65d8IxGn3aM5KTUbxP3a7
aqRdIYXX0kT9plBnPbDqkNki3t40yxQ0odbiIZl5N4bDN5sieMH3Hg1pl0gh
3DmD19ZCz58eGiazqNVD6GyCnOHRuAXSjpEYAY52Pkagqd8pDJiUWih+doxL
wegKlZRImSt8qQagIJgaezhVZleLa+3Z+tgSsGNNmcwXv7IdHPUgKfmlXEHa
SZL1JY1TXotx0npX/QOZSSHfhjkq6HWvZryTuSJm7pUsZWwPMr7yRWYdz5Z1
DvNhkiLnRZZ2lxTHG5nvqQhB88MuL5mtJ/lPODPgy9WuCpW54v2mNQ7T8EFE
K0iQmXT52X5PCbVY2/9QydT7NXL03hGqunHd1rdTczVxnjdBpW02M26dMmW1
Lo9D/bk9b/63KQcejRz8RA3aLy3QlEmihFIX6v9sJQ3V
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"\[Epsilon]\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(\[CapitalPhi]\\), \\(\[Infinity]\\)]\\)\"", 
     TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{{0.0001, 1}, {0., 0.9999782836221094}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.3998862752943907`*^9, 3.3998870474146447`*^9, 
  3.399891991804328*^9, 3.3998929622397456`*^9, 3.3998930353949375`*^9}]
}, Open  ]],

Cell[TextData[{
 "For networks of finite mean coverage, we must take account of the fraction \
of the total fibre length which is located in the surfaces of the network and \
is available for contact one side only. At points with coverage ",
 StyleBox["c ",
  FontSlant->"Italic"],
 "the fraction of fibre surfaces available for contact with other fibres is \
(c - 1)/c. The fraction of the network covered by fibres is (1 - P(0)), so \
the fraction of the network as a whole that is available for contact, ",
 StyleBox["f",
  FontSlant->"Italic"],
 ",  is:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123353954044847`*^9, 3.412335588432045*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"P", "[", "c_", "]"}], ":=", " ", 
  RowBox[{"PDF", "[", 
   RowBox[{
    RowBox[{"PoissonDistribution", "[", "cbar", "]"}], ",", " ", "c"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"f", " ", "=", " ", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"P", "[", "0", "]"}]}], ")"}]}], " ", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", "-", "1"}], ")"}], "/", "c"}], " ", 
        RowBox[{"P", "[", "c", "]"}]}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"c", ",", " ", "2", ",", " ", "\[Infinity]"}], "}"}]}], 
      "]"}]}], ",", " ", 
    RowBox[{"cbar", ">", "0"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.3998877248787904`*^9, 3.399887746519909*^9}, 
   3.3998901944799023`*^9, {3.4008299692579007`*^9, 3.4008299748759794`*^9}, {
   3.4009212423922224`*^9, 3.4009212426425824`*^9}}],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox[
   RowBox[{"EulerGamma", "-", 
    RowBox[{"ExpIntegralEi", "[", "cbar", "]"}], "+", 
    RowBox[{"Log", "[", "cbar", "]"}]}], 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["\[ExponentialE]", "cbar"]}]]}]], "Output",
 CellChangeTimes->{3.399890210112381*^9, 3.3998919970218306`*^9, 
  3.3998929648935614`*^9, 3.3998930371875153`*^9, 3.4009212796157475`*^9}]
}, Open  ]],

Cell[TextData[{
 "For networks with mean coverage ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["c", "_"], TraditionalForm]]],
 " greater than about 10, f is approximated by (",
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    RowBox[{"c", " "}], "_"], TraditionalForm]]],
 " - 1)",
 Cell[BoxData[
  FormBox[
   RowBox[{"/", 
    OverscriptBox["c", "_"]}], TraditionalForm]]],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123355985966606`*^9, 3.4123356692582674`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogLinearPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"1", " ", "-", " ", 
      RowBox[{"1", "/", "cbar"}]}], ",", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"cbar", ",", " ", "0.01", ",", " ", "100"}], "}"}], ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", " ", "Dashed", ",", "Dashed"}], "}"}]}], ",", 
   " ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", " ", 
     RowBox[{
     "\"\<\!\(\*OverscriptBox[\(c\), \(_\)]\)\>\"", ",", "\"\<f\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.399887942321458*^9, 3.399888029757184*^9}, {
  3.399888061302544*^9, 3.399888146054411*^9}, {3.3998909628147135`*^9, 
  3.3998909945503473`*^9}, {3.3998910250341806`*^9, 3.399891111568611*^9}, {
  3.399892915302253*^9, 3.399892936362536*^9}, {3.3998930124819903`*^9, 
  3.3998930230972548`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl2Hk0Vd3/B/CLe81znkrjJZVSkiKhPltlKKEiNKLMc8osbkRCXCIhQ4ZE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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Dashing[{Small, Small}], 
    LineBox[CompressedData["
1:eJwt0wk01F0bAHDLWIcx5pW9DUWlRaFUPJe3xVL2Sr2JfBFKliRkF1FJhERv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     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], Dashing[{Small, Small}], 
    LineBox[{{-4.605169998021961, 1.}, {-4.514776766648877, 
     1.}, {-4.424383535275793, 1.}, {-4.228390293172674, 
     1.}, {-4.045385191218652, 1.}, {-3.865969922911711, 
     1.}, {-3.671347875247818, 1.}, {-3.489713967733023, 
     1.}, {-3.292873280861276, 1.}, {-3.0996224276366102`, 
     1.}, {-2.919359714561042, 1.}, {-2.7238902221285217`, 
     1.}, {-2.5414088698450996`, 1.}, {-2.3625173512087585`, 
     1.}, {-2.1684190532154655`, 1.}, {-1.98730889537127, 
     1.}, {-1.790991958170123, 1.}, {-1.5982648546160574`, 
     1.}, {-1.4185258912110892`, 1.}, {-1.223580148449169, 
     1.}, {-1.0416225458363466`, 1.}, {-0.8444581638665725, 
     1.}, {-0.6508836155438794, 1.}, {-0.4702972073702841, 
     1.}, {-0.2745040198397369, 1.}, {-0.0916989724582874, 1.}, {
     0.08751624127608092, 1.}, {0.28193823436740106`, 1.}, {
     0.46337208730962354`, 1.}, {0.6600127196087978, 1.}, {0.853063518260891, 
     1.}, {1.0331261767638864`, 1.}, {1.2283956146238337`, 1.}, {
     1.4106769123346832`, 1.}, {1.5893683763984514`, 1.}, {
     1.7832666198191718`, 1.}, {1.9641767230907945`, 1.}, {2.160293605719369, 
     1.}, {2.343422348198846, 1.}, {2.5229612570312416`, 1.}, {
     2.717706945220589, 1.}, {2.899464493260839, 1.}, {3.0964288206580406`, 
     1.}, {3.2898033144081613`, 1.}, {3.4701896680091844`, 1.}, {
     3.665782800967159, 1.}, {3.848387793776036, 1.}, {4.027402952937831, 
     1.}, {4.221624891456578, 1.}, {4.402858689826227, 1.}, {
     4.599299267552829, 1.}, {4.602234632787395, 1.}, {4.605169998021962, 
     1.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox[
    "\"\\!\\(\\*OverscriptBox[\\(c\\), \\(_\\)]\\)\"", TraditionalForm], 
    FormBox["\"f\"", TraditionalForm]},
  AxesOrigin->{-4.605169998021961, 0},
  FrameTicks->{{Automatic, Automatic}, {{{-4.605170185988091, 
       FormBox["0.01`", TraditionalForm]}, {-2.3025850929940455`, 
       FormBox["0.1`", TraditionalForm]}, {0, 
       FormBox["1", TraditionalForm]}, {2.302585092994046, 
       FormBox["10", TraditionalForm]}, {4.605170185988092, 
       FormBox["100", TraditionalForm]}, {-3.912023005428146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.506557897319982, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.2188758248682006`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.995732273553991, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.8134107167600364`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.659260036932778, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.5257286443082556`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.4079456086518722`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.6094379124341003`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.203972804325936, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.916290731874155, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.6931471805599453, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.5108256237659905, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.3566749439387323, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.2231435513142097, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.10536051565782628`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.6931471805599453, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.0986122886681098`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3862943611198906`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6094379124341003`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.791759469228055, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9459101490553132`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0794415416798357`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.1972245773362196`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.995732273553991, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.4011973816621555`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.6888794541139363`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.912023005428146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.0943445622221, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.248495242049359, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.382026634673881, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.499809670330265, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{-4.605170185988091, 
       FormBox["\" \"", TraditionalForm]}, {-2.3025850929940455`, 
       FormBox["\" \"", TraditionalForm]}, {0, 
       FormBox["\" \"", TraditionalForm]}, {2.302585092994046, 
       FormBox["\" \"", TraditionalForm]}, {4.605170185988092, 
       FormBox["\" \"", TraditionalForm]}, {-3.912023005428146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.506557897319982, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.2188758248682006`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.995732273553991, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.8134107167600364`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.659260036932778, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.5257286443082556`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.4079456086518722`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.6094379124341003`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.203972804325936, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.916290731874155, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.6931471805599453, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.5108256237659905, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.3566749439387323, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.2231435513142097, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.10536051565782628`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.6931471805599453, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.0986122886681098`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3862943611198906`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6094379124341003`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.791759469228055, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9459101490553132`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0794415416798357`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.1972245773362196`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.995732273553991, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.4011973816621555`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.6888794541139363`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.912023005428146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.0943445622221, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.248495242049359, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.382026634673881, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.499809670330265, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  Method->{},
  PlotRange->{{-4.605169998021961, 4.605169998021962}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic},
  Ticks->{{{-4.605170185988091, 
      FormBox["0.01`", TraditionalForm]}, {-2.3025850929940455`, 
      FormBox["0.1`", TraditionalForm]}, {0, 
      FormBox["1", TraditionalForm]}, {2.302585092994046, 
      FormBox["10", TraditionalForm]}, {4.605170185988092, 
      FormBox["100", TraditionalForm]}, {-3.912023005428146, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-3.506557897319982, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-3.2188758248682006`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.995732273553991, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.8134107167600364`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.659260036932778, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.5257286443082556`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.4079456086518722`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.6094379124341003`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.203972804325936, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.916290731874155, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.6931471805599453, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.5108256237659905, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.3566749439387323, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.2231435513142097, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.10536051565782628`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.6931471805599453, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.0986122886681098`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.3862943611198906`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.6094379124341003`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.791759469228055, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.9459101490553132`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.0794415416798357`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.1972245773362196`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.995732273553991, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {3.4011973816621555`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {3.6888794541139363`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {3.912023005428146, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.0943445622221, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.248495242049359, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.382026634673881, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.499809670330265, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}, Automatic}]], "Output",
 CellChangeTimes->{{3.3998879528365774`*^9, 3.3998880305983934`*^9}, {
  3.3998880719778943`*^9, 3.399888146705347*^9}, {3.3998910322545633`*^9, 
  3.3998911122596045`*^9}, {3.399892936913328*^9, 3.3998929651939936`*^9}, {
  3.3998930245994143`*^9, 3.39989303869969*^9}},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "The fractional contact area of a network with finite mean coverage ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["c", "_"], TraditionalForm]]],
 " is therefore"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412335675607397*^9, 3.4123357071227136`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[CapitalPhi]c", " ", "=", " ", 
  RowBox[{"f", " ", "\[CapitalPhi]inf"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", 
    FractionBox[
     RowBox[{"EulerGamma", "-", 
      RowBox[{"ExpIntegralEi", "[", "cbar", "]"}], "+", 
      RowBox[{"Log", "[", "cbar", "]"}]}], 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", "cbar"]}]]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    FractionBox[
     RowBox[{"\[Epsilon]", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "+", "\[Epsilon]"}], ")"}], " ", 
         "\[Epsilon]"}]}], ")"}]}], 
     RowBox[{"Log", "[", "\[Epsilon]", "]"}]]}], ")"}]}]], "Output",
 CellChangeTimes->{3.3998918159815073`*^9, 3.399891997512536*^9, 
  3.3998929652640944`*^9, 3.39989303885992*^9}]
}, Open  ]],

Cell["and is most sensitive to porosity at low mean coverages:", "Text",
 Editable->False,
 CellChangeTimes->{{3.412335719440426*^9, 3.41233573196844*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{"\[CapitalPhi]c", ",", 
   RowBox[{"{", 
    RowBox[{"\[Epsilon]", ",", " ", "0", ",", " ", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"cbar", ",", " ", "0", ",", " ", "20"}], "}"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Epsilon]\>\"", ",", "\"\<\!\(\*OverscriptBox[\(c\), \(_\)]\)\>\"",
       ",", "\"\<\[CapitalPhi]c\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.399891549267992*^9, 3.3998917568665037`*^9}, {
  3.399891960839803*^9, 3.3998919722862625`*^9}}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1nHk4Vd/3+EmEJqlUSIMbKpShOc6ppG6T0ixJNNelJDSnOU26ihQyNEmR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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxFmXf8l1Mbx+/zPecu7VKokHbJTCS0jQZa2rRTImUne2bL3iNR9ihkS4RC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         "]], Polygon3DBox[CompressedData["
1:eJwtmmXAVUUXhc/dZy4oKDYigqTdYGGgqEhJSoqEIKEgKIpYhN3dLYJdYH4K
KqiAgQo2FogBioXdfuthzY/zvue5c26dmb332mtukyFje4yJoiiu1J+k/2uV
RfGETrpWimIH8UDxR+K7xGeJC/HD4kPEzYUtxa+ITxP3FbcQvyw+VdxHfI34
X/FH4qfFu4lfFZ8u7iceJl4mfkB8oXgf8ULxmeLB4qvF/4g/FD8lHiX+Qvyo
+HLxzeJKtSg+F88V3yIO8Rfi58UHid/Q9ReJR4oHiz8R3yM+R1xD/Ji4s3g7
cUPxXPFR4gPFDcRzxEPFbcRv6D5tr/MaOv9CR02NP67xLnpse3FV/Kj4UPG2
4trisfo8v+p5TcR1xc9pfKDG9xEn8SPiTuJtxNPFpa5fJX5ZPFQ8Xs+9X3wB
t188U9d3FG8tHi3+UvyY+ArxA+Iaev7P4sXiA8Wva/xC8QjxcPGn4gfFF4nn
67X/1vlfOubpfKTGP9P4w+JLND5CvFz8kPhi8TriJ8WHiXcVTxB/J35WfLP4
ppKboNcQz9FpT/FbGr9ZfKp4rPgr8ZPiq8W9xW+LbxGfJu4jfkd8q/h0cT/x
e+LbxZPEvcRvim8SnyLuK35XfJt4ovgI8Qfi6eIzxMeJvxb/T3yNuL94iXia
eIp4XfH/xD3FLcR1xE+Je4lbiv/TPXlI3FbcTLwna1XHQRXP58a6/hnxEeJW
rF+dj9b3/03Pa6zHdhTvq6OpzhtrfICu/1B8p/hM8bHiFeLHxVeKx4hXip8Q
XyW+je+iYwfxxuITNb5KPEt8g3hzYlPHbuJNxUdqfKn4XvG54kHij8V3i88W
byJ+VjxAvLf4JPG34mfEN4k3Es8W9xfvJR4v/kY8W3yj+HY+u46dxJsQH7y2
jj3E9cR36Pw+vrN4c/GGev4s8eHiPcV/sZbFrcUNiDdiUcde4s3EPXT9YvGN
4gnizZgrHduJNxJP5bvp2FtcXzxZ1/8sXiCeLt5FvLnu/0jxIeItNTac/KD3
/UXcVOMv6LFjNN5O3Fz/vyEGWNvEoI6fxJvpf0O+k65fV8/vpvOddc3W4k3E
g8Stxa3EjcXHibuK9xI3Eo8VdxFvK64rHizeX7xEr91K5+vofJWOD8X7iNfV
+Tc6QtfX1PUt8nw20mcdIf5E132X7+c6Vcc/+eLF0vfjg/DrHS5+XzxV45PF
G4hr6/oOOV/swFzpqCduxPrR+Hoa75HjeV7p+fso/HnOE/8ufl3jD4h/5D7q
aFDxPdtD41vo+WPEnXl98b7hfEn+3F5cT+NDcv7cQq/VMvlery/eTuObavxI
8QHincSbiYeLD871pGHV89VevLO4vniEuK14fXEtcXvxVuL64jri7uJdmC/9
f12f5zOXrjX1panGx+nx7uIfNPY9BVBc0bFa5x/r+Ja5IAb4rOKfddQnZvT8
Jnr+8TrvpmtOFn+va54T3yLeT9xM4+PFh/H5NXZs1fcsMafEqo46Ot8g15f1
q86n5J899f99Xfu1zmvlfL9W1fFNfC3W2I46r6nzL3VcovG/9Hrv6LFHxJeK
/xa/K35UvKu4gZ5/dF7vF4n/0Phb4hnic8W/iV8T3y9+i3vF9y38Hhdr/E+N
v63xmfn9l+v4qXANPFvjv2j8VY3fSzyJ55EDxR3y/LMexuX7xfpYoPET8v0/
R/yreKH4PvFp4h/EL4hvF58uXi1+UTyVeBbP556KO4qbiV8Uj8rrY6L4R/E8
8R3iSeKfxPPF08TXiv8TfyyeVbief6rjR5etop7GWiXH/obiJrp+Iw30y/mr
pf6/q+tX6nwtHXNK58M3w/NxtPhz8Qxdd2nONxtXnf/2yvVz7arrR1Pxc6Xz
+6KwnrhTnDT+jcZfETcWbyjuK94j54+VOn7XeW0dB1asLRpVXGPG6NpnSudK
ctnTOj+m6jW+TI/dL66Kf9LYIu6n/r/GnLLecz76SscfhXNUI12/ga7vo+t2
Fz9aWiegF5aId9f/93iOztfWsb/Gt9T1E/R4L+Jd/Ly+3zDxQYVr/z+lazEa
gNr8r/jawjWa2vd3aW1ADaTW/Ve69lDzWAspeW5ZE6yVMnltsGaY+2ryXLMG
iIU66KPCMcFar5Wcy1jzxELt5LVNTJDryHnE8vXh2Fo3OZaIMWJhneRYIyao
nZVk7UMNpVYipKml1ExyAzmCtXBBWCtF8uujmYj9jsm5lxzAWuucPNesOeb+
0OR7zxog15Hz4CaR11KyFmFNMVfMGblzl/Dar5FcG4kBcn2H5NxIzqeWHJJc
G6gpaO31krU6mhvtvn5yrKDhiR1iiPt3dzjXtk+ujeRcamU79EHhmkntaZuc
m6lB1OqaaIjCNZvcsVZy7JNDyAVrJ+cicsLjeq/Beo3vdL6QNSIeKl4tfoM1
JB4i/oE8L54h7i9eKV4gflh8uHiFeD5rSnwk8cC65zuIe4mXip8RzxQfIf5K
/FJe7wOzHice0TpoHtb7WmHtgoYhX6+dtQ0ah3peS/+3Ex+t53+t8z/12GN6
vUHib/V6r4ofEQ9gvGK9T64/ILn2k/Pv0nhP6r/OZ+uxe8V9xJ+Knyusa94O
5yL0zYpw/SA3kCO+DMcnteS3wjqC+kasoyfITeQoakNLclA4vxHLv+q4R2O9
dc0yvd+z5Hd9tpHid3RNXfGycH1l2a/WcZ+u76vx5RXrf/JNv9wPzBU/JT5K
/GPOP/Q7h1W91lhz5KthOT/RvywN5ydq9w+Fe7uNqA+Fezx6vw2Tez16QJL4
BsnvxXuihdBEx4lHhbXlCvHJhTXmInEn1oT4iHCv+KX46MI9I73GytK9Cz0H
vcN3pXsLegh6m69K9y70OPQe35fW9vQg9FK/5/inp6KXXl1ai9NT0wv8ULq3
pidAu/8sPq+whqdX+7V070XPRq/8S+nejZ6Z3uy30r0aPRpa/8fSvS2an97q
69K9FD0WvdI3pXspeibm5qrkueJ+EStXUz8Lx8y3uic7UX9ZSxXHxrXJsUWM
EGvXJMcWMUcsXZa8VokperdvS2tRejjW0uXJscaaYq1cmbyWWTP0fqtK93L0
gK+J9xX3EHcO99qLSnsT9Nxo8a56bL/Cmhwt2T1Za6MpiZUrktcuMUOvRM9E
/a4Z9gJ+Kt0r4QngPXye1wMeBFrmk9JaA02D1vi4tLZBc9BLfFRae6BRqXXU
vN3EO4e1ylJxp8KaZT2dP63Held8zUs637F0bWwd9jb+KN3L43HQG/5Vuhek
R8Qb2Dg5F5GT0ApoBvLzE+Havkly7BBD9BL0FOTfDcPeQF30SmGPAO/gz9K9
Jx4CXsEXpb0SPAO02rJ8/9FseDuflvZ68HjoJd8v7WXQU9ILv1e6t6Qnppd8
t3RvTE+J9/MZObmwB0T+6ZKsrdBI9IrvlNZKMN7S8tJeER4T9457uKW4cdir
WizesbBnhXfzYb6feDh4Nx+U7kXoSfBelqBJC3sw9P5vle718QDwNt4srcWp
x3gBb+f5xBOg98cDoD9cV+//oM7/DeutOmEvCU+J3nfTsB4Yn+P13HB+R9NT
bzfK84FnQ/56Ns8fOZP89Uy4XtOjHSDePrwem+f7u0euv/Q8rPftwvO1Q/6+
+4XXMz0PWvvQ8Hptmu/vbuH13CzPz+55vW6Z53PP8Hztltf/IeH5aJnXf9vw
emiR1//B4fmjR6U3bR7WA/TQ9MrbhvUMmpbebdewfjop57fzwnrutLz+L8n6
ZVLWg5eH9d3EHA+XhfXg6Xn9Xpr11YScD88P6yt6rDbiHcL6Y3LWn1eE9cfZ
WV9ek/UUGh091iCsj/g+rM9mYT1DT40+axrWk/RQ6L/rwvqFngb9d21YX9Jz
oU9vCetHeir0663h+MBzwSvcMrz+eH96g4Y5H4zK9WZiuJ6MzPn7lHD8js71
ZlJYP4/J9WVKOH8cm+vL5HA+xlMbS74K6+/jcv47M1wf8NTGiI/O9fCgHH+9
wvUQD+4Y8bBcT3vkfHFUuN7g6Y0WjwjXRzzAUeLh4fyOx3eseGQ43xyY80nP
cP7AU8OL3SrcL4zN9eyMcD0cnuvZhHC8N8zxu1M4vuvm+rBNOD/heeHNbh2O
Zzy+5uJG4fjHA2wm3iKcLxrk+N8xXF9H5Hp0crg+47HhTZ0Qrrd4bOPFx4fr
87CsB04K13c8vxPEY8P6AI9ynBjjHT2BJ3k89SGsD/DcTxQfl+sTnvVJ4nFh
rXhdsjb9OvdHeIJ45+eE9REeOP3Kw+I7iH09toRcV/i99qDmV/yex5ALxHdU
7Iey1lpVrW1Yc3wX/Ge0Dd+pA/dW41PEgwr703tWrY3QSB3JxeIzKvbv23Pv
xZPFA6nh4l3E54iHkpPEO4vPFg8pvBa2qbq2sCbaEhviiWgPcTvWhniSeEBh
7bZT1bWams1a3L3q2sWanEbtEn9Q8f7BH2FvdlNxk4q9XTxevNX1wt46+Rmv
ZeOwl4+nj9dYN+zV49njVW6S9Qh7AHiZ9cJ7I4hVvNH1w14CPTm9OJ4C3s8o
8VYVe0DPkYP0v0qvlT/f72GvGP8Y7xj/iT6f/r5NxeN8djy82uHHOMeTo8/Y
H51Qcb+BX4e/ideE/0Q/i2c0TXybHu9CrtPnOVdjR+mxbsSS+HzxcGKO2iJ+
Snx94VzZpupenJx5PrVGPEd8KzmJ2iqeKb6scC5vXbWWIaefRS0TP12xf32q
eD/xIxXv51DP2YNqqPPNwv07ntZ08e1h/UPPQK/weFj/swdEP/4QTU3VexD0
8w+G+1n2kOgv7wz3s+xJ0V/eFe638XjwiluIuxL7euw8fZ5heuwCtIR4rvi2
wrm8bdVeAzmd1+5Qde/Ke1xFLRS/UrEfRmzuU/X+DTE6jtotvq/i/ZzuaAvx
BRXvz1wpbid+WXyP+ELxweLnK/bDLuezil8S380ciruK3xM/Ufi7d6nay+Ae
3CjuLH6zYr/vBvGh4sXih8XXizuJFxEL4qnibuL30ULUNGq/+A3xg4V7UXpS
etcnw14Xnhf6/tTwa5+b/Fq8B2udNb+c9afx7XW+oPTa/Kuwv98kuXf8vPDe
SZvk+CRO8eMaJ/d+nxX2r/9BV1TsP++c3J8QO//paK7nty6dW7qG91/wYFn7
/xT2wnYhRiv2xHbV+SxdX6Pix/Cn/9Tj3xf2gMkdFyfnTnIIvS89MP4oPile
+bwc/+x5oAdfzvXk4Irzwaul9Sp7pvgD8/P6bp315Eu53uPfoC3xnPGa0Zj4
xewB0KtzD/Eatk7u5fEcyIXtcr3tE/Ymtkru3fEodtd5rdJeP/eU3oc9EbwC
eiByc/tcj/uGc3uHXP/7hXNv21y/e4e9dzz4nuIDwv0XeyJ4/3uF9zrY82Dv
o1V4L4Y9GbzANmEvGk+6N7k+7KXjqVNLOoa9efQqtaNT2PtHX7KXfFC4v2PP
gL2WvcN7D+xBrKkN4b0X9mCoDe3DezPs0VB7OoTz/Su5/rOnx94EHjXe9D5h
7xIPc00uDNciahKxeZh4a9Zn6dzYQ7wVfk3pXNE9XPuogeirw8O1iRqF/9A/
XJt6ZP0wNBz73XN9HxLOvd2ynjgynGvIOcTuzeHc1DXrg8HhWto564mB4Vze
JeuNQbmeLSytx/H3Zogrpb2bDcJ7R+wh0a+wp4Y3hb+L/4xH1S/3I3g1s8P9
Oh4P3tussDeHR/eheEHYW8Nj+0j8UjhW8MjxxokZ9uJa67EVhb0rvDw8vU/E
r4T9Bzy7d8Rzwt4eHt/H4pdZH3rus6VzBZ59s2QP/YvCexJ4S3hMS3X+atif
wBN8Vzw36yc8t/fFL4TvBfekXcUx+nfYr1sVjtH6yTFPrPOZmUs8oysrnlO8
CTyKs7L+oJenpz+x4p6ZXEROOqnimME/wWN8T+fPh71FPEa89BfD/gieG97k
U+HekpxCLiFHsNZYcydXHEPUVmosteHisHeGh7ZMvDDsx+BxrvFOw3sVc/L8
s4fLWmZNn1JxjLHXuF9y7sMrxC+Zm/UQfuT0fL/RN+xJT8vzgX5ijxatg+Yh
V1fD/ugLWT+xx7ttXm/sVbLHgJ/6fNZT7CHzW4kDk/cz2NfYO3lPHS3EY/g5
eKB4vU+Hax81cJ54Rjhfo/nWeLfh2kyNRvtND9c6ah7+071hr5b8zV4nni21
mxpOvp8WrrXUXGrr1HBtpkZTG+/I9Y6air90X1hro7nxxx4J11JqKv7YzLDX
iX7B630sXJup0fhf94drNzV8jviBsDZCI63RHuH7w29K8O83z/lgdHK+QrMQ
X+R3/OMaYa2P5p8iHh3W9ick87Sc/3ok+wvs0ZKfxibnOzQ0+WlMcr5Do5Cf
jk3Od2hE8nuv5H6ePXfyz6jk+oumpLegx1ijBcPa50SNn19YA9E7HJ/8Ww56
CPyTN0r3a/wmh71g9oTZS90/14v+yfmfPVjy9aDk2GLPie9HD4OWPD2cD25J
zld4zsTO4OR6RAyh718v3W/ymx30/Wul+3F+k0M83Zqc//DT6FXoWeidBoS1
IRoRvXNjWOuNT9Z2aD6026Tk+UPDoaVPEV9XWFMTvycnf140MvVjRHI9pIei
nnZL9k/4DQHr74xk7YdGZH1OEd9VWBNSD45J7qXosag/I5PrKT0S2vvUZC2P
Bqd+9hUfWngPH+2OhkfLXxiOhzOTtSialvU4IXk+0ezU897J+pk9ZnoBegK0
4g25fk1Ozk9oZu7XxOTXR1MTn2cla2U0NLnoyOTcRk6i1zgtuVeg56CeH56s
L/jNBfqgT/L+Bf4r9b9fsh7hNxjUoxuT8x97PuiXnsn7Y/yGgPpyU3K+ZQ+J
+Ds/ud6ioalvNyTrXfag8MMf0vd7u3DvRq2gZtQp3Huhx45K1iP0qOSDi5Lz
xZJcX9kD+qDwb6/I/9cn5wP8XPTPEcl6ZFxeL/RgzDe/0WP+6KGYj6vCepZ8
j9/7Xfh+0aNxP6/O65EehPt3do4/ehDm/6ycny5Mzm9ofvTOkORaQA+OHif/
sr9XP1zLBibHIzUNvTg8WV9NyXp/dum9c3pcfgvBbyJYj13C8Y5nQHycmPXl
UD2/f+Een/qD3qVfLcP6dFiynsNDIH9ekpzP2TPitxXo+8aFe2HqwQXixwv3
ROTX85J7HXog9MbNyfVjdY5PeizGb8r14Zzk9UtPRO9DD8R+xj0a/z9Jswru

         "]], Polygon3DBox[CompressedData["
1:eJwt1nfclfMbB/Cn0/PYIg0S4ddA0qBCNLT33rukpF2aGrT30N570dZWIaFS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         "]], 
        Polygon3DBox[{{1050, 1086, 518, 306, 305, 725}}]}]}, {}, {}, {}}, {
     Line3DBox[{274, 1, 267, 239, 762, 16, 269, 765, 31, 778, 46, 793, 61, 
      808, 76, 823, 91, 838, 106, 853, 121, 868, 136, 883, 151, 898, 166, 913,
       181, 928, 196, 1071, 255, 276, 211, 272, 261, 501, 212, 502, 213, 503, 
      214, 504, 215, 505, 216, 506, 217, 507, 508, 218, 509, 219, 510, 220, 
      511, 221, 512, 222, 513, 223, 514, 224, 752, 257, 277, 225, 273, 262, 
      955, 210, 941, 195, 926, 180, 911, 165, 896, 150, 881, 135, 866, 120, 
      851, 105, 836, 90, 821, 75, 806, 60, 791, 45, 777, 30, 1067, 251, 275, 
      15, 271, 259, 319, 14, 317, 13, 315, 12, 313, 11, 311, 10, 309, 9, 307, 
      8, 304, 303, 7, 301, 6, 299, 5, 297, 4, 295, 3, 293, 2, 753, 258, 
      274}], {Line3DBox[{762, 1054, 1075, 1085, 1383, 1055, 1047, 1076, 1387, 
       956, 1056, 1048, 1081, 1390, 957, 1057, 1049, 1187, 958, 1058, 1183, 
       1188, 959, 1059, 1184, 1189, 960, 1060, 1384, 1050, 1086, 1382, 1061, 
       1051, 1190, 961, 1062, 1052, 1191, 962, 1063, 1053, 1192, 963, 1064, 
       1185, 1193, 964, 1065, 1186, 1194, 965, 763, 1195, 966, 764, 1385, 
       1066, 967, 1067}], 
      Line3DBox[{765, 1068, 1078, 284, 1389, 1074, 1069, 1084, 524, 1080, 
       1079, 1196, 968, 766, 1197, 969, 767, 1198, 970, 768, 1199, 971, 769, 
       1200, 1087, 1287, 770, 1088, 1288, 771, 1201, 972, 772, 1202, 973, 773,
        1203, 974, 774, 1204, 975, 775, 1205, 976, 776, 1206, 977, 777}], 
      Line3DBox[{778, 1077, 1089, 1388, 1083, 1082, 1090, 1391, 779, 1091, 
       1289, 780, 1207, 978, 781, 1208, 979, 782, 1209, 980, 783, 1210, 1092, 
       1290, 784, 1093, 1291, 785, 1094, 1292, 786, 1211, 981, 787, 1212, 982,
        788, 1213, 983, 789, 1214, 984, 790, 1215, 985, 791}], 
      Line3DBox[{793, 1095, 1293, 792, 1096, 1294, 794, 1097, 1295, 795, 1098,
        1296, 796, 1216, 986, 797, 1217, 987, 798, 1218, 1099, 1297, 799, 
       1100, 1298, 800, 1101, 1299, 801, 1102, 1300, 802, 1219, 988, 803, 
       1220, 989, 804, 1221, 990, 805, 1222, 991, 806}], 
      Line3DBox[{808, 1103, 1301, 807, 1104, 1302, 809, 1105, 1303, 810, 1106,
        1304, 811, 572, 812, 1223, 992, 813, 1224, 1107, 1305, 814, 1108, 
       1306, 815, 1109, 1307, 816, 1110, 1308, 817, 1111, 1309, 818, 1225, 
       993, 819, 1226, 994, 820, 1227, 995, 821}], 
      Line3DBox[{823, 1112, 1310, 822, 1113, 1311, 824, 1114, 1312, 825, 1115,
        1313, 826, 1116, 1314, 827, 1228, 996, 828, 1229, 1117, 1315, 829, 
       1118, 1316, 830, 1119, 1317, 831, 1120, 1318, 832, 1121, 1319, 833, 
       1122, 1320, 834, 1230, 997, 835, 1231, 998, 836}], 
      Line3DBox[{106, 396, 107, 397, 108, 398, 109, 399, 110, 400, 111, 401, 
       112, 402, 403, 113, 404, 114, 405, 115, 406, 116, 407, 117, 408, 118, 
       409, 119, 410, 120}], 
      Line3DBox[{838, 1123, 1321, 837, 1124, 1322, 839, 1125, 1323, 840, 1126,
        1324, 841, 1127, 1325, 842, 1128, 1326, 843, 1232, 1129, 1327, 844, 
       1130, 1328, 845, 1131, 1329, 846, 1132, 1330, 847, 1133, 1331, 848, 
       1134, 1332, 849, 1135, 1333, 850, 1233, 999, 851}], 
      Line3DBox[{853, 1234, 1000, 852, 1235, 1001, 854, 1236, 1002, 855, 1237,
        1003, 856, 1238, 1004, 857, 1239, 1005, 858, 1240, 1136, 1334, 859, 
       1241, 1006, 860, 1242, 1007, 861, 1243, 1008, 862, 1244, 1009, 863, 
       1245, 1010, 864, 1246, 1011, 865, 1247, 1012, 866}], 
      Line3DBox[{868, 1137, 1335, 867, 629, 869, 1248, 1013, 870, 1249, 1014, 
       871, 1250, 1015, 872, 1251, 1016, 873, 1252, 1138, 1336, 874, 1139, 
       1337, 875, 1253, 1017, 876, 1254, 1018, 877, 1255, 1019, 878, 1256, 
       1020, 879, 1257, 1021, 880, 1258, 1022, 881}], 
      Line3DBox[{883, 1140, 1338, 882, 1141, 1339, 884, 1259, 1023, 885, 1260,
        1024, 886, 1261, 1025, 887, 1262, 1026, 888, 1263, 1142, 1340, 889, 
       1143, 1341, 890, 1144, 1342, 891, 1264, 1027, 892, 1265, 1028, 893, 
       1266, 1029, 894, 1267, 1030, 895, 1268, 1031, 896}], 
      Line3DBox[{898, 1145, 1343, 897, 1146, 1344, 899, 1147, 1345, 900, 1269,
        1032, 901, 1270, 1033, 902, 1271, 1034, 903, 1272, 1148, 1346, 904, 
       1149, 1347, 905, 1150, 1348, 906, 1151, 1349, 907, 1273, 1035, 908, 
       1274, 1036, 909, 1275, 1037, 910, 1276, 1038, 911}], 
      Line3DBox[{913, 1152, 1350, 912, 1153, 1351, 914, 1154, 1352, 915, 1155,
        1353, 916, 1277, 1039, 917, 1278, 1040, 918, 1279, 1156, 1354, 919, 
       1157, 1355, 920, 1158, 1356, 921, 1159, 1357, 922, 1160, 1358, 923, 
       1280, 1041, 924, 1281, 1042, 925, 1282, 1043, 926}], 
      Line3DBox[{928, 1161, 1359, 927, 1162, 1360, 929, 1163, 1361, 930, 1164,
        1362, 931, 1165, 1363, 932, 1283, 1044, 933, 1284, 1166, 1364, 934, 
       1167, 1365, 935, 1168, 1366, 936, 1169, 1367, 937, 1170, 1368, 938, 
       1171, 1369, 939, 1285, 1045, 940, 1286, 1046, 941}], 
      Line3DBox[{955, 1073, 1072, 1386, 954, 1381, 1182, 953, 1380, 1181, 952,
        1379, 1180, 951, 1378, 1179, 950, 1377, 1178, 949, 1376, 1177, 948, 
       1375, 709, 947, 1374, 1176, 946, 1373, 1175, 945, 1372, 1174, 944, 
       1371, 1173, 943, 1370, 1172, 942, 749, 1070, 1071}]}, {
      Line3DBox[{293, 717, 735, 516, 1387, 294, 283, 756, 524, 322, 758, 1391,
        539, 337, 1294, 554, 352, 1302, 569, 367, 1311, 584, 382, 1322, 599, 
       397, 614, 1235, 412, 629, 427, 1339, 644, 442, 1344, 659, 457, 1351, 
       674, 472, 1360, 689, 487, 1370, 704, 502}], 
      Line3DBox[{295, 718, 736, 517, 1390, 296, 755, 525, 1196, 323, 1289, 
       540, 338, 1295, 555, 353, 1303, 570, 368, 1312, 585, 383, 1323, 600, 
       398, 615, 1236, 413, 630, 1248, 428, 645, 1259, 443, 1345, 660, 458, 
       1352, 675, 473, 1361, 690, 488, 1371, 705, 503}], 
      Line3DBox[{297, 228, 1187, 298, 526, 1197, 324, 541, 1207, 339, 1296, 
       556, 354, 1304, 571, 369, 1313, 586, 384, 1324, 601, 399, 616, 1237, 
       414, 631, 1249, 429, 646, 1260, 444, 661, 1269, 459, 1353, 676, 474, 
       1362, 691, 489, 1372, 706, 504}], 
      Line3DBox[{299, 719, 737, 720, 1188, 300, 527, 1198, 325, 542, 1208, 
       340, 557, 1216, 355, 572, 370, 1314, 587, 385, 1325, 602, 400, 617, 
       1238, 415, 632, 1250, 430, 647, 1261, 445, 662, 1270, 460, 677, 1277, 
       475, 1363, 692, 490, 1373, 707, 505}], 
      Line3DBox[{301, 721, 738, 722, 1189, 302, 528, 1199, 326, 543, 1209, 
       341, 558, 1217, 356, 573, 1223, 371, 588, 1228, 386, 1326, 603, 401, 
       618, 1239, 416, 633, 1251, 431, 648, 1262, 446, 663, 1271, 461, 678, 
       1278, 476, 693, 1283, 491, 1374, 708, 506}], 
      Line3DBox[{303, 723, 739, 1384, 725, 305, 529, 1200, 327, 544, 1210, 
       342, 559, 1218, 357, 574, 1224, 372, 589, 1229, 387, 604, 1232, 402, 
       619, 1240, 417, 634, 1252, 432, 649, 1263, 447, 664, 1272, 462, 679, 
       1279, 477, 694, 1284, 492, 709, 507}], 
      Line3DBox[{307, 726, 741, 519, 1190, 308, 1288, 531, 329, 1291, 546, 
       344, 1298, 561, 359, 1306, 576, 374, 1316, 591, 389, 1328, 606, 404, 
       621, 1241, 419, 1337, 636, 434, 1341, 651, 449, 1347, 666, 464, 1355, 
       681, 479, 1365, 696, 494, 1376, 711, 509}], 
      Line3DBox[{309, 727, 742, 520, 1191, 310, 532, 1201, 330, 1292, 547, 
       345, 1299, 562, 360, 1307, 577, 375, 1317, 592, 390, 1329, 607, 405, 
       622, 1242, 420, 637, 1253, 435, 1342, 652, 450, 1348, 667, 465, 1356, 
       682, 480, 1366, 697, 495, 1377, 712, 510}], 
      Line3DBox[{311, 728, 743, 521, 1192, 312, 533, 1202, 331, 548, 1211, 
       346, 1300, 563, 361, 1308, 578, 376, 1318, 593, 391, 1330, 608, 406, 
       623, 1243, 421, 638, 1254, 436, 653, 1264, 451, 1349, 668, 466, 1357, 
       683, 481, 1367, 698, 496, 1378, 713, 511}], 
      Line3DBox[{313, 729, 744, 730, 1193, 314, 534, 1203, 332, 549, 1212, 
       347, 564, 1219, 362, 1309, 579, 377, 1319, 594, 392, 1331, 609, 407, 
       624, 1244, 422, 639, 1255, 437, 654, 1265, 452, 669, 1273, 467, 1358, 
       684, 482, 1368, 699, 497, 1379, 714, 512}], 
      Line3DBox[{315, 731, 745, 732, 1194, 316, 535, 1204, 333, 550, 1213, 
       348, 565, 1220, 363, 580, 1225, 378, 1320, 595, 393, 1332, 610, 408, 
       625, 1245, 423, 640, 1256, 438, 655, 1266, 453, 670, 1274, 468, 685, 
       1280, 483, 1369, 700, 498, 1380, 715, 513}], 
      Line3DBox[{317, 522, 1195, 318, 536, 1205, 334, 551, 1214, 349, 566, 
       1221, 364, 581, 1226, 379, 596, 1230, 394, 1333, 611, 409, 626, 1246, 
       424, 641, 1257, 439, 656, 1267, 454, 671, 1275, 469, 686, 1281, 484, 
       701, 1285, 499, 1381, 716, 514}], 
      Line3DBox[{319, 746, 1385, 747, 320, 537, 1206, 335, 552, 1215, 350, 
       567, 1222, 365, 582, 1227, 380, 597, 1231, 395, 612, 1233, 410, 627, 
       1247, 425, 642, 1258, 440, 657, 1268, 455, 672, 1276, 470, 687, 1282, 
       485, 702, 1286, 500, 750, 1386, 751, 752}], 
      Line3DBox[{501, 703, 749, 486, 688, 1359, 471, 673, 1350, 456, 658, 
       1343, 441, 643, 1338, 426, 628, 1335, 411, 1234, 613, 396, 598, 1321, 
       381, 583, 1310, 366, 568, 1301, 351, 553, 1293, 336, 538, 1388, 759, 
       761, 760, 321, 523, 1389, 757, 754, 748, 292, 515, 1383, 734, 733, 
       753}], Line3DBox[{508, 710, 1375, 493, 695, 1364, 478, 680, 1354, 463, 
       665, 1346, 448, 650, 1340, 433, 635, 1336, 418, 620, 1334, 403, 605, 
       1327, 388, 590, 1315, 373, 575, 1305, 358, 560, 1297, 343, 545, 1290, 
       328, 530, 1287, 306, 518, 1382, 740, 724, 304}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJxsfHc41e//vy2KQkqUbMqmIetZ2SOErIjsvRJZUSIK2VuFMioZKSPckr2y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    "]],
  Axes->True,
  AxesLabel->{
    FormBox["\"\[Epsilon]\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*OverscriptBox[\\(c\\), \\(_\\)]\\)\"", TraditionalForm], 
    FormBox["\"\[CapitalPhi]c\"", TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{0, 1}, {0, 20}, {0., 0.9472021997555544}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.399891570558606*^9, 3.399891589155347*^9}, {
   3.399891654409178*^9, 3.3998917575875406`*^9}, 3.399891926590555*^9, 
   3.399891997792939*^9, 3.399892965534483*^9, 3.399893039140323*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
The region of greatest sensitivity to porosity is found by plotting the \
derivative with respect to \[Epsilon]:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4123357509857855`*^9, 3.412335773207739*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"D", "[", 
     RowBox[{"\[CapitalPhi]inf", ",", " ", "\[Epsilon]"}], "]"}], "]"}], ",", 
   " ", 
   RowBox[{"{", 
    RowBox[{"\[Epsilon]", ",", " ", "0", ",", " ", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.399894439053299*^9, 3.3998944629777007`*^9}, {
  3.3998945987729645`*^9, 3.3998946135442047`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nk4VV0XAHBjeVWmvEIkUyGpr0RKFlJKhKIoaSChQpKKZEyKayhJMqXB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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, -1.2000000000000002`},
  PlotRange->{{0, 1}, {-1.231240833027007, -0.11932614021584007`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.3998944637087517`*^9, {3.39989461412504*^9, 3.3998946277145805`*^9}}]
}, Open  ]],

Cell["\<\
and the location of the steepest point in the gradient is found from the \
second derivative:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412335783111981*^9, 3.412335800386821*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"\[CapitalPhi]inf", ",", " ", 
      RowBox[{"{", 
       RowBox[{"\[Epsilon]", ",", " ", "2"}], "}"}]}], "]"}], " ", "\[Equal]",
     " ", "0"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Epsilon]", ",", " ", "0.4"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.3998944848791933`*^9, 3.39989451439163*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Epsilon]", "\[Rule]", "0.38568101151184886`"}], "}"}]], "Output",\

 CellChangeTimes->{3.399894514802221*^9, 3.3998947810350447`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.3.2 In-Plane Distribution of Fractional Contact Area", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.3999771110296707`*^9, 3.3999771244189234`*^9}, {
  3.4123358118533087`*^9, 3.4123358187031584`*^9}}],

Cell[TextData[{
 "Consider a random fibre network with mean coverage ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["c", "_"], "=", 
    RowBox[{"4.", " ", 
     StyleBox["We", "Text"], 
     StyleBox[" ", "Text"]}]}], TraditionalForm]]],
 "capture most of the distribution by covering points with coverage up to \
10:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123359026538734`*^9, 3.4123359536972704`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDF", "[", 
  RowBox[{
   RowBox[{"PoissonDistribution", "[", "4.", "]"}], ",", " ", "10"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.399976365978339*^9, 3.3999763907339363`*^9}, {
   3.399976470839122*^9, 3.3999765180269747`*^9}, 3.399977307592314*^9, {
   3.3999774870904193`*^9, 3.3999775231923313`*^9}, {3.399979315589672*^9, 
   3.3999793189845533`*^9}}],

Cell[BoxData["0.9971602338794863`"], "Output",
 CellChangeTimes->{{3.3999775241236706`*^9, 3.3999775499307795`*^9}, 
   3.3999786110566034`*^9, {3.399979320697016*^9, 3.399979341196493*^9}, {
   3.411743117569128*^9, 3.4117431318396482`*^9}}]
}, Open  ]],

Cell[TextData[{
 "All possible values of ",
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["\[CapitalPhi]", "c", "points"], TraditionalForm]]],
 "are obtained as the combinations of the (integer) number of interfaces 0 \
\[LessEqual] nint \[LessEqual] c -1 occurring at points with (integer) \
coverage ",
 StyleBox["c. ",
  FontSlant->"Italic"],
 "The command ",
 StyleBox["Union", "Input"],
 " removes duplicate entries. For the case we have just considered with ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["c", "_"], TraditionalForm]]],
 " = 4 we obtain 32 possible values of ",
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["\[CapitalPhi]", "c", "points"], TraditionalForm]]],
 " :"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123360039996014`*^9, 3.4123362680092287`*^9}, 
   3.412415921855835*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Union", "[", 
  RowBox[{"Flatten", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"nint", "/", "c"}], ",", "  ", 
     RowBox[{"{", 
      RowBox[{"c", ",", " ", "1", ",", " ", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"nint", ",", " ", "0", ",", " ", 
       RowBox[{"c", "-", "1"}]}], "}"}]}], "]"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Length", "[", "%", "]"}]}], "Input",
 CellChangeTimes->{{3.399976419795725*^9, 3.3999764448717823`*^9}, {
   3.399976526218754*^9, 3.3999766536720223`*^9}, 3.399976687710968*^9, {
   3.3999770396370125`*^9, 3.399977092012325*^9}, {3.3999771747412834`*^9, 
   3.399977185656979*^9}, {3.3999785811435905`*^9, 3.3999785871021585`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox["1", "10"], ",", 
   FractionBox["1", "9"], ",", 
   FractionBox["1", "8"], ",", 
   FractionBox["1", "7"], ",", 
   FractionBox["1", "6"], ",", 
   FractionBox["1", "5"], ",", 
   FractionBox["2", "9"], ",", 
   FractionBox["1", "4"], ",", 
   FractionBox["2", "7"], ",", 
   FractionBox["3", "10"], ",", 
   FractionBox["1", "3"], ",", 
   FractionBox["3", "8"], ",", 
   FractionBox["2", "5"], ",", 
   FractionBox["3", "7"], ",", 
   FractionBox["4", "9"], ",", 
   FractionBox["1", "2"], ",", 
   FractionBox["5", "9"], ",", 
   FractionBox["4", "7"], ",", 
   FractionBox["3", "5"], ",", 
   FractionBox["5", "8"], ",", 
   FractionBox["2", "3"], ",", 
   FractionBox["7", "10"], ",", 
   FractionBox["5", "7"], ",", 
   FractionBox["3", "4"], ",", 
   FractionBox["7", "9"], ",", 
   FractionBox["4", "5"], ",", 
   FractionBox["5", "6"], ",", 
   FractionBox["6", "7"], ",", 
   FractionBox["7", "8"], ",", 
   FractionBox["8", "9"], ",", 
   FractionBox["9", "10"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.399977217552843*^9, 3.3999782381303616`*^9, {3.3999785875127487`*^9, 
   3.3999786112068195`*^9}, 3.3999793414768963`*^9, 3.4117431319598207`*^9}],

Cell[BoxData["32"], "Output",
 CellChangeTimes->{
  3.399977217552843*^9, 3.3999782381303616`*^9, {3.3999785875127487`*^9, 
   3.3999786112068195`*^9}, 3.3999793414768963`*^9, 3.4117431319898643`*^9}]
}, Open  ]],

Cell[TextData[{
 "Here we compute first the maximum coverage that accounts for 99% of the \
distribution for networks with mean coverage up to 50. We then compute the \
number of possible values of ",
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["\[CapitalPhi]", "c", "points"], TraditionalForm]]],
 " and plot this against mean coverage:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412336283391347*^9, 3.412336358919952*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"cmax", " ", "=", 
   RowBox[{"Round", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"c", "/.", 
       RowBox[{"FindRoot", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Simplify", "[", 
           RowBox[{
            RowBox[{"CDF", "[", 
             RowBox[{
              RowBox[{"PoissonDistribution", "[", "cbar", "]"}], ",", " ", 
              "c"}], "]"}], ",", " ", 
            RowBox[{"c", "\[Element]", "Integers"}]}], "]"}], "\[Equal]", 
          ".99"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"c", ",", " ", "cbar"}], "}"}]}], "]"}]}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"cbar", ",", " ", "1", ",", " ", "50"}], "}"}]}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", 
        RowBox[{"Union", "[", 
         RowBox[{"Flatten", "[", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"nint", "/", "c"}], ",", "  ", 
            RowBox[{"{", 
             RowBox[{"c", ",", " ", "1", ",", " ", 
              RowBox[{"cmax", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"nint", ",", " ", "0", ",", " ", 
              RowBox[{"c", "-", "1"}]}], "}"}]}], "]"}], "]"}], "]"}], 
        "]"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", " ", "1", ",", " ", "50"}], "}"}]}], "]"}], ",", " ", 
   
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*OverscriptBox[\(c\), \(_\)]\)\>\"", ",", 
      "\"\<Number of possibilities\>\""}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.399979217168149*^9, 3.399979302821312*^9}, {
  3.3999793704585695`*^9, 3.3999793752554674`*^9}, {3.399979632295072*^9, 
  3.399979659834672*^9}, {3.3999797228953485`*^9, 3.3999797241671777`*^9}, {
  3.411743051824592*^9, 3.4117431056920495`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 4.}, {2., 10.}, {3., 18.}, {4., 28.}, {5., 32.}, {6., 
     46.}, {7., 58.}, {8., 72.}, {9., 80.}, {10., 102.}, {11., 120.}, {12., 
     128.}, {13., 150.}, {14., 172.}, {15., 180.}, {16., 200.}, {17., 230.}, {
     18., 242.}, {19., 270.}, {20., 308.}, {21., 324.}, {22., 344.}, {23., 
     360.}, {24., 396.}, {25., 432.}, {26., 450.}, {27., 474.}, {28., 530.}, {
     29., 542.}, {30., 584.}, {31., 604.}, {32., 628.}, {33., 696.}, {34., 
     712.}, {35., 754.}, {36., 774.}, {37., 806.}, {38., 882.}, {39., 900.}, {
     40., 940.}, {41., 964.}, {42., 1000.}, {43., 1028.}, {44., 1102.}, {45., 
     1162.}, {46., 1192.}, {47., 1228.}, {48., 1260.}, {49., 1308.}, {50., 
     1394.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox[
    "\"\\!\\(\\*OverscriptBox[\\(c\\), \\(_\\)]\\)\"", TraditionalForm], 
    FormBox["\"Number of possibilities\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{{0., 50.}, {0., 1394.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.399979753599499*^9, 3.4117431617626753`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Monte Carlo", "Subsubsection",
 Editable->False,
 CellChangeTimes->{{3.4002312839504128`*^9, 3.4002312878760576`*^9}}],

Cell[TextData[{
 "In line with our earlier practice, we develop a numerical approach to \
understanding the distribution of fractional contact area by considering \
first just 5 points in the network. Subsequently, we will consider larger \
numbers of points to provide statistically meaningful data. \n\nWe consider \
first a network with mean coverage ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      OverscriptBox["c", "_"], "=", " ", 
      RowBox[{
       RowBox[{"5", " ", "and", " ", "porosity", " ", "\[Epsilon]"}], " ", 
       "=", " ", "0.5"}]}], ";"}], " "}], TraditionalForm]]],
 "we use the expression developed earlier to give the probability of contact \
between vertically adjacent fibres, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[CapitalPhi]", "inf"], TraditionalForm]]]
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412336403464003*^9, 3.412336616890896*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cbar", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Epsilon]", " ", "=", " ", "0.5"}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalPhi]inf", " ", "=", " ", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Epsilon]", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "3"}], "+", "\[Epsilon]"}], ")"}], " ", 
          "\[Epsilon]"}]}], ")"}]}], ")"}], "/", 
     RowBox[{"Log", "[", "\[Epsilon]", "]"}]}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.400227916057621*^9, 3.4002279313496094`*^9}, {
   3.4002279672512336`*^9, 3.400228116605995*^9}, {3.4002281483115854`*^9, 
   3.4002281749498897`*^9}, {3.40022835778279*^9, 3.4002284286246557`*^9}, {
   3.4002284860372114`*^9, 3.400228489732525*^9}, {3.4002285225396996`*^9, 
   3.4002286292531457`*^9}, {3.4002287843561726`*^9, 
   3.4002288544870157`*^9}, {3.400228889717675*^9, 3.400228905930989*^9}, 
   3.4002289568241696`*^9, 3.4002290854791665`*^9, {3.4002292286750717`*^9, 
   3.40022930682745*^9}, {3.400229339955085*^9, 3.4002293709196095`*^9}, {
   3.4002294177269154`*^9, 3.400229682097061*^9}, {3.400229728133258*^9, 
   3.400229762021987*^9}, {3.400229855606555*^9, 3.400229878609632*^9}, {
   3.400230306595045*^9, 3.400230312313267*^9}, 3.400230343538166*^9, {
   3.400230967685646*^9, 3.400230973393854*^9}, {3.4002310319580655`*^9, 
   3.4002310330296063`*^9}, {3.400231082640944*^9, 3.4002310917640624`*^9}, {
   3.400231171488701*^9, 3.400231184988112*^9}, {3.4002318732577953`*^9, 
   3.4002318767728496`*^9}}],

Cell[TextData[{
 "We generate a list of random coverage at points and a list of the number of \
interfaces at the points, bearing in mind that if ",
 StyleBox["c= ",
  FontSlant->"Italic"],
 "0 or 1, then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["n", "int"], " ", "=", " ", "0."}], TraditionalForm]]]
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123366438196173`*^9, 3.4123367192280493`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SeedRandom", "[", "5", "]"}], "\[IndentingNewLine]", 
 RowBox[{"c", "=", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{
    RowBox[{"PoissonDistribution", "[", "cbar", "]"}], ",", "n"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"nint", " ", "=", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"c", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "\[LessEqual]", "1"}], ",", "0", ",", 
      
      RowBox[{
       RowBox[{"c", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "-", "1"}]}], " ", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.400227916057621*^9, 3.4002279313496094`*^9}, {
   3.4002279672512336`*^9, 3.400228116605995*^9}, {3.4002281483115854`*^9, 
   3.4002281749498897`*^9}, {3.40022835778279*^9, 3.4002284286246557`*^9}, {
   3.4002284860372114`*^9, 3.400228489732525*^9}, {3.4002285225396996`*^9, 
   3.4002286292531457`*^9}, {3.4002287843561726`*^9, 
   3.4002288544870157`*^9}, {3.400228889717675*^9, 3.400228905930989*^9}, 
   3.4002289568241696`*^9, 3.4002290854791665`*^9, {3.4002292286750717`*^9, 
   3.40022930682745*^9}, {3.400229339955085*^9, 3.4002293709196095`*^9}, {
   3.4002294177269154`*^9, 3.400229682097061*^9}, {3.400229728133258*^9, 
   3.400229762021987*^9}, {3.400229855606555*^9, 3.400229878609632*^9}, {
   3.400230306595045*^9, 3.400230312313267*^9}, 3.400230343538166*^9, {
   3.400230967685646*^9, 3.400230973393854*^9}, {3.4002310319580655`*^9, 
   3.4002310330296063`*^9}, {3.400231082640944*^9, 3.4002310917640624`*^9}, {
   3.400231171488701*^9, 3.400231202783701*^9}, {3.4002333692389107`*^9, 
   3.4002333851718206`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "2", ",", "11", ",", "10", ",", "3"}], "}"}]], "Output",
 CellChangeTimes->{
  3.4002320389360285`*^9, 3.4002330473059936`*^9, {3.4002333693791122`*^9, 
   3.400233406802925*^9}, 3.400234364560112*^9, 3.4002345085771985`*^9, 
   3.4002387616528206`*^9, 3.400239636060157*^9, 3.400239668166323*^9, 
   3.4002397905523057`*^9, 3.4003073237302465`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "10", ",", "9", ",", "2"}], "}"}]], "Output",
 CellChangeTimes->{
  3.4002320389360285`*^9, 3.4002330473059936`*^9, {3.4002333693791122`*^9, 
   3.400233406802925*^9}, 3.400234364560112*^9, 3.4002345085771985`*^9, 
   3.4002387616528206`*^9, 3.400239636060157*^9, 3.400239668166323*^9, 
   3.4002397905523057`*^9, 3.4003073237703037`*^9}]
}, Open  ]],

Cell[TextData[{
 "Each interface is either a void or an inter-fibre contact. We generate a \
list of contacts using a Bernoulli trial where the number of trials is ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "int"], TraditionalForm]]],
 "and the probability of 'success' (",
 StyleBox["i.e",
  FontSlant->"Italic"],
 ". a contact) is ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[CapitalPhi]", "inf"], TraditionalForm]]]
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123367362224865`*^9, 3.412336830738394*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ncontacts", " ", "=", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"c", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "\[LessEqual]", "1"}], ",", " ", "0", 
      ",", " ", 
      RowBox[{"RandomInteger", "[", 
       RowBox[{"BinomialDistribution", "[", 
        RowBox[{
         RowBox[{"nint", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", " ", "\[CapitalPhi]inf"}], 
        "]"}], "]"}]}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"i", ",", " ", "1", ",", " ", "n"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.400227916057621*^9, 3.4002279313496094`*^9}, {
   3.4002279672512336`*^9, 3.400228116605995*^9}, {3.4002281483115854`*^9, 
   3.4002281749498897`*^9}, {3.40022835778279*^9, 3.4002284286246557`*^9}, {
   3.4002284860372114`*^9, 3.400228489732525*^9}, {3.4002285225396996`*^9, 
   3.4002286292531457`*^9}, {3.4002287843561726`*^9, 
   3.4002288544870157`*^9}, {3.400228889717675*^9, 3.400228905930989*^9}, 
   3.4002289568241696`*^9, 3.4002290854791665`*^9, {3.4002292286750717`*^9, 
   3.40022930682745*^9}, {3.400229339955085*^9, 3.4002293709196095`*^9}, {
   3.4002294177269154`*^9, 3.400229682097061*^9}, {3.400229728133258*^9, 
   3.400229762021987*^9}, {3.400229855606555*^9, 3.400229878609632*^9}, {
   3.400230306595045*^9, 3.400230312313267*^9}, 3.400230343538166*^9, {
   3.400230967685646*^9, 3.400230973393854*^9}, {3.4002310319580655`*^9, 
   3.4002310330296063`*^9}, {3.400231082640944*^9, 3.4002310917640624`*^9}, {
   3.400231171488701*^9, 3.4002311918579903`*^9}, {3.400231225826835*^9, 
   3.4002312279899454`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "2", ",", "7", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.400232847478656*^9, 3.400233047396123*^9, 
  3.4002334069431267`*^9, 3.4002343647203426`*^9, 3.4002345086773424`*^9, 
  3.4002387617629795`*^9, 3.4002396361603007`*^9, 3.4002396683065248`*^9, 
  3.4002397906724787`*^9, 3.400307323850419*^9}]
}, Open  ]],

Cell[TextData[{
 "We are only concerned with points with c \[GreaterEqual] 1, so we remove \
elements of ",
 StyleBox["ncontacts", "Input"],
 " associated with points with coverage zero using ",
 StyleBox["Cases", "Input"],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412336853000405*^9, 3.412336875913352*^9}, {
  3.412336911354314*^9, 3.4123369459440513`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"cncontacts", " ", "=", " ", 
  RowBox[{"Cases", "[", 
   RowBox[{
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"c", ",", " ", "ncontacts"}], "}"}], "]"}], ",", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x_", ",", "y_"}], "}"}], "/;", " ", 
     RowBox[{"x", " ", "\[NotEqual]", " ", "0"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cncontacts", " ", "=", 
   RowBox[{"Transpose", "[", "cncontacts", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", " ", "=", " ", 
   RowBox[{"cncontacts", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ncontacts", " ", "=", " ", 
   RowBox[{"cncontacts", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"\[CapitalPhi]cpoints", " ", "=", "  ", 
  RowBox[{"ncontacts", "/", "c"}]}]}], "Input",
 CellChangeTimes->{{3.400227916057621*^9, 3.4002279313496094`*^9}, {
   3.4002279672512336`*^9, 3.400228116605995*^9}, {3.4002281483115854`*^9, 
   3.4002281749498897`*^9}, {3.40022835778279*^9, 3.4002284286246557`*^9}, {
   3.4002284860372114`*^9, 3.400228489732525*^9}, {3.4002285225396996`*^9, 
   3.4002286292531457`*^9}, {3.4002287843561726`*^9, 
   3.4002288544870157`*^9}, {3.400228889717675*^9, 3.400228905930989*^9}, 
   3.4002289568241696`*^9, 3.4002290854791665`*^9, {3.4002292286750717`*^9, 
   3.40022930682745*^9}, {3.400229339955085*^9, 3.4002293709196095`*^9}, {
   3.4002294177269154`*^9, 3.400229682097061*^9}, {3.400229728133258*^9, 
   3.400229762021987*^9}, {3.400229855606555*^9, 3.400229878609632*^9}, {
   3.400230306595045*^9, 3.400230312313267*^9}, 3.400230343538166*^9, {
   3.400230967685646*^9, 3.400230973393854*^9}, {3.4002310319580655`*^9, 
   3.4002310330296063`*^9}, {3.400231082640944*^9, 3.4002310917640624`*^9}, {
   3.400231171488701*^9, 3.4002311918579903`*^9}, {3.400231225826835*^9, 
   3.400231232836915*^9}, {3.4002329282548065`*^9, 3.4002329291060305`*^9}, 
   3.400232972838915*^9, 3.400233038252976*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.4002329734998655`*^9, 3.400233047446195*^9, 
  3.400233407003213*^9, 3.4002343647904434`*^9, 3.400234508747443*^9, 
  3.400238761813051*^9, 3.400239636210373*^9, 3.400239668356597*^9, 
  3.4002397907425795`*^9, 3.4003073239105053`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "2"], ",", 
   FractionBox["2", "11"], ",", 
   FractionBox["7", "10"], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.4002329734998655`*^9, 3.400233047446195*^9, 
  3.400233407003213*^9, 3.4002343647904434`*^9, 3.400234508747443*^9, 
  3.400238761813051*^9, 3.400239636210373*^9, 3.400239668356597*^9, 
  3.4002397907425795`*^9, 3.4003073239305344`*^9}]
}, Open  ]],

Cell[TextData[{
 "We now collect our code into a single command ",
 StyleBox["FCAMonteCarlo", "Input"],
 " where we specify the mean coverage and porosity and generate the \
fractional contact area of 50 000 points:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123369639799857`*^9, 3.4123370200606256`*^9}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", 
  RowBox[{"\[Epsilon]", ",", " ", "cbar", ",", "n", ",", "\[CapitalPhi]inf"}],
   "]"}], "\n", 
 RowBox[{
  RowBox[{"FCAMonteCarlo", "[", 
   RowBox[{"cbar_", ",", "\[Epsilon]_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"n", " ", "=", " ", "50000"}], ";", " ", 
    RowBox[{"\[CapitalPhi]inf", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[Epsilon]", " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "3"}], "+", "\[Epsilon]"}], ")"}], " ", 
            "\[Epsilon]"}]}], ")"}]}], ")"}], "/", 
       RowBox[{"Log", "[", "\[Epsilon]", "]"}]}]}]}], ";", "\n", 
    RowBox[{"SeedRandom", "[", "5", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"c", "=", 
     RowBox[{"RandomInteger", "[", 
      RowBox[{
       RowBox[{"PoissonDistribution", "[", "cbar", "]"}], ",", "n"}], "]"}]}],
     ";", "\[IndentingNewLine]", 
    RowBox[{"nint", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"c", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "\[LessEqual]", "1"}], ",", "0", 
         ",", 
         RowBox[{
          RowBox[{"c", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "-", "1"}]}], " ", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], ";", "\n", 
    RowBox[{"ncontacts", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"c", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "\[LessEqual]", "1"}], ",", " ", 
         "0", ",", " ", 
         RowBox[{"RandomInteger", "[", 
          RowBox[{"BinomialDistribution", "[", 
           RowBox[{
            RowBox[{"nint", "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", " ", "\[CapitalPhi]inf"}], 
           "]"}], "]"}]}], "]"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"i", ",", " ", "1", ",", " ", "n"}], "}"}]}], "]"}]}], ";", 
    "\n", 
    RowBox[{"cncontacts", " ", "=", " ", 
     RowBox[{"Cases", "[", 
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"{", 
         RowBox[{"c", ",", " ", "ncontacts"}], "}"}], "]"}], ",", " ", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x_", ",", "y_"}], "}"}], "/;", " ", 
        RowBox[{"x", " ", "\[NotEqual]", " ", "0"}]}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"cncontacts", " ", "=", 
     RowBox[{"Transpose", "[", "cncontacts", "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"c", " ", "=", " ", 
     RowBox[{"cncontacts", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"ncontacts", " ", "=", " ", 
     RowBox[{"cncontacts", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"\[CapitalPhi]cpoints", " ", "=", "  ", 
     RowBox[{"ncontacts", "/", "c"}]}], ";"}], ")"}]}]}], "Input",
 CellChangeTimes->{{3.400239606177187*^9, 3.4002396492691507`*^9}}],

Cell[TextData[{
 "So, for example, we generate fractional contact area data for 50 000 points \
in a network with mean coverage ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["c", "_"], TraditionalForm]]],
 " = 5 and mean porosity \[Epsilon] = 0.5 we evaluate:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123370407804193`*^9, 3.412337107766741*^9}, {
  3.4123373396201296`*^9, 3.412337350005062*^9}}],

Cell[BoxData[
 RowBox[{"FCAMonteCarlo", "[", 
  RowBox[{"5", ",", ".5"}], "]"}]], "Input",
 CellChangeTimes->{{3.400234112748024*^9, 3.40023412040904*^9}, {
   3.400234179524043*^9, 3.400234179804446*^9}, 3.4002344610788994`*^9, 
   3.4002400930372577`*^9, 3.40024022343476*^9, {3.4002403439180064`*^9, 
   3.4002403466118803`*^9}, 3.4002407623997536`*^9, 3.4002409111436367`*^9, {
   3.4002410687903214`*^9, 3.4002410709434175`*^9}, 3.4002411761947613`*^9, 
   3.4002416843754897`*^9, {3.400241978087827*^9, 3.4002419797702465`*^9}}],

Cell[TextData[{
 "Although the output has been suppressed from our latest evaluation, the \
list ",
 StyleBox["\[CapitalPhi]cpoints", "Input"],
 " is current in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel and we can use this to compute statistics. The mean fractional \
contact area ",
 StyleBox["\[CapitalPhi]cbar", "Input"],
 " is less than out value of ",
 StyleBox["\[CapitalPhi]inf", "Input"],
 " by a factor ",
 StyleBox["f", "Input"],
 ", derived earlier:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.41233743250369*^9, 3.412337584321994*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"cbar", " ", "=", " ", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"\[CapitalPhi]cbar", " ", "=", " ", 
  RowBox[{"Mean", "[", 
   RowBox[{"N", "[", "\[CapitalPhi]cpoints", "]"}], 
   "]"}]}], "\[IndentingNewLine]", "\[CapitalPhi]inf", "\[IndentingNewLine]", \

 RowBox[{
  RowBox[{"f", " ", "=", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"EulerGamma", "-", 
        RowBox[{"ExpIntegralEi", "[", "cbar", "]"}], "+", 
        RowBox[{"Log", "[", "cbar", "]"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", "cbar"], "-", "1"}], ")"}]}]}], 
    ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"\[CapitalPhi]cbar", "/", "f"}], "\[IndentingNewLine]", 
 RowBox[{"cbar", " ", "=."}]}], "Input",
 CellChangeTimes->{{3.4002303146265936`*^9, 3.400230328276221*^9}, {
  3.400230862224*^9, 3.400230867181128*^9}, {3.4002311131147633`*^9, 
  3.400231123549768*^9}, {3.40023151407131*^9, 3.4002315212316065`*^9}, {
  3.4002315643435984`*^9, 3.400231587436805*^9}, {3.400233893102189*^9, 
  3.4002338945943346`*^9}, {3.4002355062517843`*^9, 3.400235607817829*^9}, {
  3.4002397533187666`*^9, 3.4002397685606833`*^9}}],

Cell[BoxData["0.33899717523176953`"], "Output",
 CellChangeTimes->{3.400235632643526*^9, 3.4002388199166*^9, 
  3.400239729274192*^9, 3.4002397698224974`*^9, 3.400239848044976*^9, 
  3.400242063560731*^9, 3.4003073898252864`*^9}],

Cell[BoxData["0.4589893596666388`"], "Output",
 CellChangeTimes->{3.400235632643526*^9, 3.4002388199166*^9, 
  3.400239729274192*^9, 3.4002397698224974`*^9, 3.400239848044976*^9, 
  3.400242063560731*^9, 3.4003073898353004`*^9}],

Cell[BoxData["0.45672765018176065`"], "Output",
 CellChangeTimes->{3.400235632643526*^9, 3.4002388199166*^9, 
  3.400239729274192*^9, 3.4002397698224974`*^9, 3.400239848044976*^9, 
  3.400242063560731*^9, 3.400307389955474*^9}]
}, Open  ]],

Cell[TextData[{
 "We have seen that the fractional contact area at points is a discrete \
random variable with non-uniform intervals between possible values. \
Accordingly, we must use ",
 StyleBox["GeneralizedBarChart", "Input"],
 " to plot a bar chart of the data and must specify the locations of the bars \
and their width. The output reveals the highly discontinuous nature of the \
distribution:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123376006755085`*^9, 3.4123376690938897`*^9}, {
   3.4123376998180685`*^9, 3.412337714168704*^9}, {3.412337759183432*^9, 
   3.4123377892366467`*^9}, 3.4124159292765055`*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<BarCharts`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"counts", " ", "=", " ", 
   RowBox[{"Sort", "[", 
    RowBox[{"Tally", "[", "\[CapitalPhi]cpoints", "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bins", " ", "=", " ", 
   RowBox[{
    RowBox[{"Transpose", "[", "counts", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"barwidths", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"Min", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"bins", "[", 
           RowBox[{"[", 
            RowBox[{"i", "+", "1"}], "]"}], "]"}], "-", 
          RowBox[{"bins", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{
            RowBox[{"Length", "[", "bins", "]"}], "-", "1"}]}], "}"}]}], 
        "]"}], "]"}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"Length", "[", "bins", "]"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"frequencies", "=", " ", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "counts", "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], "/", "n"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GeneralizedBarChart", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"bins", ",", "frequencies", ",", "barwidths"}], "}"}], "]"}], 
   ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], ",", 
   " ", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<\[CapitalPhi]c\>\"", ",", " ", "\"\<Frequency\>\""}], 
     "}"}]}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", "All"}], "}"}]}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.400242027659107*^9, 3.4002420809156866`*^9}, {
  3.4002424357959795`*^9, 3.400242439020616*^9}, {3.4002425092816467`*^9, 
  3.4002426390882993`*^9}, {3.400304283618781*^9, 3.4003043268108883`*^9}, {
  3.4003045264179087`*^9, 3.400304537814296*^9}, {3.400304583930608*^9, 
  3.4003046641159086`*^9}, {3.4003051076737137`*^9, 3.4003051241774445`*^9}, {
  3.4003064171666718`*^9, 3.4003064212124896`*^9}, {3.4003064611098595`*^9, 
  3.4003064942575235`*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[-1, 510], 0}, {-0.00196078431372549, 0}], 
     NCache[{Rational[1, 510], 0.17608}, {0.00196078431372549, 0.17608}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[83, 1020], 0}, {0.08137254901960785, 0}], 
     NCache[{Rational[29, 340], 0.00002}, {0.08529411764705883, 0.00002}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[499, 5610], 0}, {0.08894830659536541, 0}], 
     NCache[{Rational[521, 5610], 0.0001}, {0.0928698752228164, 0.0001}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[5, 51], 0}, {0.09803921568627451, 0}], 
     NCache[{Rational[26, 255], 0.00052}, {0.10196078431372549`, 
      0.00052}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[167, 1530], 0}, {0.10915032679738562`, 0}], 
     NCache[{Rational[173, 1530], 0.00188}, {0.1130718954248366, 
      0.00188}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[251, 2040], 0}, {0.1230392156862745, 0}], 
     NCache[{Rational[259, 2040], 0.00512}, {0.12696078431372548`, 
      0.00512}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[67, 510], 0}, {0.13137254901960785`, 0}], 
     NCache[{Rational[23, 170], 0.00002}, {0.13529411764705881`, 
      0.00002}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[503, 3570], 0}, {0.14089635854341737`, 0}], 
     NCache[{Rational[517, 3570], 0.01396}, {0.14481792717086836`, 
      0.01396}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[1007, 6630], 0}, {0.15188536953242834`, 0}],
      NCache[{Rational[1033, 6630], 0.00004}, {0.15580693815987934`, 
      0.00004}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[14, 85], 0}, {0.16470588235294117`, 0}], 
     NCache[{Rational[43, 255], 0.02956}, {0.16862745098039217`, 
      0.02956}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[1009, 5610], 0}, {0.17985739750445634`, 0}],
      NCache[{Rational[1031, 5610], 0.00056}, {0.1837789661319073, 
      0.00056}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[101, 510], 0}, {0.1980392156862745, 0}], 
     NCache[{Rational[103, 510], 0.05248}, {0.2019607843137255, 0.05248}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[379, 1785], 0}, {0.2123249299719888, 0}], 
     NCache[{Rational[386, 1785], 0.00004}, {0.21624649859943978`, 
      0.00004}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[337, 1530], 0}, {0.22026143790849673`, 0}], 
     NCache[{Rational[343, 1530], 0.00504}, {0.22418300653594772`, 
      0.00504}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[1517, 6630], 0}, {0.22880844645550527`, 0}],
      NCache[{Rational[1543, 6630], 0.00002}, {0.23273001508295627`, 
      0.00002}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[253, 1020], 0}, {0.24803921568627452`, 0}], 
     NCache[{Rational[257, 1020], 0.08512}, {0.2519607843137255, 
      0.08512}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[9, 34], 0}, {0.2647058823529412, 0}], 
     NCache[{Rational[137, 510], 0.00002}, {0.26862745098039215`, 
      0.00002}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[1519, 5610], 0}, {0.2707664884135472, 0}], 
     NCache[{Rational[1541, 5610], 0.00122}, {0.2746880570409982, 
      0.00122}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[1013, 3570], 0}, {0.2837535014005602, 0}], 
     NCache[{Rational[1027, 3570], 0.02732}, {0.2876750700280112, 
      0.02732}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[76, 255], 0}, {0.2980392156862745, 0}], 
     NCache[{Rational[77, 255], 0.00378}, {0.30196078431372547`, 
      0.00378}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[2027, 6630], 0}, {0.3057315233785822, 0}], 
     NCache[{Rational[2053, 6630], 0.00018}, {0.3096530920060332, 
      0.00018}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[169, 510], 0}, {0.33137254901960783`, 0}], 
     NCache[{Rational[57, 170], 0.12944}, {0.3352941176470588, 0.12944}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[634, 1785], 0}, {0.35518207282913167`, 0}], 
     NCache[{Rational[641, 1785], 0.00006}, {0.35910364145658263`, 
      0.00006}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[2029, 5610], 0}, {0.36167557932263816`, 0}],
      NCache[{Rational[2051, 5610], 0.00222}, {0.36559714795008913`, 
      0.00222}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[761, 2040], 0}, {0.3730392156862745, 0}], 
     NCache[{Rational[769, 2040], 0.01906}, {0.3769607843137255, 
      0.01906}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[2537, 6630], 0}, {0.3826546003016591, 0}], 
     NCache[{Rational[2563, 6630], 0.00032}, {0.3865761689291101, 
      0.00032}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[203, 510], 0}, {0.3980392156862745, 0}], 
     NCache[{Rational[41, 102], 0.07038}, {0.4019607843137255, 0.07038}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[141, 340], 0}, {0.4147058823529412, 0}], 
     NCache[{Rational[427, 1020], 0.00084}, {0.41862745098039217`, 
      0.00084}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[1523, 3570], 0}, {0.42661064425770306`, 0}],
      NCache[{Rational[1537, 3570], 0.0322}, {0.4305322128851541, 
      0.0322}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[677, 1530], 0}, {0.44248366013071894`, 0}], 
     NCache[{Rational[683, 1530], 0.00972}, {0.44640522875816996`, 
      0.00972}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[2539, 5610], 0}, {0.45258467023172905`, 0}],
      NCache[{Rational[2561, 5610], 0.00188}, {0.45650623885918, 
      0.00188}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[3047, 6630], 0}, {0.459577677224736, 0}], 
     NCache[{Rational[3073, 6630], 0.00022}, {0.46349924585218705`, 
      0.00022}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[79, 170], 0}, {0.4647058823529412, 0}], 
     NCache[{Rational[239, 510], 0.00004}, {0.46862745098039216`, 
      0.00004}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[239, 510], 0}, {0.46862745098039216`, 0}], 
     NCache[{Rational[241, 510], 0.00004}, {0.4725490196078431, 0.00004}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[127, 255], 0}, {0.4980392156862745, 0}], 
     NCache[{Rational[128, 255], 0.15794}, {0.5019607843137255, 0.15794}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[269, 510], 0}, {0.5274509803921569, 0}], 
     NCache[{Rational[271, 510], 0.00002}, {0.5313725490196078, 0.00002}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[3557, 6630], 0}, {0.536500754147813, 0}], 
     NCache[{Rational[3583, 6630], 0.00034}, {0.5404223227752639, 
      0.00034}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[3049, 5610], 0}, {0.5434937611408199, 0}], 
     NCache[{Rational[3071, 5610], 0.00146}, {0.5474153297682709, 
      0.00146}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[847, 1530], 0}, {0.5535947712418301, 0}], 
     NCache[{Rational[853, 1530], 0.00642}, {0.5575163398692811, 
      0.00642}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[2033, 3570], 0}, {0.5694677871148459, 0}], 
     NCache[{Rational[2047, 3570], 0.0208}, {0.5733893557422969, 0.0208}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[593, 1020], 0}, {0.5813725490196079, 0}], 
     NCache[{Rational[199, 340], 0.00022}, {0.5852941176470589, 0.00022}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[61, 102], 0}, {0.5980392156862745, 0}], 
     NCache[{Rational[307, 510], 0.0383}, {0.6019607843137255, 0.0383}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[4067, 6630], 0}, {0.6134238310708899, 0}], 
     NCache[{Rational[4093, 6630], 0.00014}, {0.6173453996983409, 
      0.00014}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[1271, 2040], 0}, {0.6230392156862745, 0}], 
     NCache[{Rational[1279, 2040], 0.00818}, {0.6269607843137255, 
      0.00818}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[3559, 5610], 0}, {0.6344028520499109, 0}], 
     NCache[{Rational[3581, 5610], 0.00054}, {0.6383244206773618, 
      0.00054}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[1144, 1785], 0}, {0.6408963585434174, 0}], 
     NCache[{Rational[1151, 1785], 0.00004}, {0.6448179271708684, 
      0.00004}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[113, 170], 0}, {0.6647058823529411, 0}], 
     NCache[{Rational[341, 510], 0.04936}, {0.6686274509803921, 0.04936}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[4577, 6630], 0}, {0.6903469079939668, 0}], 
     NCache[{Rational[4603, 6630], 0.00004}, {0.6942684766214178, 
      0.00004}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[178, 255], 0}, {0.6980392156862745, 0}], 
     NCache[{Rational[179, 255], 0.00078}, {0.7019607843137254, 0.00078}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[2543, 3570], 0}, {0.7123249299719888, 0}], 
     NCache[{Rational[2557, 3570], 0.00708}, {0.7162464985994398, 
      0.00708}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[4069, 5610], 0}, {0.7253119429590018, 0}], 
     NCache[{Rational[4091, 5610], 0.00018}, {0.7292335115864528, 
      0.00018}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[763, 1020], 0}, {0.7480392156862745, 0}], 
     NCache[{Rational[767, 1020], 0.019}, {0.7519607843137255, 0.019}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[5087, 6630], 0}, {0.7672699849170438, 0}], 
     NCache[{Rational[5113, 6630], 0.00002}, {0.7711915535444948, 
      0.00002}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[1187, 1530], 0}, {0.7758169934640523, 0}], 
     NCache[{Rational[1193, 1530], 0.00048}, {0.7797385620915033, 
      0.00048}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[407, 510], 0}, {0.7980392156862746, 0}], 
     NCache[{Rational[409, 510], 0.00768}, {0.8019607843137255, 0.00768}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[4579, 5610], 0}, {0.8162210338680926, 0}], 
     NCache[{Rational[4601, 5610], 0.00008}, {0.8201426024955437, 
      0.00008}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[212, 255], 0}, {0.8313725490196079, 0}], 
     NCache[{Rational[71, 85], 0.0033}, {0.8352941176470589, 0.0033}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[3053, 3570], 0}, {0.8551820728291316, 0}], 
     NCache[{Rational[3067, 3570], 0.00118}, {0.8591036414565826, 
      0.00118}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[1781, 2040], 0}, {0.8730392156862745, 0}], 
     NCache[{Rational[1789, 2040], 0.00034}, {0.8769607843137255, 
      0.00034}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[1357, 1530], 0}, {0.8869281045751634, 0}], 
     NCache[{Rational[1363, 1530], 0.00008}, {0.8908496732026144, 
      0.00008}]]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[NCache[{Rational[229, 255], 0}, {0.8980392156862745, 0}], 
     NCache[{Rational[46, 51], 0.00002}, {0.9019607843137255, 0.00002}]]}},
  AlignmentPoint->Center,
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->{True, True, False, False},
  FrameLabel->{
    FormBox["\"\[CapitalPhi]c\"", TraditionalForm], 
    FormBox["\"Frequency\"", TraditionalForm]},
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{0, 1}, All},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  PreserveImageOptions->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 CellChangeTimes->{{3.4002367013802943`*^9, 3.4002367206780434`*^9}, {
   3.4002368455075393`*^9, 3.4002368675191903`*^9}, {3.400236923699974*^9, 
   3.400236928997592*^9}, {3.4002369654099503`*^9, 3.400237007089883*^9}, {
   3.400237044744027*^9, 3.40023707199321*^9}, {3.4002371199922285`*^9, 
   3.400237146610504*^9}, 3.400237225443861*^9, {3.4002373311158094`*^9, 
   3.400237378073331*^9}, {3.400237411681658*^9, 3.4002374245902195`*^9}, {
   3.4002374589496255`*^9, 3.400237580714715*^9}, {3.400237649433528*^9, 
   3.4002376938574066`*^9}, {3.4002377353771086`*^9, 3.4002378325868893`*^9}, 
   3.400238016801778*^9, 3.400238821599019*^9, 3.400239731557475*^9, 
   3.400239849336834*^9, 3.400240149658675*^9, 3.4002402796756306`*^9, 
   3.4002404237127457`*^9, 3.4002408502761135`*^9, 3.400240998098672*^9, 
   3.4002410961797056`*^9, 3.4002412003595085`*^9, 3.4002417076489553`*^9, 
   3.400307391047043*^9}]
}, Open  ]],

Cell[TextData[{
 "We calculate the mean, variance, ",
 StyleBox["etc.",
  FontSlant->"Italic"],
 " by applying ",
 StyleBox["N", "Input"],
 " first to speed up the calculation."
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412337801093696*^9, 3.412337827061035*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Mean", "[", 
  RowBox[{"N", "[", "\[CapitalPhi]cpoints", "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Variance", "[", 
  RowBox[{"N", "[", "\[CapitalPhi]cpoints", "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Sqrt", "[", "%", "]"}], "/", "%%"}], "\[IndentingNewLine]", 
 RowBox[{"Skewness", "[", 
  RowBox[{"N", "[", "\[CapitalPhi]cpoints", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.400238551740982*^9, 3.400238594893032*^9}}],

Cell[BoxData["0.33899717523176953`"], "Output",
 CellChangeTimes->{3.4002400672201347`*^9, 3.4002401502795677`*^9, 
  3.4002402803265667`*^9, 3.4002404245639696`*^9, 3.400240851988576*^9, 
  3.400241001623741*^9, 3.4002411016375537`*^9, 3.400241206268005*^9, 
  3.4002417127062273`*^9, 3.4003073912072735`*^9}],

Cell[BoxData["0.046464945519119345`"], "Output",
 CellChangeTimes->{3.4002400672201347`*^9, 3.4002401502795677`*^9, 
  3.4002402803265667`*^9, 3.4002404245639696`*^9, 3.400240851988576*^9, 
  3.400241001623741*^9, 3.4002411016375537`*^9, 3.400241206268005*^9, 
  3.4002417127062273`*^9, 3.4003073913274465`*^9}],

Cell[BoxData["0.6358675125404847`"], "Output",
 CellChangeTimes->{3.4002400672201347`*^9, 3.4002401502795677`*^9, 
  3.4002402803265667`*^9, 3.4002404245639696`*^9, 3.400240851988576*^9, 
  3.400241001623741*^9, 3.4002411016375537`*^9, 3.400241206268005*^9, 
  3.4002417127062273`*^9, 3.400307391347475*^9}],

Cell[BoxData[
 RowBox[{"-", "0.05520782579951589`"}]], "Output",
 CellChangeTimes->{3.4002400672201347`*^9, 3.4002401502795677`*^9, 
  3.4002402803265667`*^9, 3.4002404245639696`*^9, 3.400240851988576*^9, 
  3.400241001623741*^9, 3.4002411016375537`*^9, 3.400241206268005*^9, 
  3.4002417127062273`*^9, 3.4003073913574896`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.3.3 Intensity of Contacts", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.4004879106818237`*^9, 3.400487917631818*^9}, {
  3.412337858125704*^9, 3.41233785927736*^9}}],

Cell[TextData[{
 "We use the fractional contact area to determine the expected number of \
crossings per fibre in a multiplanar network. The area of a crossing with \
angle \[Phi] is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Omega]", "2"], "/", 
    RowBox[{"sin", "(", "\[Phi]", ")"}]}], TraditionalForm]]],
 ", so the expected area of a crossing is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Omega]", "2"], "/", 
    OverscriptBox[
     RowBox[{"sin", "(", "\[Phi]", ")"}], "_"]}], TraditionalForm]]],
 ". We seek then the probability density of sin(\[Phi]) so that we can \
compute the mean. The probability density of \[Phi] is sin(\[Phi]), to the \
probability density of the random variable q = sin(\[Phi]) is "
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123382894859695`*^9, 3.412338479699483*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "[", "\[Phi]_", "]"}], ":=", 
  RowBox[{"Sin", "[", "\[Phi]", "]"}]}], "\n", 
 RowBox[{
  RowBox[{"\[Phi]", " ", "=", " ", 
   RowBox[{"ArcSin", "[", "q", "]"}]}], ";"}], "\n", 
 RowBox[{"pdfq", " ", "=", " ", 
  RowBox[{
   RowBox[{"f", "[", "\[Phi]", "]"}], 
   RowBox[{"D", "[", 
    RowBox[{"\[Phi]", ",", " ", "q"}], "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.3999594021355314`*^9, 3.399959416816642*^9}, 
   3.4003085579750032`*^9, {3.400925991641307*^9, 3.400926020753168*^9}, 
   3.4009260548421855`*^9, {3.400927120754893*^9, 3.400927122787816*^9}, 
   3.4009271545735216`*^9}],

Cell[BoxData[
 FractionBox["q", 
  SqrtBox[
   RowBox[{"1", "-", 
    SuperscriptBox["q", "2"]}]]]], "Output",
 CellChangeTimes->{{3.4009271435877247`*^9, 3.4009271646680365`*^9}, 
   3.4009326528696833`*^9, 3.40093339265344*^9, 3.401192576215613*^9, 
   3.4011937096353903`*^9, 3.4112980373412333`*^9, 3.4123414186855373`*^9, 
   3.412341458432691*^9, 3.412341732727107*^9}]
}, Open  ]],

Cell[TextData[{
 "and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["q", "_"], " ", "=", " ", 
    OverscriptBox[
     RowBox[{"sin", "(", "\[Phi]", ")"}], "_"]}], TraditionalForm]]],
 " is given by"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123384859885263`*^9, 3.4123385058570957`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"qbar", "  ", "=", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"q", " ", "pdfq"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"q", ",", " ", "0", ",", " ", "1"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.400927467513507*^9, 3.400927475695272*^9}}],

Cell[BoxData[
 FractionBox["\[Pi]", "4"]], "Output",
 CellChangeTimes->{3.400927480121637*^9, 3.400932658127243*^9, 
  3.4009333934646063`*^9, 3.401192577627643*^9, 3.40119371197876*^9, 
  3.4112980405658703`*^9, 3.412341424774293*^9, 3.412341459534275*^9, 
  3.4123417337686048`*^9}]
}, Open  ]],

Cell["So the expected area of a crossing is:", "Text",
 Editable->False,
 CellChangeTimes->{{3.4123385132977953`*^9, 3.4123385205181775`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a1", " ", "=", " ", 
  RowBox[{
   SuperscriptBox["\[Omega]", "2"], "/", "qbar"}]}]], "Input",
 CellChangeTimes->{3.4009326362557936`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"4", " ", 
   SuperscriptBox["\[Omega]", "2"]}], "\[Pi]"]], "Output",
 CellChangeTimes->{{3.400932636706442*^9, 3.4009326583876176`*^9}, 
   3.4009333935647507`*^9, 3.401192577777859*^9, 3.401193712149005*^9, 
   3.411298040726101*^9, 3.412341425204912*^9, 3.412341459684491*^9, 
   3.4123417339989357`*^9}]
}, Open  ]],

Cell[TextData[{
 "The expected total area of crossings per fibre is ",
 StyleBox["atot", "Input"],
 ", so the expected number of crossings per fibre is"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412338528669899*^9, 3.4123385618275776`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"atot", " ", "=", " ", 
   RowBox[{"2", " ", "A", " ", 
    SuperscriptBox["\[Omega]", "2"], " ", "\[CapitalPhi]c"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ncross", " ", "=", " ", 
  RowBox[{"atot", "/", "a1"}]}]}], "Input",
 CellChangeTimes->{{3.400932318759256*^9, 3.4009323270611935`*^9}, {
  3.4009325136995664`*^9, 3.4009325155422163`*^9}, {3.4009326333616323`*^9, 
  3.4009326407021875`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"A", " ", "\[Pi]", " ", "\[CapitalPhi]c"}], "2"]], "Output",
 CellChangeTimes->{{3.400932312580371*^9, 3.4009323282128496`*^9}, 
   3.4009325170543904`*^9, 3.4009326584276752`*^9, 3.400933393604808*^9, 
   3.401192577817917*^9, 3.4011937121990767`*^9, 3.411298040786187*^9, 
   3.4123414252649984`*^9, 3.4123414596945057`*^9, 3.412341734049008*^9}]
}, Open  ]],

Cell[TextData[{
 "We obtain a final expression in terms of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["c", "_"], " ", "and"}], TraditionalForm]]],
 " \[Epsilon] using the relationships obtained earlier:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412338589877912*^9, 3.4123386187794704`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalPhi]2d", " ", "=", " ", 
   RowBox[{"1", " ", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Epsilon]"}], ")"}], "/", 
     RowBox[{"Log", "[", "\[Epsilon]", "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CapitalPhi]inf", " ", "=", " ", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"\[CapitalPhi]2d", " ", "+", " ", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "\[Epsilon]"}], ")"}], "2"], 
       RowBox[{"(", 
        RowBox[{"1", " ", "-", " ", "\[CapitalPhi]2d"}], ")"}]}]}], ",", " ", 
     
     RowBox[{"0", "<", "\[Epsilon]", "<", "1"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", " ", "=", " ", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"EulerGamma", "-", 
       RowBox[{"ExpIntegralEi", "[", "cbar", "]"}], "+", 
       RowBox[{"Log", "[", "cbar", "]"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "cbar"], "-", "1"}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalPhi]c", " ", "=", " ", 
   RowBox[{"f", " ", "\[CapitalPhi]inf"}]}], 
  ";"}], "\[IndentingNewLine]", "ncross"}], "Input",
 CellChangeTimes->{{3.3998858710330915`*^9, 3.399885890771474*^9}, {
  3.399886012085915*^9, 3.399886022540949*^9}, {3.3998864025573854`*^9, 
  3.39988646315452*^9}, {3.4009320543891106`*^9, 3.400932068729731*^9}, {
  3.400932103529771*^9, 3.4009321046313553`*^9}, {3.4009321618636513`*^9, 
  3.400932287273982*^9}, {3.4009327998410177`*^9, 3.400932809845403*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "A", " ", "\[Pi]", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    FractionBox[
     RowBox[{"EulerGamma", "-", 
      RowBox[{"ExpIntegralEi", "[", "cbar", "]"}], "+", 
      RowBox[{"Log", "[", "cbar", "]"}]}], 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", "cbar"]}]]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    FractionBox[
     RowBox[{"\[Epsilon]", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "+", "\[Epsilon]"}], ")"}], " ", 
         "\[Epsilon]"}]}], ")"}]}], 
     RowBox[{"Log", "[", "\[Epsilon]", "]"}]]}], ")"}]}]], "Output",
 CellChangeTimes->{3.4009328401189346`*^9, 3.40093339399537*^9, 
  3.401192578078291*^9, 3.401193714812835*^9, 3.4112980411967773`*^9, 
  3.412341425555416*^9, 3.412341460125125*^9, 3.412341734319397*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"ncross", "/.", 
    RowBox[{"A", "\[Rule]", "1"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Epsilon]", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"cbar", ",", " ", "0", ",", " ", "20"}], "}"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Epsilon]\>\"", ",", " ", 
      "\"\<\!\(\*OverscriptBox[\(c\), \(_\)]\)\>\"", ",", "\"\<ncross\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.400933207146694*^9, 3.40093333381884*^9}, {
  3.400933378963755*^9, 3.4009333814973984`*^9}}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1nXk8Vd0X8C+K5oFKolIuKSVD83DPae6WFI3SnGY3Ek1UNKoo3QYqZUgT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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJw1mgf4V2Mbx885z++RMiplNbVQMlpKRSWRpJIG0lJKmkg0aEohNJRKZBbR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         "]], Polygon3DBox[CompressedData["
1:eJw1mnXAVcXXhc/Zd19QbMQuLFBUbLAFBQtQxEYBUcDCwsZERUDswEQJMbG7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         "]], Polygon3DBox[CompressedData["
1:eJwt12XYVVUWAOCPKwLGCNaMgtg4BipKKII0Bi2KKKUCgog0EiIhXdLdId0h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         "]], 
        Polygon3DBox[{{1147, 1163, 559, 362, 361, 816}}]}]}, {}, {}, {}}, {
     Line3DBox[{314, 1, 305, 242, 826, 16, 308, 827, 31, 311, 836, 46, 851, 
      61, 866, 76, 881, 91, 896, 106, 911, 121, 926, 136, 941, 151, 956, 166, 
      971, 181, 986, 196, 1135, 266, 316, 211, 312, 275, 535, 212, 536, 213, 
      537, 214, 538, 215, 539, 216, 540, 217, 541, 542, 218, 543, 219, 544, 
      220, 545, 221, 546, 222, 547, 223, 548, 224, 790, 268, 317, 225, 313, 
      276, 1013, 210, 999, 195, 984, 180, 969, 165, 954, 150, 939, 135, 924, 
      120, 909, 105, 894, 90, 879, 75, 864, 60, 849, 45, 835, 30, 1127, 256, 
      315, 15, 306, 255, 353, 14, 351, 13, 349, 12, 347, 11, 812, 302, 10, 
      810, 299, 9, 807, 296, 8, 802, 293, 342, 7, 290, 341, 6, 287, 339, 5, 
      284, 4, 797, 281, 3, 335, 2, 763, 240, 314}], {
      Line3DBox[{826, 1105, 1144, 1160, 1456, 1114, 1106, 1264, 1014, 1115, 
       1107, 1265, 1015, 1116, 1108, 1266, 1016, 1117, 1256, 1267, 1017, 1118,
        1257, 1268, 1146, 1018, 1119, 1458, 1109, 1154, 1161, 1457, 1120, 
       1110, 1269, 1019, 1121, 1111, 1270, 1020, 1122, 1112, 1271, 1021, 1123,
        1258, 1272, 1022, 1124, 1259, 1273, 1023, 1125, 1260, 1274, 1024, 
       1126, 1459, 1113, 1025, 1127}], 
      Line3DBox[{827, 319, 1145, 1162, 1460, 1138, 1128, 557, 1139, 1129, 
       1275, 1026, 1140, 1130, 1276, 1027, 1141, 1261, 1277, 1028, 1142, 1464,
        1131, 1029, 1148, 1466, 1147, 1163, 1465, 828, 1164, 1364, 829, 1278, 
       1030, 830, 1279, 1031, 831, 1280, 1032, 832, 1281, 1033, 833, 1282, 
       1034, 834, 1283, 1035, 835}], 
      Line3DBox[{836, 1132, 1151, 1153, 1461, 1262, 1143, 1133, 1157, 1165, 
       1462, 837, 1166, 1365, 838, 1284, 1036, 839, 1285, 1037, 840, 1286, 
       1038, 841, 1287, 1167, 1366, 842, 1168, 1367, 843, 1169, 1368, 844, 
       1288, 1039, 845, 1289, 1040, 846, 1290, 1041, 847, 1291, 1042, 848, 
       1292, 1043, 849}], 
      Line3DBox[{851, 1149, 1152, 1150, 1468, 1263, 850, 1159, 1155, 1158, 
       1156, 1467, 852, 1170, 1369, 853, 1171, 1370, 854, 1293, 1044, 855, 
       1294, 1045, 856, 1295, 1172, 1371, 857, 1173, 1372, 858, 1174, 1373, 
       859, 1175, 1374, 860, 1296, 1046, 861, 1297, 1047, 862, 1298, 1048, 
       863, 1299, 1049, 864}], 
      Line3DBox[{866, 1176, 1375, 865, 1177, 1376, 867, 1178, 1377, 868, 1179,
        1378, 869, 601, 870, 1300, 1050, 871, 1301, 1180, 1379, 872, 1181, 
       1380, 873, 1182, 1381, 874, 1183, 1382, 875, 1184, 1383, 876, 1302, 
       1051, 877, 1303, 1052, 878, 1304, 1053, 879}], 
      Line3DBox[{881, 1185, 1384, 880, 1186, 1385, 882, 1187, 1386, 883, 1188,
        1387, 884, 1189, 1388, 885, 1305, 1054, 886, 1306, 1190, 1389, 887, 
       1191, 1390, 888, 1192, 1391, 889, 1193, 1392, 890, 1194, 1393, 891, 
       1195, 1394, 892, 1307, 1055, 893, 1308, 1056, 894}], 
      Line3DBox[{106, 430, 107, 431, 108, 432, 109, 433, 110, 434, 111, 435, 
       112, 436, 437, 113, 438, 114, 439, 115, 440, 116, 441, 117, 442, 118, 
       443, 119, 444, 120}], 
      Line3DBox[{896, 1196, 1395, 895, 1197, 1396, 897, 1198, 1397, 898, 1199,
        1398, 899, 1200, 1399, 900, 1201, 1400, 901, 1309, 1202, 1401, 902, 
       1203, 1402, 903, 1204, 1403, 904, 1205, 1404, 905, 1206, 1405, 906, 
       1207, 1406, 907, 1208, 1407, 908, 1310, 1057, 909}], 
      Line3DBox[{911, 1311, 1058, 910, 1312, 1059, 912, 1313, 1060, 913, 1314,
        1061, 914, 1315, 1062, 915, 1316, 1063, 916, 1317, 1209, 1408, 917, 
       1318, 1064, 918, 1319, 1065, 919, 1320, 1066, 920, 1321, 1067, 921, 
       1322, 1068, 922, 1323, 1069, 923, 1324, 1070, 924}], 
      Line3DBox[{926, 1210, 1409, 925, 658, 927, 1325, 1071, 928, 1326, 1072, 
       929, 1327, 1073, 930, 1328, 1074, 931, 1329, 1211, 1410, 932, 1212, 
       1411, 933, 1330, 1075, 934, 1331, 1076, 935, 1332, 1077, 936, 1333, 
       1078, 937, 1334, 1079, 938, 1335, 1080, 939}], 
      Line3DBox[{941, 1213, 1412, 940, 1214, 1413, 942, 1336, 1081, 943, 1337,
        1082, 944, 1338, 1083, 945, 1339, 1084, 946, 1340, 1215, 1414, 947, 
       1216, 1415, 948, 1217, 1416, 949, 1341, 1085, 950, 1342, 1086, 951, 
       1343, 1087, 952, 1344, 1088, 953, 1345, 1089, 954}], 
      Line3DBox[{956, 1218, 1417, 955, 1219, 1418, 957, 1220, 1419, 958, 1346,
        1090, 959, 1347, 1091, 960, 1348, 1092, 961, 1349, 1221, 1420, 962, 
       1222, 1421, 963, 1223, 1422, 964, 1224, 1423, 965, 1350, 1093, 966, 
       1351, 1094, 967, 1352, 1095, 968, 1353, 1096, 969}], 
      Line3DBox[{971, 1225, 1424, 970, 1226, 1425, 972, 1227, 1426, 973, 1228,
        1427, 974, 1354, 1097, 975, 1355, 1098, 976, 1356, 1229, 1428, 977, 
       1230, 1429, 978, 1231, 1430, 979, 1232, 1431, 980, 1233, 1432, 981, 
       1357, 1099, 982, 1358, 1100, 983, 1359, 1101, 984}], 
      Line3DBox[{986, 1234, 1433, 985, 1235, 1434, 987, 1236, 1435, 988, 1237,
        1436, 989, 1238, 1437, 990, 1360, 1102, 991, 1361, 1239, 1438, 992, 
       1240, 1439, 993, 1241, 1440, 994, 1242, 1441, 995, 1243, 1442, 996, 
       1244, 1443, 997, 1362, 1103, 998, 1363, 1104, 999}], 
      Line3DBox[{1013, 1137, 1136, 1463, 1012, 1455, 1255, 1011, 1454, 1254, 
       1010, 1453, 1253, 1009, 1452, 1252, 1008, 1451, 1251, 1007, 1450, 1250,
        1006, 1449, 738, 1005, 1448, 1249, 1004, 1447, 1248, 1003, 1446, 1247,
        1002, 1445, 1246, 1001, 1444, 1245, 1000, 787, 1134, 1135}]}, {
      Line3DBox[{335, 747, 765, 550, 1264, 336, 779, 792, 557, 356, 786, 1462,
        568, 371, 822, 1467, 583, 386, 1376, 598, 401, 1385, 613, 416, 1396, 
       628, 431, 643, 1312, 446, 658, 461, 1413, 673, 476, 1418, 688, 491, 
       1425, 703, 506, 1434, 718, 521, 1444, 733, 536}], 
      Line3DBox[{284, 229, 1266, 338, 260, 1276, 358, 570, 1284, 373, 1370, 
       585, 388, 1378, 600, 403, 1387, 615, 418, 1398, 630, 433, 645, 1314, 
       448, 660, 1326, 463, 675, 1337, 478, 690, 1346, 493, 1427, 705, 508, 
       1436, 720, 523, 1446, 735, 538}], 
      Line3DBox[{339, 799, 749, 767, 750, 1267, 340, 781, 794, 782, 1277, 359,
        571, 1285, 374, 586, 1293, 389, 601, 404, 1388, 616, 419, 1399, 631, 
       434, 646, 1315, 449, 661, 1327, 464, 676, 1338, 479, 691, 1347, 494, 
       706, 1354, 509, 1437, 721, 524, 1447, 736, 539}], 
      Line3DBox[{341, 800, 801, 768, 751, 1268, 814, 783, 795, 1464, 784, 360,
        572, 1286, 375, 587, 1294, 390, 602, 1300, 405, 617, 1305, 420, 1400, 
       632, 435, 647, 1316, 450, 662, 1328, 465, 677, 1339, 480, 692, 1348, 
       495, 707, 1355, 510, 722, 1360, 525, 1448, 737, 540}], 
      Line3DBox[{342, 803, 804, 769, 1458, 752, 819, 820, 821, 817, 1466, 816,
        361, 573, 1287, 376, 588, 1295, 391, 603, 1301, 406, 618, 1306, 421, 
       633, 1309, 436, 648, 1317, 451, 663, 1329, 466, 678, 1340, 481, 693, 
       1349, 496, 708, 1356, 511, 723, 1361, 526, 738, 541}], 
      Line3DBox[{347, 755, 774, 756, 1272, 348, 563, 1280, 366, 578, 1289, 
       381, 593, 1296, 396, 1383, 608, 411, 1393, 623, 426, 1405, 638, 441, 
       653, 1321, 456, 668, 1332, 471, 683, 1342, 486, 698, 1350, 501, 1432, 
       713, 516, 1442, 728, 531, 1453, 743, 546}], 
      Line3DBox[{349, 757, 775, 758, 1273, 350, 564, 1281, 367, 579, 1290, 
       382, 594, 1297, 397, 609, 1302, 412, 1394, 624, 427, 1406, 639, 442, 
       654, 1322, 457, 669, 1333, 472, 684, 1343, 487, 699, 1351, 502, 714, 
       1357, 517, 1443, 729, 532, 1454, 744, 547}], 
      Line3DBox[{351, 759, 776, 760, 1274, 352, 565, 1282, 368, 580, 1291, 
       383, 595, 1298, 398, 610, 1303, 413, 625, 1307, 428, 1407, 640, 443, 
       655, 1323, 458, 670, 1334, 473, 685, 1344, 488, 700, 1352, 503, 715, 
       1358, 518, 730, 1362, 533, 1455, 745, 548}], 
      Line3DBox[{353, 761, 777, 1459, 762, 354, 566, 1283, 369, 581, 1292, 
       384, 596, 1299, 399, 611, 1304, 414, 626, 1308, 429, 641, 1310, 444, 
       656, 1324, 459, 671, 1335, 474, 686, 1345, 489, 701, 1353, 504, 716, 
       1359, 519, 731, 1363, 534, 788, 1463, 789, 790}], 
      Line3DBox[{535, 732, 787, 520, 717, 1433, 505, 702, 1424, 490, 687, 
       1417, 475, 672, 1412, 460, 657, 1409, 445, 1311, 642, 430, 627, 1395, 
       415, 612, 1384, 400, 597, 1375, 385, 582, 823, 1468, 825, 824, 370, 
       567, 818, 1461, 796, 785, 355, 556, 1460, 791, 778, 334, 549, 1456, 
       764, 746, 763}], 
      Line3DBox[{537, 734, 1445, 522, 719, 1435, 507, 704, 1426, 492, 689, 
       1419, 477, 1336, 674, 462, 1325, 659, 447, 1313, 644, 432, 629, 1397, 
       417, 614, 1386, 402, 599, 1377, 387, 584, 1369, 372, 569, 1365, 357, 
       1275, 558, 793, 780, 337, 1265, 551, 766, 748, 798, 797}], 
      Line3DBox[{542, 739, 1449, 527, 724, 1438, 512, 709, 1428, 497, 694, 
       1420, 482, 679, 1414, 467, 664, 1410, 452, 649, 1408, 437, 634, 1401, 
       422, 619, 1389, 407, 604, 1379, 392, 589, 1371, 377, 574, 1366, 362, 
       559, 1465, 815, 343, 552, 1457, 770, 806, 805, 802}], 
      Line3DBox[{543, 740, 1450, 528, 725, 1439, 513, 710, 1429, 498, 695, 
       1421, 483, 680, 1415, 468, 665, 1411, 453, 1318, 650, 438, 635, 1402, 
       423, 620, 1390, 408, 605, 1380, 393, 590, 1372, 378, 575, 1367, 363, 
       560, 1364, 344, 1269, 553, 771, 809, 808, 807}], 
      Line3DBox[{544, 741, 1451, 529, 726, 1440, 514, 711, 1430, 499, 696, 
       1422, 484, 681, 1416, 469, 1330, 666, 454, 1319, 651, 439, 636, 1403, 
       424, 621, 1391, 409, 606, 1381, 394, 591, 1373, 379, 576, 1368, 364, 
       1278, 561, 345, 1270, 554, 772, 753, 811, 810}], 
      Line3DBox[{545, 742, 1452, 530, 727, 1441, 515, 712, 1431, 500, 697, 
       1423, 485, 1341, 682, 470, 1331, 667, 455, 1320, 652, 440, 637, 1404, 
       425, 622, 1392, 410, 607, 1382, 395, 592, 1374, 380, 1288, 577, 365, 
       1279, 562, 346, 1271, 555, 773, 754, 813, 812}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJxcW3dUzf//Dw0lJKEUkZKQNFXSs4FoodKivfekJQ1aGtqJ0N6R0h6vdok0
laS6e7ZQopTf/Z3zOd/POZ/7zz3nnnvu+9Xr+Xw+no9xOmrtoWe3lYmJqZmF
iWkb4/2wiYPXXhlv5eyRzOmCCxOI6WTHUs/QPKTaFm/gtV4os+0+MkpRGUde
T9uHxpgWQD4trvLh/Vzl93ojD7XGxpD6TdMDTGoL0BKkF6Ifn698nHlauVx0
FEkOHp8LjF4AjjWLCOGhAmVMEW7HB91hFGj7pKft4wJsO5RbU3WnULny70+D
2MqPSJVL9NLOPYvwczbyq21aofIbg7Dsnzn9yC9wLatWexFErEdmHC4UKluX
bjGSedSDdu4w3bkRsgijAjUtH/0KlCm4S1zNoR3oMtex6JWSRWjQ0Ljapp2v
HH4nZ/24fAua7LMl3u1fBO1j2nZOnbnKtvblfnvxNeicsqXGFtwi7JPuizHC
ZSs30iOgXf8VmmF7Nfz82yL4pntkcFo8V+bc+c66wSoXnZla3Fq/tggxGfde
plo+UV6iilZM2CSi1CNVJj82F0G8zCnwnH+scq/akVhToWutan///7UIF3nd
mJhpr8FJP7RTJ2sEcQgd+20cvwA6hny3NiM+g11HzTF/3yEUdLRnyxubOeCq
2ljp/vwVmDPl/RsrBtCV28KvK9LoYNvILq94YRbuC1RofXnSj9KU9NOUjtDh
4CXOSzJaGHjk1t7e/6IX9bRtbCSQaPAuvqCXIwsD2FaXc1FNXehNrZCD9BQN
OjNEWc3zMWAYZuabPd+OnGQCVq/+pMFlFUqqqhsGZi85K+Y6tyJqY1x1ohQd
LnDKZd5anoUzJ66fyT7RgPRdU/Zvj6PDCY4EzR3pM0AXza7o53+LQuWYBPn/
0mHlU+xPrcav0O2woZSc9QrFposTlqLmYL6Yc/ac8RfYfUryMOvzApSulLO/
4+g8uF7Wu1FhOwFqJWdDw9FTJBC2q/FYzzyEDQreFBkbhQ4TNhv3W9HoYBX/
qJbrAhjkLgtQBXphrJ86I7ag0cqm425tFLAIYTetc0WXmmBHyfgpcZ53iPq3
31JPYhH8Yq/tZhrDQc/hpKUA7070S+Wl5A8nKkyxBJRGnCGCrvgdWWJ3G/LS
H4nBPydDyG2MCdmQBDidOrcTGi1ImurHzveCBJUvcH6lSyTgUpzZ5/6kAb3M
35XqzEOCvYV5/m5SZKhJz7CRuFqL9i2s1H6YJkJ0slthBePzy0SLi1xK1Ug+
YvKoAJUI5dfN3u9fI0GQgWaqu0UlosYXn3spToLHBeF7Q2NI8Gb1lpPL9TI0
kBORIV1EgviBd1a/p4iQdtC3V0WwELma/fqhZ0CGFR2t8zJkAgi1/G5oEc5B
rge783NkKDDK5xR95BkeOASYl9I7nqDYuQ8H9DSoEPNAj34NiwXo+S0V7P8Y
Jd2YGW6KZvTD4bTXXIqzMGG40+VbRDDaIbxL6+4CHT5aNNorKIzCVeM8I/08
5dYHduoT9RELYHhs8eDh/na4fHptQCChFaUkNNBv3VmEe9jrpj96idD2MSV/
OaIGMYvp6A9fZfz9WWXiNXNkuIcRyvwlWIWWbsfc1jxKBMrYJ/EOGgVkTs8d
5lR+jYLN70q8XcdDuKhRqwOjPtGNT0HiSBnqo3jgpizwoC10iYnrORV49vhs
G3xUhD4+TXopcAQPghln5ySfUmEf3svjxLV8lFRj8rVQFA/9uArrLY5UMHzh
cXDlRg5aCmFqnXPFg/mI7YgwKxUcjxeeJW57jvr/5ii8mMPD1+3r0bruFNgV
OaofXJSB+C5qYR2LCOB8WT34ewoZ+g9gH7OEJiOJtXPLOdlE8Az09a2xJoG4
dFrt/I5YdKW+v3/2KwmCr2h9GWsiQK7al8c03zDkKvvo010LCnyOspBT9sFB
x4FeO+VKTyR28estCREamMG1ipL8CfDIFoy/xyrVes1mySO0eR6E7l3Pe8Le
BVmU4eucSlUoM0lFZDFiESZSXB79PEEGAzfpYXWVYhR+JyutiI0EeraGu4OF
qXCiUNVju0Q+oo+summ246EpLnl+bDsNvJvO82Vp5SB+9lCzCyk4KOV4Yl3t
T4MmHy2XS9+eo5kV182QZSxw/Qlt9S6gAR8r0e3jj0wklnxnxr4aCxMHRKMw
OTRI10w7t2Cdjq79zDi20YCFmUN2LQa+NDCQPXVcQyAFMWuFDWVvYmHwi5g8
hwANnu+hbUpzJCJPt6ZtCfdxEC1zda93MhVeLPf/cVF6hMTTwlWfncfDiLv9
SEo/BU7zHL3wPushmlM5Kc97ngDNQeo8hFdkGMl0ZlbUu48Mh+pWuh4SweGc
6VjQIRLI2cXgmZp8UMjxqdW6I2So7+ifpODwoHqzLzZwtw1Sus2lu52bCldl
bk1ZCnyB/Jzb2Ty8Iq2+JbzlcufmoX/guC3WvBvUmztsH8YWIpxAnO7Kw0Uo
o4ySn82SgbRGT65ay0JrB7DbeDSJoEB4d4fWTgXNjPxsj18Z6Gp6bYDUbxxE
wG2+/gwa3Nlm2DARmIq2JcdXv3qHheLFd1wNf2nwS0WKJ7Y6Ca1eb7DhO4WF
kKfHX/8+QQehEv9Ou9IElJS5k0+QhgGhMeFUAxE66P1xt2z0eYS2KjGXOy1h
oMUnxLxkjQbblT3iqBmRKPVFHMlOBgva95WUthfTwKs/nffLejh6/uh7dg6j
XuadJI3Z4zS4f7bw/LODIYgde17ysScOVAYjuiWdqcAtxnOEJcQfebq7cD/y
wkOspNCbY7cpYKD21LZvrzfq11pt5W4jwAXcNE/sJAlItjLZczkOSGdXwAse
BxIUZufEGpcRQFCon3p11RBFTdiFjblRoOqPiUlmzBSEHP+AOdrP1yroQLpA
wc1BqG/0ZpNMDxznrPqmnPIc6dpFd1wLXYSlu7nf2a9SoDjoCFfns2SE7Fx7
7owR4FhUe08mPw1eSfZ/vl+egPZN7iTpheDgTfqy8QcKo2/P2oe0ij1Cj57w
V/66hoXAznvm+7XpYB1Eu3f2SSQ6W/r3JVsVBs6ViHTc9qHDj/tcXKGJD9CO
dLyXtRcGqAFnvnR7MHCO/TDRAhOKQumEFwl+GBA9uN2TdpkOnivxC5Xj99Da
uTU2jiYMfOks6OxZpYFRvHCAGPijeI4kwVQFLPCvPugdDqLByg9v3gM4H3Tu
pZPdrxUsBLDlRx/uoYL6w4w6wm0PNLBpoXB6FQdlzrFbURsFqGzzLc1nHdDW
MNGueg0ClLHF5K1okEF23suYx94cqZkaLl9eJoLfA67PLUIMvHwfsnO1QAd9
c3daGWWlgOif9TBul6+Q3bkYOfKBqzXbNWSQv3wOLqrk4Tc7e+CPmNymxfNU
VPfJ9cDboEXQ8ne8xxlHgXiKwt3olBjkQiSbe0YSYPj7PE3EgAbqVWf1ObZH
IHtm2+1GEji4LBDSWcNPB4EmkSvO9DB0fH8m5R4TFiq5d/Ww3KMDrjXx8vnF
++iudkPhSRsMzO9qa9yZS4fT4WPB7b2BiJSc/XRMCAOpH3SDol/QgV9q6wkq
nx9aDQ6U+naCURduSQfsXTqQFzflF1p80KunD704XTEgXPfoJ/tJOrSp93F+
e+qJMt5LsbIy5qLpnthc+BsaiH97/lBdxQV1h3paYguwkLuq3+bJRIOw0aWy
nQ/sUGkSa8lyIQ4+HFb8SWSigkNCxmPPLxbIt5n/tvcvPBTkH3P9nEAGzwab
sjmqAdprrdwlWkyEm6nKbvs9iSCXasMk4n0RDRzed5TeTgbqkm1yDNM0eKlK
Ld++ztbqZDc68yRyDpamfpetiPUC726L9cbLCShT3Wh6zG8RmGP4d+1qpICO
dJ3Y1ifhiLNveszuGgHU6k+bdgbSwH9JOPBb1H3UTl7S1FrFQjubiY69Mh12
DBFUizcDkHXfH8HVPgxk3d8yVpRFhwd6Oy/h3e6i0CwTzpOnMaC1ewfneDsd
CoVXThxw9kF7n0honvw8CxXtCkctW+ngBN3bjZEnclnAXL1OmIWa3JsHkjPo
wJx7hTCZ7YoMD3YorMlggG++eMqQMS8srncNj+93RMOo0DWMMS8hVTc/nxun
wZeAn0mYbhs0ck7wANkNC9UmPFTHEzSg6ItF1ShZIKbZ7Xyd7jhwE76ZuVWc
CkYvOuMqRYyQiESIVnMbHm5prXR/RGTI+HahqNJdF5FRhIarNxEUf4a4jBcQ
YdX07yrnwAXkfSa0ej2RDPybpWW7nKchJZCjOI9rS+tesQDpGJc5kLfDHhC/
2wulv31mxk5HIXvKQk+F7yL8Lo9wS5iigM+6FK5V5R4qfCRmmnScAKKWwqd7
0mnAQY6cVTrlh9J3om+UASywkD51RhjRgSn5jcj1Oh/0bk66c2c2BvaHW5Iv
vaXD50NO2tgtXui7tAquYhsGXHnHGz99ZvR5pGDsQ083tKt3yv1Z1CyozRhr
u36iwyZ3eOMlOyd0i/8h79sUxv2PblQqv6YDJ0vIYY0aOzROdZr35sRA9Z+o
B9J2dLDJJBRnXLRGRdiY5hcxGNjSmeY/tcTg6SZN00+ZzFFrPZk/9yIWsLUl
Dn6XaHA9nce4tMYIzXE061y8hIOPJekaojpU4Hwxx/Ey9QZSmN3sCM3AQ5tA
WFQmngyugq7bHYU00LZPdRFRjD2F+D0WtAeIQF+yH8l/JYe+/Djuf9+VDOof
zwy71E+DpfvfqvHday03AnYcOWI0B0nbsba33vSC2GCowDu9cBS3iUT4vRfB
2sHsz64VCkhIiN64I3uX8fuxOnvYCGAn7j2/vZwGVvs8hC5LeaPW31z1+19h
wZCVTyPJmQ5FTqwqi8vuiOOZzXh+KAYGCPHDJ3vo8H1BnOljlTO6MOH25sK7
Wdj9lciqRqODK6VtjJnfAdVRVzxHr84y+HxGJY5EB/fXyidiF2xQkdxeUdzN
WZhkkrM/y+j/u1ZyuL/sVmgsT+Jk/ZdZaONpqt7lT4dAKVvmF69uo0uHfbIu
OGPgt8ySIw8LHRq7fMQ5HhuhwYOaXxeEsfDSLU49/hYNCsTk97e/1ENr70I+
m4rg4G76YFa2HRX4KoaxW3O1UFlkqHqLHx5e9la20TbJsHny20qipBoSi/4V
2HCKCOw1PukP6URI2JsS+OmLJNrr5/RN4ToZxmYCxr8vT4NCXEflyaTlFknm
c/vFNebAd/f+rteYXvjVWsX9pT4YfdPmfLDusQhB1wvsj7FTIfFy4uDIvBfq
zZlh3baAh4h7byuam2nwxk5x/vstN3T1fWTYRCoWEvZsljwIoMPND4vWl1Yd
0exF7og2BwzoNtW4y4zR4dBRti2qUXYoybq1l+PJLARiClLmVunwLu7st6s5
1qhPOKCTzDsLnM7R99KW6fD+W/icLLclymR5XbQgPAu6p7qWLg7S4ZjEinBJ
4C10b9XvQUDJLJwiWih+jaRDnW2RQ+hRI1RJC8Ja3sDASNQe3VUeOpCc9HHV
TPpIbI/Y8ocdWDD66nSE7koD+T0xrMk7ddFCahaNjRMH59x+0Ij+VNj/qq+y
W+cySlKNWgkxx0OOyaiDHw8FnPKwb7qsL6DGZ2HV0nuJIJ/v4Om8jQTs2pZn
ZL6eRnLpb5+XKpAh9L3oLhGRGThsdtJzvGipZcRhSum24hzcuDsq6c7WB84G
Vq/0n/oje5gblXFfhFj70znmfFQwa/FVHk9yQ/2DdcFPJvGg+yK8VK6fBmft
RyOcpBzRz/2laddCsfBg65PniRF0GHAIxgsn26Kym87yUfoYENxFKX84S4f1
Dzzegc1WSNsxgrE/ZuFoXD5ucescHLee0mGpMkeZ280kJL7NgI3/0eyXDH2s
v4/NqyHQFJ2zfl0rsTEDO/XuBbz4Qofrv7DlqXmGqMfmECkobBYyBr5uvk+m
Q5JVXenaLn0k2Hcp6swFDOxcCInsO0oHepr4ldob11AGk3KDxSqjz5+0f1li
7Bdq7rmBO91XkIKD0bw7Y78c/Ps5MCCaClDcs/rORg1llUqz/biKhzpC1wGq
CAWSP3br3L4gj8poXytk/hKgQ+sA4cN+EjjeLFXdMyKK3IsvN54XJUPbhTw1
X+0ZKLiz59rJR/SWgz4eXWMSc8B02A2QaB/sfrnco1Xji262TFZUuy6CrPaR
2q7jVKArbvZ7DTqi/vFzArl9eJgqrdPW+0QDuStbr//RtEXTtKdTGh4M/jZx
vib4MYMn+IeQE8AK4XjEPneqYWDiW1DWJwodNE068pxbzJBx/Uvrdd1ZeNs8
d2EL5xyUuBPFPzeZILZe5oXLQzNwUhJbU7t9Dti/Fq2zShsiJiPyabWvM2Bm
nWO4iqeD8WNZ0S3reqjROfiaieUsKDVmGuQw9mxw0oXnDSvXkFTAVisvxp6V
vDbbbXyasZcz3jV6qWuiyzbrvzxIGKiziZcLi6TBUGADR1fPRaTU5qloTMLC
N9OFfoM0KrxzS647PaWMPLbmJuPk8eCuev2BPkOXa6wr9E8bySC7irKl1AUC
LDsVv/l8nAQEmxwBByZhVMzVzos7QAbrt6fFhN1m4OqQVty6KLnlZl3ANxbR
OdiFcbUXVO8D4Vv4Z4XlXuit7OccJ5dFOEXffZBFigqrz3bEBh+2Q2EmMYeu
N+JhJ4icz5uhAY7VuPHWRSu0wL16ZM4SC0G1xIZBBh/IeaO28tvYDP0+uGUh
j8EHRE4wRmyJDn2tHcoB2iZoPDz2Dq/0LNwzCXd8uncOPCLPWH/F30TbfpBy
Hr+dAU5m7hYDrjkYNIgekMHpIYcjXS6RbTNgwtnd+YFOh8qr9qaOItfR1Q4K
l+fFWfgp9it1Np8O3BlNca5ntVDAwj4Wo8MY2LTJfyQjS4es78J+HsaXkcT1
qSqxzxh40rHOIZtIg4aPL6q3vlJFX4X+qi5OYOEqxzedI9lU6Iq7YHFVXRER
LNcU7p3Egw5rv5qXCgWGhLLbft2QREEVaXyPMAS41bS8x1SGBMdTWA7eZj+K
2N+MHiBxkGHSeo7UHj0DdkPjVvsRviVB+4d5rOAc7MVo56jE9MCOYC+Lb/lj
6PaFXuq7jnmYKplvWXL5CKcInEWW50eR09+T8rSEeZDOvn5pwngYbjypveZf
NIz6aqzkn4fPAzs+33czbwSGr5zlz/42iEJiZn384uehZU6Srmg2Ckl5FuwV
Ph+Q/zD2flPxPEyXcEq55Y3CdlE1lEbsQ/6L/lowNA8e3wjz/ZGj8LDgpO+f
m90oWZnL8BfTAmjWR15J5xoFew2xbYMj7WisLazRW34BXljnYg0vj8Au26Tl
utFmpChTtjvedwFqTYf0vU8Ngz9XlYGqXi3y268nqFu9AKGpVw+KPhyESC/s
wsyFSvSL1eBm9/cFeHqT6/L9Ax/gcO4J52WHAqQ39x4tnl0Ejn05Wx/u7YML
jnGsg5oZiPv2KvkFow+/naztEwzqhO+rd75PPApCj4S3KltlM/Sd6l/DatwT
5QePOwjmY+PI+eaJR/uI83DelH9t49x7yHV2et7xcxTB50rXDznzUP4zUSWl
NRuCjzcOThl/Qo8qfa7IH18AHBinEZ2G4EarjELSnRF05Yppv2rEPIhuPt5M
3TsCP0d+mHSMDKGW+5t2xYzPHRydbrgz7uf19639ubIfEY/qDy7jzHnwNtEZ
DogfhfFsqX01Ff0otVO85mTTPEgm1Tt3Z48C71YDH95Dvah/48uPF+R5CNYg
7Ag0HIUA5+bO9aROVBX+bohJYAEq6GfY62tGIJQ/hvPswTbEOXmYhdNwAU65
SUkOdwyD1YFg2omoBpS+Ml9cl7IAHuzf7P1Ch+CT4M+CZ/LVSLKrz5l7dAF6
UxX5SZgBoNMu2gW/L0WyogatItyLIKzV8kHlRD/sr9c3qTXORn3KYn+ndBfh
yOQ2h+LJbkA577/OGMajtwnaWymRi3BuUYX6vTRN+cfT1baaivuIar9VvPvv
IpBnRPQbZurhwN763Jci2q3d67WqKpOLYOZ0rHz5/RTUlouuCqe9R92Rknua
/9DBlpByTCQNC/cSfUjNPH3IzosTjXEy9GEXzSbjIh5en1osa7nQjbRp082v
Nhh6f66NqVKcAHUlHrwxjR0oIjfsNYstBQr+Bhvp5BPAOeyMiJJbG3LUGLXG
HqTA3J4yprP9BGjIvlb5Ja4ZqesctVfiYuglvZQNcQUcqAx/FcjZ1oY2b45/
cvpLhRdexaqcDB2cdGRSJTm7EbGIL/j/ZszvxqWzl9PEyRA0xROpqeGM9jNp
PtjLRQIm9iSLNdk+iOll9vzA54MmrvFEbGfso+dqLNZMjOcKiB2wvnSWG7m/
0GHv0Wfo6HDH+rYhAuCSBa6QhriQBFed918dCoh0xPmuMPaA0d5And1v3yFq
kOqo8hcaPIx95vo3AQff13ceGnrWg7YuNrh+9qbCilf57Kd+PNyUPevDsdyJ
DEzLC4ULKGDcswOT6EuA1YYrX64ltKPvu/b59MhR4AmXs4FgGwHiypLrLMta
Edfza/vv76IAvROrfvcJAXjnyZox681IzMom7r08BQhWEx97pMlQ3hW5oKTp
iB4xn7iSzE6CuQBMfFjQDPBELTUamxBbmIbtRI8dmwOVUE5+Sdtq+ELQ/+yp
PI74lkZ3SFDmIac10uTeVBU8H+XHzzm5ojNea1uqqIvwKdKH/7wAEbjOOAlf
nXVBrClOKcGcFOjNuWXntoGHT/eAI/HmFtTdFjyx+IcCttk/NQ7m5ylvuZ+i
ksA8hgRjeJnWbBeA13D+jEF9O1iWR6daxI0icb2n/dkiC7BbR721Nb8DUl2t
3iTWjyAvR4zRVeUFEA76sxl4sUDZXLfwWz+MoAS+vwaUsgXQwq92Es07gU/k
VXLpl2HG709EBxgvgJg4n0TyQifY5S+3BiwPofLBQYMXPgvQSDkwPyBTqLwr
+9BTJ8MhZO/0ODt9aQFuXQpoWzTugjHlPucnbEMoNaHyh/LjBdgwTCh9mdMF
zVrGI1tPfUTXcg/9XildgFlWkZ+qaYXKdaLz90llH9CHSzfDJyQWoVX0jqrW
+y7wMOjpkoMP6AF7gbtbzwJMFOlJ/Z7oAik3CoTo9qOew1Tf29gFOJzWLVrm
V6i8Nhyb35rWh2j3lcsCHBbBu7jtqeq7LvBu+mJ271YfivImtEasL4BT5wav
Z3YXmEpo2rY59qCuawahtTyMupy++7aLXKCsf35RQSW8C6UwCZDF0hdhPbBY
/ql5F6wFad0Y8e9C+zkyXnSfXoQ40d07XjN3Qdm9vw1nEjrQ9MI9phT1RUjX
UNofspCvPJkd8Mozug2pS8XXWzYx+ENj+ZuwlE54M5z4VqOsDTUtZ8+xmizC
5UeP5oZ2dIJZwIkr2wta0MqBRZs9bovArnm92SslT7ma8HFH9L0G9F330Gmd
iUV4JhBmrO3eAfLZQzrBnI3ovvGYT0nIIqTeSK3JaGqHGF8LXHRSLWouex38
IXERBB9wLifuSYK3faIHXgeMo50zKzpsK/Mgc0xGel0tVfnUkyi735luyCSL
6dp3Bo7xXRPE5pWOwe7Akzw1N4bRvkfbR71Z5kFAc8Op8WEtvFI7UbONbxBF
sr+XHaYugL67/9KANwYSy2Ssf53rRj+yHRoCF2gQamO/I6YYA7Ra8uP5G53I
9NF2iWsEGugeZ5I2EmwDK/HQizV1najZ0Gf4zO1FmMnNu/RQkAjPpBVPWQ46
I7cnw0xZ7BTwe++opB4+A3HP+i9JRBJaCKfW3HSPzkE09vvvYy2pyvsewOlV
rgmk8J3ZxntyHp6ec672floCSg8InAPzOq0WjfcvtK0sQtlzzagKpT74sbQJ
ODNvtMnZm13H2KfyC7oDfUwEeFS6dU9JORMSeVvwE9Yo8Pt2N6GEOgYj7jvx
I9xDqMCIQ/a76Dw843609NbjCxxp/q5w0vsdSnTL5nnkOQcnYuXtjr1i4Akl
Q+dkYD3629CWI6dIAa1w9nBKJwGEhfsDl+81okLvA8XcghRolLaOjtzEMZ5z
cG1tdxu6Yep37pgnFUIu6st2+s3A2wdxtQMpnagsEOt1q5YO9m7lDyyuE8DJ
9q/GW44qVMtG1tR9SYGvG+2/t/jiQWqXQZHQ1nqUe/ltzIoiFW4XDd+qv0iA
4dEyARmlRtSwZMbiFEuBFLZT3q6JGEDuMubVCW3ogPLSaiwXHbqo0uYC33Bw
lS7Iltragra9JLC+jqCCYqgGcX2CDDH58zIxihWoXWK7wz11Irj7x/f6ZpDg
7buDU41clajIhpXpezIJLk6b/fhxiQhtmeJMi6nVKH5QW+NBLxmiRgKe8e0j
w17WT1cmiqtRz5L71w5WEtSJer3SWCLB0UNlnXJv36DR3Aexr6RJcEryc2Z0
0gTMXjaWv1sxhH4fCrmw7fEcGEm3Pc8qzlGWT7gR3yTxCe0NSiAKSC2AnO2N
ldXeKcB/lLAfCP2IlLmIR/YO0EEWv2oTazIDO24crg3peI9UDKj1XLp0+B49
ODZLmwUZuXfXigTeoc7u+lpNZjq47I4T6OYvVN45qmb2LHUIBSWbcV6nLMD5
h502w04M/X0lv2EtpgfRsuehH0cDKOz/WBpRqFw04PLe/9UAmlPcYV1zZBGC
8uOs+BMKlU1jZFz2Cvajg72rlU/1F/+X/2L/k/8aTMvWNG7HgNNCUqfwcAOK
klZeORpGh9LSd7V2CzNwvYnKH2NRg9j7RyTYGfoqM+nDHJP7NOwYNXbjF3iD
YtkN47E350AzILTh0miOspD836v4yCoUWv568iFtERQucu7hip0C+etr7uGH
S9FRJ5xly/gcVHQom8ftzlZe6bqS5TxZgqKH4+PjGfPCmlaeyQST8GP7qFBm
VC7icp/4NWU1D583v+2oFsxSJvyU4pkse4l0O7Mref4sgq4su0F8+DgYPf3i
J3goAw3hniWbfJ+Hmmu17XLVGcqKq/ykSJc4VI8muOQYOHNAyT3uxNAISIfa
8N6+GYES1iKUn6Ux8CTh/T1JBgvtzehvKSZ3oj5MWxXLEBXUvqZ5GGcRIPn7
6u4hXwYP5/tA4N9PgfvyBLIXlQjKlg82LuJbGThTlvDuLwmIvVocdvkkIF2k
+UV7NqGFGLmFKRMSxLeouj9kJ4OmtYkMzbQejRc/Zz7MRIIE2MWeLEWGPxYF
BWsRNagjsJ9ejSFCZr7mt1enyCC82e8fh6lCFnojmejbv/nyvf/kyzfQqxMt
jLm43Yp+uW2WIdPX0ZqnnjB00bf6kzg2ErQn7d/H71qE9v4QOpkpRoa4LFsC
30Ui7NXc/bh8Wx760Vna2YElwy6vGllmdQLEJhKnmqKfo8/UjXKlNgYevnnw
nuUXDtSN860O2aShM21MPiadVIgsHHM5ro8FW58ziW+uxSK2xnztVyQa/IoS
feL4fhpIBprnzQgByIPrmPXyjTnw52FtSztHhJSS97mjYrXISuxu95X3jOc6
P/jMEU4Gk0NacnrEKnT8S+xZ7jQi+CSM0OXiKTCwe9vqo8RKdHH8bN95F4a+
JvSceXGSCqmnNEabJSrQHa4/RtKv8GDeTOQi3KOC2H2Dhit9JSgnW+8SxxU8
ZDwOoJhnUWGUY5ab3lSIFGwn17cJ4SHUeOb3rxQq8P1GynGLeUiYzcnT5Oy/
+bLRf/LlM7smOyK4qWDgGyvAXf8cHRBqyO/+igf7kHPF/akUqHVbPnTk7xPE
fAyncTyAAOcFZJhZyWR4qEdWm/BIRU/iFufOM+79YtBk8d0NBg45M/EGMSei
Y8vV7CMqJHDftNAz6iXCcHuXUsfdKMTik3BTx4sMrqYS5QUMHl46ueuzvdV9
ZLm8mtj9iQIPWz/a4MuxcOxPx6nzWm6o2pLdZLqcBgUi0xNGlkQIwHvUhViW
ov43Kxt328kwtUNHjlpKgVndOzLkcwWos0vDSNWIANt2tfNj3lKB+ZIWfr91
LpJyEdiLWPDQtfXPHVVVGtww1nN0FcpGZnfLpmQv4uACqeFsUgwN2qqW3a57
ZyHnk5WOIl8ZfRBPupaYTwNZZm2LJ7szUela3+edNVhQzUgrV8j6f7+i5qDQ
Whp6WPTq9ZMOLMz+ky8b/pMvs/yTL1v0pAjKidLA/nOcQJxrIrqp9Lel2B0H
EfcT95nWUOHL6Uesq1WxKL99v2o9Jx60uD+31+6nws8emweNDZFoW5v4KwVG
XVjM6vXmlSnwftnVIZkQhioyPvCMYAlwQypQ/x0/GexfHHZzNQtEFNnTYVFC
JFCcffBdPYUIl633DdZKeiEVw1MLhBwyvGibWGfmw8PipGWFeLMlCnm3b/lo
BRW8u126Kw+Q4Nzf2D86nS8RJbZZcPEIGdQc/t7L16VCm3PdU03lTOR59FTx
wyQ86CtHmZy7SoPwp+KRmu/TkNpPrbAcJcY+fiT8Uf4DQ4dZ6hlFHkhB4Ycf
Dr4JxEL7vZ3tF3fTYaiVn1duKBE1cbp+7OXGgqH+pPKeE3Rgn4kfa8qKR4cn
ndSr6Bhgl+Gc2n6EDnlhLI+u/opBXIkZqou//s2XOf6TLxdPRwcHV9FgvPOi
kK/HA/QxrYVjKA8LB3gjNos0aHBszLcOnELRFqVXJWWqOLCWcFQ7XEWF0rN/
3mWsBaI7J7TkOLjxgOXO22tGpEDSwcFWDa07SFiuKDz1IAG6RDanSj6SAWMR
v3dvoAeqC2bPm7Aigqq78J8cPRII4rUV87JsUWyz3I3oeRJwcogzkTF4sOuK
0Gc5ZYBeltz/k7+XCg4HHgb5hZMgjOtaVe79VPSCO+GybjMJXol/q75QToWT
uetVP04mokjeiFMxvHhQ7fNa8X5Og9rUa1Y+X2PRx+vO4+8Z/ebzzUCSeJAO
vq9xryysopHPldXRK1uw4JC+JIQ3pUOtr23L7TsR6E/X1NhYJoNH6ur5+HnT
Qe7ZgWv+hHBEVzFrmWfwzkbtgYpqZzqwTbI97koKRTq6r55vC/03X/b+T76s
/UIl4P0WOkBxyQ75EX+UVBZ8a0IMC45P9/BpPWPc86nZ0Jbfvmjxruh5qV4s
nHlmkui0gwa7cNGnU9W8kINC6nJsBg5G/A8qv7xEBRmRvdPiV13QgXajMZEc
PLjpj2qtMXTn47fJB2JlbBG5b5QjkE4A8zL3JIdOxr5wqGSfiDRF4hXnI54F
k4BemD4dYEwA6A7pYePQROa2Z/xYqing9dYxvL6HBMXBcwdeqMUhZ9VTHqIB
JLjzMdDNikyFOIiPcJaIRBd3n7s934cD/Yc4Qd8RGrRDJdflAw+QU5xU0z4f
LMyZXQq8pk0HVeY/Ie/ehCLrUkV9vioMFDudTTV9RAexVdLzUMtglLtqPM+j
xehPlZOvTufQgVBvVKT1NQBVLBPIt4QxEBfj9iIrkw5oz0kZr1d30SsxR6KJ
5L/5MuU/+bLe32tpXdJ0WLd5EWL71xOtzHbfMf2CgQXmUi7BIRoclP5geqbV
FQ0QSKqKflj4dXw+7Y86Db70nqCwlzmga28wxiYaODiRPvdsMpwKb06/b2lu
sEYDospKpjfwEJ1xd7A0gAJfxNq/qHXdQnXaQU43nhNARSELfu0gw8rZX1ci
VfWQvVJmyXkGn7Q3YR85XkgAFuK5NN0VVXRd6xZd0ZsC97q68J0rJNBV3jpf
nPEQZbw6HvzsKglsl6FgZDcNvrvXDpwTCEU3P2zb5EzCgY3ktbzMnzRgr1U4
iqqD0PHyxKeG57GgxuNybdWNDirDwpPFcv4oe/II61ggBvpVg4pKS+nQlCIn
9VD7DtJMN7Q8zcPAh3e5nb/a6KC+iAt3QN7o/qWJbTJTs2AlJafyuIEOSW9S
qCFenkiqU5xj98q/+TLrf/LlBS+Wx9M36aCrZLU1s8gROY7cSMbnYsCl+3aL
/DIN1p/5N137YovW3HrP3gIsrK4sWTQ40yB34AYvTdwK/Y265XluNw4Go7s2
sIz5dedbNwiVvoWuTry6a8bA2ao4nTtPiyjwp2ZORU7CAEWRpze17QnwQYIe
dEqZDIoFR2elkjXR643XUsWbRJBkqv1w/isBQja0eYXFFdG6ibCNyEUKTFya
xB3mJcMD2fFX24xDEIHPv0DlOAkCZArdzorTQPnwICH4jj/yWqfHtTrgIKfy
sdN7hi65Ut30eGPbHWTucb1MkYG3XBZBTDcj6SDldQCPu+2NVJRcWwT1MLDu
Oy6ws4NxP8SS2mvHPVE/5cSdqIlZ+FBnGrM+QQeWqs0tNW6uqC9s67ucR7Mw
Pbrd4vUQ4/ulD7t0Fh3R80/ftGzz/82Xd/0nX75QyklLcaeD62R0Q0eVNUpr
/4TdwahviH93udMuOkRFx0Vq51mgj2EvT4nvx0JTSQTvTCQNVvr0ujDcpujp
0ZLUfiIWqjMmPwe8p8LCnEg+ptAAsdDYs38v4iD0YfPGoXcUUPI8eWJPmS56
FRReEX2BAGZpF40p1mQYb77g+kX6IrqiiF6nThBBSuzO8OY2ItyyNZdNnJNG
EGIr0XqUAtWDXE4GDB6rwkZgJZf5o/MO7tcXOBj8xi6Wep8xX0lteh0YOR9E
lRX4vMyYr87o+OslwnTA4wJ0boZ6Iq2z0xqF3zEw1fvI+sMTOmwVHsXfGHNF
e18GPMNJYSAvfzC3a5QOse03Rb+bOKHXs/5XYjJnoT7tiJEzlQ7E7ZNRpGv2
yC0cd2VCexa+r1H5ZHF08HJR+/I3yQblvqJXRdr/my/7/Sdfzr6YVnmDoXsC
ghz3udwyQ0fC2eurTTHQBzFumkJ0CLtkF3x7whhx2XrLx//EQA1JpRUYfMZ/
s+SXSaABogXzpHzvZsxjfc0vhKMCZ8MTapPCdeS3w2f90BAO8otb/ItxFED1
eR80+K+gcQGZeb7DBJDcc9n0131GP0teDKrsBWRsbLnfuoEIVs1brgYIMXjy
1px+VXMJtLvgrMEeNsZ+ZaIZMWmQgTWK94vSkg/S3LrBc3qFCM2GZRVsN2lw
VvPUyp8tHigsg361/gwONCp2GajJ0GGfwKRm1AtnFHg7pzlrEgNZC1sarhbR
IVTpqv1LcEByPWtDQgcxwJ/qHliKZeBGAgxxedkikwSJfk/HWZj9fPrb/lU6
JD5rYo3YsELm7AN5VP5Z0G3z37W8SAcBtoKLFx5bIKaluJIY2Vm49k++fPyf
fDn4n3x56QUblS2RDjJwpweVG6Gh8A3HGVUMbFH9bUGWZNTR5nuSMrsBss28
mxs0jYGJqd/muyoY+2U1M1sq4jp6b26LXjP47nMTFR2uFSqUDHY//CyhidyW
HqPhWhxkBIVH9v2kQE4imw7hjjoyTjZO4WchQEHRirRgGhl2Z445LZcqIJbY
TiWDHCJk8BbzZSoSoViGvMlnKoYyMy0ed34jA31/x88mIzIIpLyrHvT1RBol
rdvc8ES4You9ImFDg91DaXVXHzuhzlNaZImDOPCcFsgaV6GDo+E9WsCiHaro
LHZU72bodrJq72oVHTRv1Qo9E7VBu+Num2xnxcDinvnu6TkGr7ixp/bchCXa
P2f4IlllFsIDen/wb52DEGbrQKl8M9RpHn5XYnkGnud6c29fpwP33h+jX/+a
oCfa2t0dO2dh1z/5sv4/+XLvP/myIXcHIjyjg8IvA7e8MH10N7VCq0ocA2sT
0BSiTIeV85+aS8Ovo62Ph28KvMPA5N5m/5eNNODFGB6QPK+FrvjbXRd5goUW
xS2zU9to8LZVYNox/RIyZMl1O5+Lg9c+Y5d3s1EhWsG5WoRTBVGLf7CjJQbv
mt99iKuIDAPUxPNvTsuinw7+4W/jiVDgHrwgrkuE/GMnmzFzwmjxYD7JGEMG
NpLYnkQ7MlQG/pQsznVBozSTorIxIvhLJshOudMgbMfHLi1PO6Rbtsh8nB0H
n3BHPktr0UH2heiOWVtrdHijWMv2LQa4K84bpTfTodHChsNqtyVSqufKbKXN
wq8nLu/2/6TDyeToKoLSbSS2ZYf7I8FZSMkobz6zYw4aG8w28yaNUQBrG/bS
6Awo7v9rKMo8By3TkhTODzdRZndk2Me5f/Nlk//ky6fHXexLC+jgky9/9Yfp
dfRJyuXOmgAGmmdDxjBX6BAYymseVKmFCNJcafL1GHj248Xmx24akE73XfAf
v4xuCf59xR+FBYn1nh4uLhpof+cRL+NXQy0H3XeJMPb+T+UHvKE8VIhVFRlq
mVdEc3sww2OzeAjHD2kTa8gwt7jJUtQtif7sKrpqHUwEvhNPm+3MGbp+RPvw
weSjyNq+CcaHybD28LX7lzoKjPGffiy3YIeMNaU3H+sR4I6C958CfxpcyB8K
8VG2RgcJLBd617BwzUTSkKBPB9KOEsILbQs0rzEgfroQA9ecvC4VdtHh5/3K
U8L6t1DYrQXZ8o+zUCeafXV4g9FvGiLvtVmMkT930Nu6bbNQTm049I57DooP
nU7zPnYTFZ/084uvmwE1Iye1D4z7v7xRicl+pIdInNf/cA7/my+/+U++zJp2
3muqgg4HY597TYxqoZm3JeWEXRiQemn8NfUGHe43VAmMJWigYRJzy58SBj4v
DB6WHKTBPa3dMQ3u6ojVYMSt1R8LWeFfc68dpIHSW/lUiRFlVNR4g70pHAeW
D/TV+wWpoOxeLsE2J4d6CEVm8cN4yD70ed6sgwz9zL6mmepnkKPFvfoMDyJs
bDWf6tH9BC666Wf10obRJWxcauj0HNweaznVKT4OA88CNQaPDyNzza/z+7vm
wKDjodXAwhgETl3+UF40hCLu7zzOzz0Pqv/4cnP/+HLz//hym+pd8xnTX+EG
v/0TOqUJ8d4d3lltPAdbdLcdXUj8DGlySiuxT+uR3m7dNmubeTj/CW8QfXQM
poVWOQ7mv0XaQkFe+y8uQKrTmBBrEYN/PTV8iI3rRh9fVaSKCdMg5wtfm5EH
HnjdZj7FB3Wh9/l3TpSRKHC7YNMtdg8BZINv1tm87ETfVSoP//GgQOk/vlP4
P74T/R/fifdBVV7OZyJEKHWtsma9Rr+ybK5GapPh2MoHPrhPgJjt5j3rNyqQ
ZOG9c7LhFOASx2KBjINVqQUX/aUStHYz6+N4FxVCz5oMie/BwofhE5uPMwuQ
/OZjlp/bGfVeHnaRWZsGiU5x3Y8PspHq9ae3VlTmYE/jkIeD3SS8daq6Pv4t
Den1XiBbms2DLZY+/bltFMae/9m793oEmow1ep3isQDjSr9Z+NmJ0LOZM6pA
qENkviVM5zwZYge4jz37SYLLQet1xva1aNEqkeeoAAnUpR9/vfOUDDkHv5ht
uNYim7sSue2uRFBTVLzF9J0M+tyS2/KCalBYyPT58l1E0LUJ8EvfJMOnHXOW
Wb5vUZOCeYkbMxG+r2Sl/R0jw9C2N1WdGtWItyl9y/dzRLDAWb73DSbDcqjX
xNDcG1SWavrZ/Dnxf76T5T++0/d/fKdHt8VE5PsoEFuy9/7G+2xEusocXnqO
ADMqBVzE32QYnLibf9D1JWJ5GiSbfooIT+d0iPo/SCBZXZwyfDoLnZ7YnqJ2
hQRZtzMP/SgiQqeriR8bPQNtdbpC3BJHBvX1OfWu7QTAyh+gjbYlo11j4zr7
v1PgBv4F/05WHHwI61HorIxBJ7yll+U9aWAokMfcoDsDCes2332nAlB8AFJg
l5gD0cV32+iBJLA0eXjYAsqQj0ZuVVsNCVxrPio/DKNACsco4UB9MeItzn4i
FMHg6x8VdO5qUMGa5i7A71mMxqPG+bMe4+FTQGfDYB0Vzsy5JA8eKUJ9730j
M/4w9s5fwtf3eCo4JO7u4v1UgESq9zZutuNg84JIjReGCvJSNQuSd/PRZa8K
HzGGPj1zN8LdpJYKIajd7vVqLmrX1OA+sw3/v/9rMPuP7zR/X5J2jJUGJsZf
WD6bJSPbyidJfVk4aPNjU1n3oELqNswPDt4kdI79kK2+IwMfiBrH9Ysp8NVo
6duO7AQ0YJWix2RLgPCc0ZyIHDJo3tAXecPzCDU+bQ1/n0yE8TziJJ5RhxAR
AbbCpw/Rhd6slTuM/jvo+5tdOpIArWIzDsLJ95DznlaPkTgKZBksntk6hAXs
vfL30+puSMhPMf1uGg3suhu3qO5h1JdmKUOoyEG7qZ3t3SKMfvUXT3ggQoXy
Mo9yleMvUIBo8rnYLsY53Zz2Ou2hwZahMhn1lWdomluodiPm/++T+SWdoRek
oX7gj+hTJJje5/gDgwVKSwGSaGbwrjuEO1v9n6BbJMMrD5Ow8Dj4Hom9hwab
bRcPTnanI82iavPdD7DgZ9kSKsbgaTIVH+tlmNKQpLnfvFMJ9n++E/d/fCfy
ZzeWwhwaSF1Y/BpqE4Es75z9u6sFCzNtzQqyDHyS3FpbKPD6AcIVFQ3u98WB
Ion/nGUAFSqSfdyd7oeh1PCEYCszPFROGn9qSqFA23q26bGiYGRi1Z1ODCaA
tS73CaoFGfbppMj0WvshFV192SdfiLDYfLQC10GERm3ySdELnuhR2bfgfXcZ
uqVGOOT9aTw4pLQueTdYogNMX0stX1DBvvB8md99Emju563uvp+OfM+/gn5E
gsA3VX+tUqmgiz9Wvqc7Gd29bBg/dY4xp89oWYHBNLis2FGpdzoJmavif+R9
w0KH5Rt19x80oGZhwqr6HqMKWHo+qIyFLXi3zrpTdKjjwg5q+8WjDaYX/JNE
DFCalyOxinQwrIjeyycfixL5Cx4/G8DA+/f1nolidLjY8zWi9ns0Espste+k
/us7Bf3HdzLeXVkq8osGfDwKyqrTgUjOrWZjUR4LTMdjtnxn1H1aUPb+Ywd/
JP5gQs2DoRProzAiTTQqCFy6G6Phdwf1TOY5LXThwCax6av5firIHvSMN+L0
RsF/dlKNpvHwrfTELaefZBAqVUrl0HVFYlYnj2jIEqE2IGupx50EzD8vDFim
26DUntZMphESRI68fEmfw0Op3Oj4zAkDdP95rRsfBxUSvHr+7O4igcLw9chP
SQlo1x5d/+IgEpzmZN1z5jMVTA6TvSMPxiDSmwuiGdM4EJj4XazUSgN634OL
TLWR6OTzHvYWRn8qNUfoe0nTwX1qQM9/+CEaOKltJ/uFwQc2+JdeudIhyWlP
+YjwA/Spcvvr2HsYYOnlFVe6//8+0h6N0sdhyFTm0k09CwxE4bfXlXrSYePX
xEtpplAknSAoLXj3X99p/j++0+MDmrpl4oy68Nx77Crkjb4pbx8UI2Cgw05x
9EInDdSmd8hsaHgiVsGbCdRHWOhS//VCVYIG8cFCLNy3XdFV4w30yxYHppHb
uvpsqbCXNzFdudABKUpplr7zx8N6429eh+sUkFPopx1ytUaPtzy2pQ4QYJHb
zCD+EwlqjLqz+sxN0HF1EvmMCwkqw/WTzCwJsBSmY350uyY6w9Je9KCcAt/C
N37hGHvhQ3aDEIUpErH99JO4o0UCbMbaVksWGhgn2f8R/xqGHB3XDqW9xMHF
+t65bgoNXk6JmdG2haJOv3cefdexcHdh3ODvbYYe4fP6rXAsGAnmBZOH0zHw
Ycaz1iudDmvilTYxzwMRp8Cz+UI5ht78oW91qoQOV9692vP6kj+qfD7e9mo/
BlJ9nVxLn9NhsN1QvpHpLrKJt+zwPon5n+/E+R/fKS8KOVQx+J7bfckJ0lZn
FLzgz9HA4HuBF/czOdFpwKq7fec+IQdkZ1b2bp8OFv6mXI+KuE2Dk5/TczLX
bdAx5i0x1GM4sCv73HXhCRVwtwZm5mMtkTTqrF2XwYO09YnAs7EUKNFNEuHL
NkFbNEcNvaMJULRri2osLxmIUzHy6o9vIL+mPS+PHyeBo/zO1NdlBPhOPrXX
bFkVdcjrHY93o4Dq6ZvPG/aTgfdsTd2p9FBEOabsVCrK+L6B3ocUERqEjqOC
R1WB6NHRgP5Qbxxoy+qGtbPSQcMpUUa/1w/t8zp1i1MICwILGsbbA+mQkLJ5
cSj0DsI0uZCa7THgv81+wKGaDke4JjDkGB8keCDaT4gFA7wxp1nbeuhwTz+F
rNTshaiSWf17emfB/NbYw2CGPhrSdLXq2OqJvl0W7yfQ/vWd9vzHdzKpkKiO
d6FDd9oniZOJNognz3OIOwQDL5X9eJgZvCw99vz775esUPfOvrIrR7CM+42a
jb1Hg0/rhlkThWbo7bZ7X3esMHDmUuWKTzMVmNq6JFScjRGvzfR+c2Y8WNUE
VNi+pUD/jHWCwpAe6tyUUvloSICzs53S1hpk6OBJmwyquIoOHG98Rl4mQsW2
aSV9DAFuuAsq8Z9WRCRxFrNsFQqwuM+4q0iSYWw7874JegAqSAn8zsFJgr1V
LWrVF2jQ30wWu9voi76+ZVlQvo4DjXb1BvZDdBj96YdlN/dGnPtihD9uYuCT
vayC/2M6TNvJRTRFe6LaFVrJWzUMYAf9C0v76FDPspGSP+eG+JO4dHzbZmF6
8pPGra90wDoxe23nckFO54wbJIJmoag8zI48wtBHH3rVZk0cUdD9zkcZWf/6
ToH/8Z2OsdSdYg1hnGerjqdEpDkaZz1QkWCOgTd5mgIejHOGGG56EAdM0XRy
/Qddxjk3kx8KOqbS4GtgReIwwRB57wnYVzrMwL2c84F6E1SYPl62+rJLD7kn
1TV8mGX0lfRJs5kRChhfZUmgDGqjsSTBv0mSBCiUCZn74cTYew80h4efqCNL
/goJtiEiCGxknhFhY/D56SXOH3RpZJpvm/73MAXaN0gZwpfJ0GS45BQ95ovU
JuXf7PlJBO5Dyi5+1xlzF3DGxiHFE4mOaOboyuIgNHSl+uIZOjyzj3WXUnND
tMrb8Sp4DCye6Pv48yUDN17zVuYrOyMmrgfPy45j4Me6mcnyZzqY90i5Gpc7
IMcPEa/VombBQUhK7PMcA8+LOPeOGNshkaALpc9UZsGZZdvd7ww97ikv1WR/
wgZJVLz+a2z5r+8k9h/f6blLVYRiAh0+nqwlY0OMEXt/xDL9IgP/5bIz9zPO
GeVzh+7rehPlyddVZTPOuR5ScZZQSAPODQnZMEU9lIkZa/ldg4XMJuF47jkq
HPRJudXZp4Ne2yc1q3fi4G61lZoxjQKn+Nj/FPdfRpa3Loqm8hBg9OxblZiH
DB64q7alj66Mon0svG5VE+EGTgz9FiZC6VsdpyAzCSTyKhVNM1MgxGC1ebsR
Q5fEjuxNPuSFdjToHzxJIIJjpcjSfQsaVG5pKXUXckFq0rJM8YI4eKLOQWdS
osPuO2zFprMOKF9XIImPwROEd0V/3M3Qy3fYlQu1TO3QgDOiynFhYPdb9R2f
iQy8bbg9uCFrg/Zdt7bMNJmFTtm8XV9+00Ep/hnPtStWaFI7KG5tzyxQ/Tw+
m36jw82Rwvyby+ZIu6CdPeLsv77Tzf/4TpY2VVmeTxn7UfXTsVABA1RjJ0c7
fRYDmN9BxS7n6bA4eoFXNeoGOoDbcfzgRwyIKPTHF9TQYKmbornZrIPUjE/s
rHqJhfBRk6Qnf6gwm910y0fxCgo1OYE3LceBtdr7B0wbFHi32NEecl8NKciZ
sxhv4OHdn1fcuZlkoErz3JJiV0CHle4KOGYRIbeH6pqrRAQP3itR6SZi6DEX
UXplkQxfTt3kWLclA9cufkuXPFfkcfvNbs1PREh8YV896MLQx9hAuk2OPYpN
eir1dCcOBpaxsec06OA4x1o4M2WDmj7ivuEbMVC7Jl1bX8e4Z7amiI56K/R2
ZGjPy/X/q+vMo6mOuv8f0iREJaIylZQyNqDa5iQRosgskjJlHspYEqKkhEKm
KCHJ7AgRKrPMd3YnQ8mQiN/nWT9Pz1rW+v571l2fde/5nLP3+73Pa5+Lg8M7
axT0fjBhqFLt9f5OK/S2KemhlgIObF0FWGzXjoGSFsderUfm6NwRU7tp5ggM
nY11ll5kwiVlnc7G+6ZIwCH4dNJG3L+60+VVdacqPZtmn0wmcOT75bG0n0dT
stqqG/Zg+jDv76WLmA78ZbXnaoDSObSWfirpchUeBh/dL3z/kQEX/k59a6jU
RuHcO45YxhDgw8fKn7ybGPD3keZedkENlKZmLRz1jAgzUj915DbTwfIMZ1VR
+inkJ3x6RIdBgv5bPf6teZi/578jLvZOAV2YfWyfHEmB/bn1FSP6FBD4mrv7
7pg4SvdXeNY7QoXoJwaFzh9o0JZ6v/GdswOyVzg1q3OBDAHfGtx2eDNgMdMk
nuugHYrcNW0bifmvaiH5qOjzTOC66pX167M1ats6dTf7NR6qkrjZH9Vi8+Pf
9NBk1ALh7wycIg/hYPesqMPv30xYU2etPN5qht7UNdUc3o6DndWhZnycYzDc
NBLpyn4JFcYd2XLxywj8Mu1u2c0+Bh/WlylddDdGYnJnms/R/1d3Kl5Vd1L/
rGw78IYJ+RP1349F6iJV/bkHqdg+Kircqeypz4SOr0pbd9Vqo3uf/Rd98/Eg
F6W4rbaVAc8tcg53jmqgaV03AfbbBGifnjXX3s4AJMr7NWBGBQkt1O9vx/xX
ebjTVDs/HczSpc+Itiqi4WVxG5sBEhy6mfFnQzkVtlVzDoQ7yKJk3UBOph8F
zjfVnAhLyoburnLlFEYP4pgTrpLdMAGql/ga0zNr4MvVCPy+Q92oNeb0Eynh
CWgoKHUxL2+BAPe+wDzFTtQSGVyp+2McbledpTS++Ao2LE371l38hmy0xcr8
ZCcg+/s9rcamXtBunY++at2KjAbC6GeExmFL+p8Ol5QBGD/3baT/dyOyl5hM
bYgYg78O9zdlrRmBiVbHTlFCHTraluoXMMIE+xW+1HyFL/21wpc2h063je1o
AVGN+nMxtz9g75e1Oll+Eq6s9ClErfQpzK/0KTxdGb+zMj67Mp4pdDoj4cAn
4BUekabV5CAVR6qk9t1JSNFuC+2V7oAjP3f23b6fhUydqL9jWidA7i3f3EXp
MugOP3mmQ/IFeqKOu9DyfRIuha2bKGrpgNFl0lSe8DOUFPni2J2KCeDSzBoR
vpsBE1WOpqN80cjth9g5zflJWPyd89jLtAOUnhYa59ffQR9jgwmfvkzA7Imt
Wq9+ppyqdnLm6bLvRUObLdbPzo9DN2FfjCJnC/gEXSKwiXWjmdkhgx2vx+GW
V+wzq7Q20BqUk2vs60QPXqjtjL0/Dk5sHUPZER2gcCGk2+lmBwr0CZF8EjYO
BsWWYiI6XbCzUMLvPPkLsoq5lbYxaxx2NlnPxid2wUsHP+H25mY08J3v/Oin
cdBJ+hNgldQFMzO1a1xeN6Jll9ilnRPYe1/pdwhc6XcoXul32D4weT/ySyd8
jryV7HKvFpmnvbjbpjcBeaZs8mVrO6Fv2GQh+1AlameGJluFT0Dqgtdw25oO
4OmurFyIKkHyrbY6NysnIGTlfUWu6jeZn2jW3XL/C5z6UmLO9jEb4U2YPv6S
k6DUoPpGancz8P4Wf+m2lIxu2mnLJllMggbBoE1Z7RM4dXCo1d2MRLzRM+0J
MZPw2CFqRtGsHxQ2OJ1wfNqGHN7qu7GdG4O4J/j2ifVYPmE4+GuOtyDLEMUB
9WEGmM1fFXhsR4S26PKWXy8aUZ/Fe59dj+hQe40q155MgtgNIVO+WnVI7d3u
k2dwNCC9z2jww/LFFgVuLXsehIpSFscZL6hw/yQu7xaW53k8s7304j4iF+P9
1WzRdJjtfBLCsW4U1jiZn5z1KEdLNt2d/MujUBzkfW48nwi++jsqrzytQ8M1
HEqH4+hAiXLPvvaIAmwJxlwfd9Qgy8iwz9nGVKhKjpSozKeBV4F8eqPcNRTv
V1zVY0mGQRdVPosOCiRb3vV4f1oETSgEdpY4UsGLRYT5cpACrx+9ri0Q2o2W
6u9G7raiglvjWYrqMAUKpOxnyxp2ocZHty8kWVAh927voQvKOJBoyJpyk2lB
/aH0bSISTLgmojlJ4iXC+5J+U2PTJiTgk2/E8hHT67z1rDYOJFj76fC1WGYD
cjTckt9LpYHrhH6vcyIZ8Kp/q2JKapH2xNzPMRHM7/AZPZX/RIaMm3+KD6dU
o9eu0VzXuWnwdOn+x+61ZLA8T3d911CNaKRblc8LsHyw6eeWkJGMU/EjsM/l
axfaKaBavuw8AQVGhvqVRe/g4/r0yxtudKHNAZVHyhwmwKjn6I5n194DB7fd
tpMn2tGvG7pnt/RPQP4Kt++xwu3fWeH221bG3VbGw1fG/3vf1JVV901tZR/U
kh58D7VR/DMFj5tRIfdU489Tk7DhTkDs653fgGSemSX4tQkFfQwwFo+YAJZP
trj/PMdu1XNcVvZX0Mr+KlnZX7d8PsSNx2edKkjy8FZiqUd3KFGh8lmTMNun
Xxu17T0sawLHnid1qPqmvFpe7CSo34naqdjyBfgTi8niVh/RPf26+TP4CUjY
/tuu8Xnmqc4/5IwacYQOqc+5StRPwt6VeGu3Em9nV+JtVtwj2wirjFM/+9jX
nXlShtTCSo6LDEyC547YuFeNRXBqmKC+hq8MvY0wqPnSNAmGwcN/zV7i4YnR
+1/f1jUg9/WCpCEcA86unFMMrpxTUFfOKaok2qTnn47C/hr8OfeH75F3rdqu
1rBRsB5IvBJSQ4ba+Yw8vcVyNBUkG0DdS4OhElvBry5kSOXNuyKRUokuNCcF
mNliujn12rJLKh4OZV4w+pXwEQnfaj/4Y5EBqU0DXZJtBMiXGtaIdKpFcXuK
t4RpYL7up6Q1ZZgERpfEl2NFq9D3bR/LU3ppkBhmsxRCpEJ18wu2SstCVGwX
L3VPjgIX9ycvxm0ahfGRN5/JjwpRvcj7mX2CVAi5JlJpFEGBYq2tMV9j3qOZ
b9YmWyOpcP60TPi6n9g+Ct3yqbS7CCn/ORn0VpoKZ8NuzfCJvIGrV0zXfNLt
QteeC8298pqAmePNLVknyuF4wHllToEv6Gv5xRFt7kmQqNuwo8efAlf092pW
sr1HAk+IUiZPqFC87LDQhvksrsUgRaOMQlRLumJzfT0NAuvYa2wukkHzMW1h
U1se2uK7Pd88iwa71h/VYrMhwZThEWpfWiZyP17Un+ZCh67JT9o3dhCBtW/T
TEnEc9TInmu+bM2A8oU1yfaOeNDX79awevQIMeafZST5MEEkwHfMx38IjtV7
7qg+HoJwNMOdczljkGfsjXAXOmDp8c16mSDVGpUvV3eNfp2A19JPrifcrwU3
7/Lnkil16K0v67twu0noaqw6JfRzFPJ4tjRmTpcidQWyu77gKLTLcrCOLVEh
4eDOJuHP75GW26h8AysFdPK2Nl+LoME7m0310YLv0J5uX+G5G2QoI7eUra2l
wbEtHKVxAQWoTOvM+EEZMrRfm3/MVkODjVsp1vIHXiOfI3eTyMfJEBzEslUi
kgbtT6TF4sVz0H7W5Ynv/6n3XpXlD8bi0NjAO6rPxQwkoMc1bbFAhpSUudNH
QqjA6mbNK+uciixYnK21iiiQ4trZ4p8yCprUfvVMr0SU87Prnkf6KIi6kW67
W1NAVMivrqv+IWIsqPFd+kYFBc8fbOeLSBDZ2qDeU3MXKdUUXvI4TgevUq+Y
HEcCbPu5huwf4YUiN1q5hfczoCNBNZq53APSMSe+/244WuONl+34unniX//C
h1X9C+l/i0ZuMuug6+O4hOjVMhQ5+YxNN3gSm3cu8kwUDZ4dZG03U36D/krF
pu/wJINzwmjCfCCWf8S+xQ+efoUUOuK/4c+QQNXmBzvPNB2UZnLGBriyEHW3
6vIlzDftf9ZyUlycAb80Wm9YabxEG6DaseU6EbToQR49wgz4JJVyczksFdGO
09633iQCKOVO037QIUjo474fxCS0kDqk9LGUCGe937d9iafD47A9vq6RT9C7
DlibeowE3xJ+dHCx0YH8/frdziuPUJWMR1HWLxIE8VtFjMrSYH7r7RexHdFI
R8U7eu8PMmj4kGpNOKhA26U/3Cd0B219ovNAQ34UpFPdJhdcsPeTWBxtaxyA
uIUqcl7XUYGLc7yW5RD2PMXN+alKTkgqJpBP5gUdHhT76TIIfdg+dpgQfixV
06gr/jQ0YBwejNK/ubpQAWbD321IzER7a7Pv+X2kgCyDq0TgfgMkl+57JqVS
gHTa9L9YYrrxyYs0Q09rOsiZEPqShNKR7LGUw7+9SYC3vhuvBwz4YMl3P+rc
czQ7++ysmjYRSmOPqu97wwA31dt/KGbPUMDoSRSWS4B10/O7Y74zYOvRqvS5
3wkoaf9gmDO2PsZ/fjCd6GLAydeOO3mmH6GLjCIBsgsBrArN5TxzGNC3LTcn
5XAc0pL5vVGnmADlJrdatQ0Y4L/WVf/3wSjka4Z/PS9HBHWm077BFjrQQ8/L
OyjfRQKOxq1sP4hA2aKaJL2eDkb+vTdN/ENQXF/BOaEfJLAeMeh49oMKm+2v
hyVX+qGaCfWoPGUKPHxYv6/kyihsuPLcpr7eDfEHEjg6B0fhyI+HP/MPk+G0
uoJsxHFrtPZ6d798Dw2mEzY6dWQNwKuKT2+02EVrHMyHZvbwj8OI5iHdk3+o
cKdXMkndLglNPYk+yJCiwK3QkwcDH3+CGgL91aHkTGSptvvtmvBJSDXnqXva
R4ciubPdO9sTkM33uxcZA0Qwn3/mdBqbzw2iA5vC0x+hzAyOm9deEyDuaFbB
xq1McH5n5N4uEIckW8bXz28mwJ1gsbBmZcwnNihXiJOjkOauKTLPFzywSgvX
7zvOhB8X5i22ct9DWsvZchc68fBpXfeBSU7Ml2Rk/hiPDkf91sPVMnwE8E5R
rT5UxYBbbj0xTI0QdFe08q1qAgEumT+IMjzBgLDCTWIluoFovfzGbG5DIgQU
vra9EkKHOAVv/Jaz3ui4iXKSkBEJfhk2LYd40cCtG45t9XJD6kuKnAdfkkGv
6JD85ZlR+GnLI+Fw1x5t3tQsnKCDzXtS+3GbZjJ44lyW7ScuoLALzi1nL9Dg
ATvl4Z66QVi/rEmbvL+j5ubdlymWPWMgujG8w98A01MWzjaxhIcIOvJU6lvI
oP9Nk/2NViNsU3k5HO2ZgtiYqWJNmA4xcrCtrxBlwAmqcjmLbwyK3SF30dKL
CL3pidRjkwzgTIy3YxGNRNFuO9x4tQhgEeNCEzFkAj5cYWr/+ztIKzThnMIr
PGjYcqxX8WPCY+Ip8ZmWUJQ2VBmXeBUPZp3du157MeHyxMSuP0eCkYx5/Ns6
TB+cWMN/alaXCbUC+aVZxQGo7E3BSbkiPKg9ltYQWmJAPCKV5+v4oBP45eI8
aQI8XHiilxDKgNdFUbxEAQ8EeOWHS0wCiJ+sDvL+Sgeh03Kd5SIuiNXwlYH0
OBHwN6c+dHymQY5kXOolbQcUZ49XHzxJhjm94kDceSpQ2LedSztqgWJO70Bt
DAqAcwGXF7YezfC/RWOCdNG26Q8pGlh+GlnMW//l1hAEUomcGvu31CyUJol7
Y3kQNxCcb/yeBnuywoT8fMKQszEh4ZwJGT68S2VT2tUE1cfS5yErFo3ZRwgZ
+06CzOWw37NeDJh8tbVo6XcQeji0odxgiQASUaPrdygxwbHL5ul7xQD0y9eM
Y6wND6eKXqxLSmRCfRapfuttHxT/JoXOKY+HUQ0JDVI1Ey72cm/qMPZE0jxk
UwIFB6XXmJevVzDhddRVvrf33dHj7Lv5G6dwELNu+/HQeCbI0armVBad0d4J
OUm8Mh50lKMfbdVmwj2966/ElK6hmKw8vFc55ovu61XkdDAg1rZyWrbkCqr7
wpPM8CTAL7PaeDcxBmSmlOjPmFmjaydm2b5h60SOwdV9R4IO8TWxQvonLqGS
m5qOZU0kIDQFFXwop4IBz6Uay0F99MCD8VnSjwIeH+TviqdSIOxtv8NfaUAH
FqbOCD+lQs30TBTJfBhutF47+KKPpYafPy/oh8sY9PR6OhzposEhgXZmYuBt
NFAwfewLlvfTk1PqReyaYGfH8x0Gv+6hha3uU/5ek3DXQZPnSywDcqhbTrqx
+iG7bKk5zT4CzDRQuTQMmPBJQm/+wBkvdD1bc+hsHh54Y7aqXHnLhLts2W8p
5jfR59Rko3ZOPBS1J4cJdjFho41GiFezK9o82JD2KRkH6vu96W/bmCCh0UHK
un4dUSSojwk5OOg9SjppmssEqrZHpozbVbTPXoUnkQ8PAr6HpFitmGCoa3l3
ucwO3WywnByIx95v5mTccQYDmz+e7hJZa3T8EDo6p0eArcv8C4qnGOBod0/a
46kpyu6ZMnqlT4SMw74e4pp0aFQ+cZj22xBp8Fk86k4ngeauxd35A1QwPeBd
Fzyjjbh204zuXqBAGS6V26ueAsQs/wua3seRRWHjQoYXFaw9iV39mcPApVw3
cmzbYnWimbo3mI8Bz5tyfBiTBttwUowSP1+0uf6kC4WXDDd2u786mNwEFZLx
tAfi4ejU4WXdbR6TQBPVyt2WyQDvWXWVbG5P1NlcUL6hggBf3x9ycrdjgu58
deJZHnc05SmNd4nGQ05XtaIfYoKr2oDyYXdnZLH39kAMHgd+HLgH1SQmCL7n
COUPuIYGXpsKsNngwDPsg6MZnglPGqYtti3Yo/qKkDvbnXEgGfiB4Yetc7dc
caeTLbaIy7mRjwtb5wlb79avccfGmRHXnqVZoUJNlSdrvfEwI/TXM+wvA/KO
277OnDdFhlxuhG4ZAjwVKkw9Y8SA4wlIaDHiApKWzbtvLEuE0+4HWnzMMT0j
I1Vc46mH8m2fSuWFkWCYvmmqcJoKR2ovhlA4NNAD4eRhnWMUMA9fXKOAp8DT
KjG+03ny6OSWwmN9ZlTYeCxSQWNkGNrI9opv02ar0wKV1kqdGwODue1xQss0
SB+kNGTzeKL+wy8Ho/+Q4Jmaz4N1zU2gfVv/Y/LTYLS7ov/FZvdJyFV8+sv+
PQPG1POqRNzc0J+lSRm/dAIUnbnsxHmTCcPrvQ12zV5HJRrZ7gqeeMjbdNZN
7isTdmUo/dy4yxHl6Pi55xTiYHKz1uadP5kwkbHkKjlyBd01ZHttLYuDTsfD
nTXjTMitMThnu8YWndky5XX9JA5uiTq5nvzMBIOG3+EXmywRnz/PGqE6bJ79
Rc/5BjFB1WE7kYdmim4F7plst8CDtK506wYsb/6xVr5IOG2MjKvU6q34CRDB
qXsKrjDg29TRJa2u82ghMsW3mB/L42WtDlqudAgVCrKgzmljBjWMReQ6CXKR
/ZH3G2lwzcqnNcBdBeVoKV3020MBS+nfjv5zFMjLaKP7icsgliVe0xkNKrDP
U/O5OEeAUFSlGpoyVb2RVVO5SWUM0j2485W56dB07LXeX+SGihz4S81Hsee/
qa44NtkEY4SbBo5fA1Ddq+OVBq6T8DRN1uzLRwZwLbhY29y4jpbH6F/2xhDg
cL2O0abbTLgyNlVhZnAVub0MEJSyxgMbrRY8+7Dxj1YtxwSvIO4JyZ08kThg
VxwP5l5kwnbFMlUZBxs0O1HstHYTDghLs3MVv5mw3zgBtay1RNEep5kb+HBw
QLX+2D0szsje/7KRLc8U/bA0vhiYhIOg9ijSxSjsfaU3pcYmGaNKstaGtjN4
MDl9IL5JANsvW3pa6pEBMvKwENm7lgCtc+/2S99kwPqQXe6RvLrIrlC7W38t
EXYnnZVDt+kg7kwhbOjVQAVEt4QvJiTImbFaYBOkgeUa3nrkqYzMrn6tL+Gg
gCpiSBZh/vdAGu/Za78PoP61Xybq5KiQffWjH1l+BLa+iih4vney+rx3+qbr
R8fgdlCtVrkQHVoVPa6esrmBDnvxNl/uIUFx1t3qUO7P4M0dscCT7oMePe+j
dTtPwlyMQdrSFwbYVOaKxB6/iurd20y4AglAEo7Abb7HhFiirEBwtR3yUc+Z
MdHHQ82rH/39BCbcKlKs3shugw6DY0X7VRxYuZzde4Qd0ztDn/76e1ogH8oh
sVnaCPCJovOjLGNwWGZz7ldHUxR3UfrSzDS2PnjVU2eGML134Nodt3JjZN7R
f07BDwcpg35n1BKY0Dyv2vvrjCFamqF+XT6Oh5BTnY+dxZlQV/7i1D4uPfRj
dIej+C88GEi//tNziwGLay10Wj6dRvLFe6clf2E6/EGIdVEUHdJNer6ezFZF
zk5BZQWaJFDInW8Il6TBL+K6kr/qx1D82/o3nJjf/PbxT2/7zlHoMCyuzRne
hzjTTCwcxKjg//6cbPqFEbBsZvFMdWdURzSa/Eo/NAYCG20UD+2ng4jsVImR
qSM6/b5Gsa8Re/52q/7AXgZkGT2I3c+wQ2U8am8CnQlwgvWpxb04JthOptCl
xq3Rgz3b+deo4uGkik5XG50JWalLI7rSFmhT92XPoLM4aHvq2TC9eQxU+ac4
+lVMkbDNSdf2LyPw9vLn73kbx+BhsxrL+GdjVMUauKe1bwQGrEsdpshMeFR3
UV8vzRDFzpo+GTLHQdbYREjucyaQQo+4bLHQRzYX28+/PYAHi4qiHM9D2Dwb
7enlaTyDBMNT3XPIeBhxbd5dFsEAKzURhTd2Gqjd9rJ9FJkAE9cr37x9Qgdr
u7pOGe1TqDaiXIgP84/jPyXyvx+hAVVv9q7InDyy9zvxu2uMDFTjjdqR+0ch
+3D4zrvpYkj1let6dT4qPLw/XlTpNgKGUe4Lhu9Hq1nyfjlx7hsDx+FmAZMH
/TAabN3QyN6O0oI4HggqjsGdlyyKQdRBaGNM2dv++ILsRGS56DgmtD5u4Nmi
Pgw694rUfnxvRsIx/SctSpkg1JbQpcochpSZP0E+zY3ogOm6PdYlTKCFmXKI
bxiBD7819rk11iMJG7nusE4mcGj8f15Xc4XX3b7C637slopVfT4IhxQffuKz
+4DqzeTWXqscgyqJbSJ3xvph6XlU2hrhInR7cO3F5kPjIKu+qHGt4Tu8ffmk
murwCrWUSLHufTMOeycLhW129kBZcBHn5p4XKKzf2p0hOwFXT6vM2dE6YEOl
+9UbMzHIz9l0Yah0Ag7E21PHFRqBzawo3zPqMhJgXxytC5uEqWPCKmL9ZJg5
VZ8qvPARmad2eBoPUiGxxvnIjWcUyC3Uq65MQGjqxHMW9dNUcHP3eh84TYFD
/LRd555XIoMTYtNUdio4hWvVx6wbhfyb1JHT46XIydx0qyQ2vneF+w1dxf3m
5W9yepRAgoy8P4tC63JQwkZ5CSkNOmzLiXzafpkI989ZlrxhTUf3W1H6MRkG
kBynn25BePieKznJX/AEtb8V/22oxoTs6UMvTxsMw/m/0DkcdA8db0+V03If
A74mEUEe6y74Y7kGMi87og3sb1/eD5oAm5f4typGNLBdv9nbP6wYKX222zCY
RYahLvyv3lwaJPFuSd+xXIji7dLOyp4mw6103qeGNTRo2bTDwcwnH32/0PZa
5wj5H097YBVPm0toSlb4TgE2HsGm84YJ6JZmjX+3NRWeVDZf/HWeDHIbunIt
b8UgCd4Qxq4yGsT0g9f3E0Q4r7D1beraEDTnND21oMMAhd+HowbuDwB/1W9V
DnkHdJtpZ6SyexxsuJ+wPuRggN6zPSFeWzLRLv0B5vNoIkhY/vS3w/yd1td7
2WrW6UiyXzBKzJX4jztVW8WdOjflbwCVUfj7tjW33zMU6Qfv9v21NApnIglc
B7DvyVNBnvmk6I3mnqTWvy/HdMwnejjhFZbfbPA+Zz5bI9lzUxEumD5+Fx8x
ewiLS+kieQ1lhxNQuLW8W7MT4R9vyb2Kt7wZtP0ufwIFllmNHiQt3EAfUreo
q6RRYTtcrL9RTACH8ZezXYsXkWraudbHrxj/uMcLq7jHkhWecGHm//OECSs8
4YHdKVUmkiRg8zzypNnIALVS2sP/pNHhzQr/NrTCv8mt8G9zK/xb/Qr/xrrC
v2XG6/xKVGFARNHvEse4YHRs/WX/b2eJcK2TvVdClAl61+eH2VkD0fGIWyk3
ZvHwONCXlxLNhL9NFVcuC/oixywfTaYWHqoeRvw6Xs4EEXZN3u4BTxTXnaHH
M4uDnAK73YOYvq1PiVxyXHMTzVadCgv5gfvHs9mu4tnm4u759OAZcMj3UO+S
hz1aE/z2XYgFATpVZUJxigwIMskO6ua1QUU5xkF4YyLUb1HXFNCmw3NLfuXw
l6bIYOLxGNsLEnjKPw+VplNh7nlP+lddA2QzutNZRYMCzYfMBw5TKEB6VF18
W0sNWZuItkiZUCEjrT2YdBQHJ0J+r9NI2IZa1nyiPZ1kwkK7Ys2UCBN0Xtu9
wd/wRuJK5yuI2DxkFs6MGD1lQnisLJuvqgealXySr38ED9F3uconm5lQ2fVo
ui7LDQW9N8mdrsTysrWFRFQ7E97GaX1d+/EGMrTa97Y3E/ePK4tfxZXtqBAh
6jgx4PNr0h/y68to4TSZMchNhOVJ9aJjd+hwKkuW0rh8AS1wDeeBHgnuDr61
UTtOAwV1t6/Nk7qoU2x/8ToGGe5p6T5l0xuFvRv4SrKFVVBptlkI99QoPHp4
e6kV84t9p1XWzfPsRgEmCpt2YO/jv5xY+ypObEGQj6mG5UGN/VfWT/q5op+b
bL6qHMTD2YpvJZK9mE/hXJfhIXcd7bmwfzfvQxwkHz9alobpnMSgdrWzQVdR
9IgV+b4jDhZXOK6uVRwXw+/MsFIlHTTevtk7FWGAhgm9T9evI0GsR9uhs0E0
qNCYITY91EZm/pLyWU/IcC5HjYuRPwo7mxRzTtw/gZSy17/UiR+FfVMB7J4F
BJi15JXplhZBJOLRvUqvGf/4K+5V/FV3c1LDYSwfetXMe0nmOaCFq2wOSu44
CPzw56Yz9v7XXBd98QLbd9zm33/YHsNB4goHtWWFgypc4aB6mAv3rtbS4FGi
lnyZlCaK4xvfIaNNBgGuzh0C66lwf8H28RdXRcR3Y5Chc3wUPvRM3dmRRwQd
RuHYnU2iyFu95ZriEv0fp9S6ilPqp0m9aP+DxSHhrfc6kq2RFaJUh3HhwGaF
C6pb4YKUVrggNqg8xnmZClaURA72waNo9kWG5QKOAvJSW53XJpMAp55TveOI
KOI4p41cdej/+ByFVXxO3wr3IrDCvRivcC9aJeMNZ0LJoLRYkpC2JIIMMn9c
N42jwZcvOULhGqVQqdy8bv/eLlT0YtbZ2H4CLPoWzq6DXrh6NO6nhkwHmr6g
uf0SGgNnnX1/g7cMgDMpepeTXBuS4sI3Rh4YgySCHVn36BDkOqztUOH6gnb4
07rvDjBheoW7+LnCXSiucBdqs0vzRbHDcOHejciDZIQuSFYGVAuMQbgqn7Ti
2yF4Z8IdEX2kAikpTdbKXB8DNopOD6/FIJg9qJuaqXuPeJf/fHjeNgYTK5zD
wRXOoX6Fc3CL2xOxb7gHuNkF1bbbdaANj4fGfVrG4Gh9t3BTXz+YyMefWX7R
hgZjtgV/kx6DDqNqQeXtQ+AWNv7yx+0vyOF9p0blIBPEF90GL10eBnfTm69r
7ZtRN5yMvI/pLk4a/M6fGYaXlbpa20waUYbEzgCXMiawXPVqnFw3AvrnPzaY
G9WjHt0jZ8jfmTAqkyqyLm0YjGhFbZ9tahGz93vBdR5Md4mpnxP7PAScHzyn
RjZXIj7xMbUAmzEYzx7VdAgeBNUvPHTu2BKkdmeH42DDGCjdUqz7/KkfHj26
sd3ItBD5nSr2ETs+DtZnLLWuPfoOLaFXdLUWs9FF66g9J0vH4ZRfSWTVSDfs
r6zlBv0U5LzLJ4V0AtNjU4Ks6zI6wCVMwHM6OxJls+4WF62bgBYNYQVWrwYw
pgW/O7PmTM3u4P1ni59Mwg8tRfA4SgS/8FH2gU+f0DWloQscNXTIOtY/8Z+6
pgnpdcQQez2y/fM6f9qQBt82+3+X0aZAg+6uDQXFtWjJikmLj6DCzAqHwLbC
ISyvcAhuA7uCfhwcge/rUreE769FP14O7ts3gfnY6l2Wp+kUuFc9fvOoWTl6
dV3feHonFazT8N8jHHvg9O5bDa6hHoj1rJ/oksQE7Jat3qZ38DPoBFkvXtfz
RORG5vS9G5MwsMInxKzwCT9X+ATujKlrJvl4kHKbcWeqT9XktPFx3NdngpUy
M6ntLgFi0mvPuyY3otrvXAoxBxlgMZEV64n5+PEprlH/snpEFpxQG3lIg2Ov
1y2tE6AAZ/udpRDDjyie9330J2wfSskxTEYqKHDriKsVr0MNaqjdr+1wmArM
3wVuHixY/PvzVUA0vAJtZlGJKMR0TksABz+eQoZn3hR1ceFKRH+fvL5ziQoa
KszkreadIL7OyOCybCcyPDKwX0lrHLgHbpfdsB0BD2lOD32Xz8hx29D8hdtM
cKByZPFzjUD/er6+wc4GdLkAjHIamPAi/9b48G8KjOfflpEilSDzoXaGATaf
gkYdCrpso7DVrz20h/wBiX7YPOW7mQo2K/equazcq1axcq/a1ZVxp5XxkpXx
rBNGoSciiTBKjRU/sKEG+VqiiUPt9H/3s11fdT+bpfUOHS51EsR3HpefkqhG
I1OxKV+x+Obz9xkbgTAMQ+Vnfov2fURrCS3T6T+ZoLhy31rMyn1rdSv3rf33
HraoVfewEVhUR2knR2FS1+mpM7kMCZvk6sW2jv77fMz/cW9byapzz8X/o48y
2UV2Kvf1MNh/Npvf2lWL7trVPpHYNAbuas0FH1zxwN+ZmfgipQntiYoKdGln
gEMPUtMZpIA4Xdk/zOM9umggVRulTIV747ShXyIUyKx1NY37WYQyBOKvvB6j
ws7G9sJ+71Fw3Kd1cM+dMjRjwW24PeF/fX8Zq/r+mkvzyyWf0yD/8KvEBzq5
aMM+aa2TdmS46aVnJH+GBocLD3D8tMxC645ysNq0kkH+RBe3Xw0V9CTOaiZk
p6Nc18iODOw5bB92NtxbS4c95zZq+LbloTu86/fgCP/rd5Nd1e82eJv1rv5G
BuTxPN3UjnuOXlk0aDx/TATmrvg19vWYzq3sZjl/6Rm6tI2No2aWCDvn+aMF
z9Gh2OSvUB5PArKzr8+qekwC/RNGDu0pWHCt6zt1eCEOqShY2cS6k2EusXPv
9c/9sFFScHFdVT7yqsjbVq40Dppq8dwXD9OgqpBfwL8gA2lrpXqcwvy4wPzZ
jbHv6RCUl6d73CcNCVg+EptYj/m6BceT5KsMqDut12eokYJ+eW2HIU4ikFzo
WY/qGXCWZmaUpPQIDV0msuy/R4CmK8qqpAgGvOy23PyHJRZZuA9JvSASwOz4
4p79wgzYKwdZLYRIZMNWbXbJjwipIjv03MLoIEO7z5b1NxzVXk1poOiTYD7f
kRiWToPqQ61LTM1gFHyU47iqMxmCGH9eC+v0QN/irlt7t2ai2zIChi37JmBn
8tSGA940YGuuevU28Rm6KXEi4M5zMrhFJ9xW5GJg8SST3001AdnoE2wK44jQ
WM+9ZeETA9g/ffnRJ/0IsaeInbwVToC43MtLopg+VNL7uW/JPRalt8UuLCzi
gXP887vmQ1i+usz7vcA9AoUnNQUJkvCg944pOjPPgNw11m7f58OQ9sb7Wu+P
EGCPm5oW53MG+Ii/E5UtD0YcI4Id6g0E+BjPiqa4/tM3dP5GOwSgzlo859VH
RPh54+L5UBU6LCE3OZymF9J48FfkRQ4JJDhPaT7kp0GTDT+L/JgLOmpl0HuD
iwJvVAUsHezbgRt/qtj/UAqaYVVJsmdOwLH4eHe1BzRYTrwVdDr5IZr1Fawb
xXTMJfaG+i8nGBBYS0q6vz0GnQ7CPdE6TwQCO6Ume4EB+b4Whwe67qFQywDZ
HDkCXAiw5l9zkQklncaen9zvICnV5i3KaXjQ+Ggs9c2XCU/acwz54kKR0VlH
x8uO/+urWljVV5VVuTbfSJ0Ji5Wya07pByAVkaCWsVo8FIo2DPFNMiA0yrLi
MtMbFZ/enHXoNAGIu0djcm4wQDUG+KVrbqLWPxK3NDcTYWPeMZb1b+mQmC8p
EerqjLat+/r84w4SjBqoHnuRTINJ1rE/4kn2aDKJL7/UE/Pn2bPiXNxUaOYZ
lW4lXkZm3i+L1sqMAv+Ifrp7IhPuj+l3Kna5IGs7jnt+8njg3e/LbiBEgaVn
ra3nF0ORJvHwY9bNNEAsX6s2FjPhGfnjcEaOIzqwoekzgR0Pwh3bW0nuTBgO
2GFZMXgFbeSLuhruif3e8aCqLUtEOEXPeKZ3LxgpcstTP9fSYeSItyYPOwN2
Nz1/GfHXC1Vp3z9yKY0IeAcD+y+fse9z+ZzaKakriP60clqoFgfB/WOHRzEf
aq1lEPxypw2aX2JtkziNBy1+l5YISSbsvX0tU8XZHHXs13/7k4EHcSshUvhL
PISkmj3wWg5Ewdl1jWRjJpQrZkVa4umwRvDCg0rvm+h58nKaahcREo//ai7e
xoSrEePr2ApdkMHJiyf3bCYARf37Z0FMxy1cu9c33WONWn+e6fkQhAOeKcvn
8plM6E3vNhhPMkf1jaaLvnvwYLUG7/9HiwmNa2fUN/ddRO/M/Tj0K/Hwi+Wu
wHw5A+QXqoOenDVCQofl3gk/I8DhhTkNTekhSA+eDkiI9kNiKl9s31SMwfXQ
1iM2ZXS44fLh3tpwV6QdaDjYvBGLP+OOuS0bmRA0fvblEI8Tan+W9sF1FwEc
M8epWmlMsJe5LZaq6oCOFCU83Y/5ne08XuMEBhManua+E39sjvx0oz/ln8bB
3eFd7Z8wvblR9Neoi+El5BAjZ7z2Nw5cZL0WnWyYUHaXMzjhwgXkZDASSIvF
Q8VkWanEEAMK39Ps2e6eR5fEWSo+XyGAc9mxxg0CDHjBiNqbUHAGnfDJ2RUR
TgQHcSc1tpFe6H4X6Up56I1K7ld9FCSNA5xSeFUaQ4d095gXXprX0fsLWzLG
1UjA2VDWQFpkAFczo/6jtwNSYPVp+SRLAIEohalPL5hw23qx8f5eOxRu69lf
sx8Pw17fNMqx3wUH1kqQwq2RiFrYXSVtHEyIPe2r/o3pvkfLXzqTLiHLq68N
2Phw8Mli0E+rlQlVfKMOYfMXkJmpeUpoKQ7O+YW7PfRjgt3JZwWUeAOkzRO2
o+IqHn7feHqvBosDtVMXLGsLdFGwY/r2VHkCFODUlpbUGHAnlM/ilZsWWh+q
t6dbmwhJcw9+ch+lw3Mbt6M3L6oggTsiGjIlJHBZan3daU2Hlo8NabX4q+j3
8K5vU7dI8MKre7PjBAOO+m7tevfUDpEHJ5tdtQnAqUEdHEjG4szb0sjwN9Zo
X6LenepDeMAVbBxRxPRsf6iiukadOfJUtiNXKOPA9p12R9TmMVh2ssZn4C+h
Xcn5a/W/jcAvVx8TqSEm+Or3c5fqGaJt3mz8ywE4GJ29XD0RywRNf+MCvTo9
ZPT75yMONTzsMT3rdlaACTzff7EelD2DXj8KnGGuJcCRwOSXj5wYEF+qico7
1VGekW6iDzcRjsWOKmndwHxkbfvIm4MnkYh0rTy3Kwm0Ut+HbZ2jwo/667wh
ODlUdiQg6ZkCFkfeBx4bvzYMxk5++eumPyOeW0HjIhVMeLu/Suja3DBsk4ln
+UL6hFrO+OJfVTPhVO5v283P+mG0T8Lt9rEC1Oib++Gx+jgQEu3kpcy+w6v+
v69Es7KQxzGSuEn9OCyczqy+8Lwb8B4pM3JzzxDbNpZrqdoTMHHIYutlTLd7
chUd3aZejQQ3DvcK7qH+4zPTVvGZzqu4tVcr+u3r8rNAV9Z+0NcnkcOOt6Mq
f8eTEgZjUEPqHUrVGYR4SWeRZ+++oqQlsdKxeSbEGe5YPl49BCUJPH1lv1rQ
0RJ1f69mJlwWf9Jx5fEwUDUfuwmf+Iz+mvzy2FCOxdN5jVmOpWHADxNuh0R+
Qr4ijZHatUzYvFJvP7Oq3p6zWGr1sGUQSNt6dm1dV4riQx73er8dgzidNZs0
rw7Apz1O+3xM3qHFmJQoNe5xKLBwYKQU9EHJVu6fQW2vkeUUjjnrOw70bV/C
6pN6IU1XJifkUQb62ZOW+oI+DtflSoXvHOgGiQOcx2PFEhE37obEOfMJEI4R
73r+jgy8O7auFTlVh+S807hT5zE/olVf8cuNArNaCQb2UIvwN5je8VepsOtG
c9XeAQq05X6P7+2vQoJUxycj/P+rn4et1M9lVurnjkvvLP9g+6bxrN31+Jwc
9O2s4nuTA3RQFt/YrlhMhLbJ8vuDx16iDKPTB9R/0mHfhg3J3DcIcO7zQEyJ
UBIK5nQ6pNHNAHua2tXxV1icm76c1uoTh3Qz6KLHvzFhS4PDAU+WQcg98NAi
q/42ulFo41TKOg6H2zcSg9VosKvAMzO5oRj1TH11iC0jAyPMtnwTpiercP0u
J9yLUO9V/TPXTcjw8Ez0TVWE+bb1oW9G8t+i/YN++ItyZKDJGWs7lNKA/QRP
wdeWPGQv71jrq0qG5JW6utRKXf3gSl39g0UeSWyZAtRDc1ryvxKQx1e3/j2Y
nncLjpGpqCFD9NLAUgctFm23tEjcbk4DBY1PRw/tJgG+xrLb3Cscve+V3Pvt
FR2KTCdd01PwcGnEM6jY1wPlvnNnTzbF4tqDkzXvsTxrwLqsLHA+E8VsCI+L
w3Q1Wp9UqCbGgKhbmqo2nenIJUKe09+ZCGvfXumf3cmAEEmcP6dgKtp9XcVX
M+B/9XaNVfV2K6mbAoUeo1DvFyMisycMiSk24Yq/jMLRiMFEdgIZKjZfQPmf
fZHZjtvW3UCDWz85djlaEoHVcG3r9OhV1N0440OQZ4BVCgtHRi8D7io2uovf
TEAfjqbarXHC8ppe38Zb3xjQ8Gi9leqHR+ihzSKPoc//6vA8q+rwx6ouWPJi
/shY0u3jpWAXJGuZ2P0Q+xzBcm4m0/o//zMmtGHnKwv0PM8qWcWH/n/W4Y8T
syPm5ZjgfyHnvG1tBEqf2/e2bAD/r99/zap+/6hJv0WrRRJcmki/1SNmhPyT
tYI+/aX9nzqwaKVuz1yp20uv6lv/vKpv/dmOvOCkTZgOFOTLlV8MRkrcyWSD
RCJkVckNLv9kQNmC6cyuvbfQ9gZr2i01AozsDYaqa0yQyt040Obuh/bVRqj1
hOCBjVNq9mU2EwjKHjcqzb1R9+7h3q2CeJh7lviaHYu7XImCWiKvPdDSbZVq
Bg0HJ700XBJLmHDS58zb7hPuqPfc3012LP/rT7dfVc8/ErS7vgPTsX6WFbvl
l+wR+1Iht6IW5oMSOlSW7RlAPmc5tHeXLVLP4SjfzYfpbbdEVJlDh/yv40ZJ
b8zRvvTQPaeFSVAUqOE3ifmd5HdThl81jVFLUdcNcczvqLayfWMcw+IHwu35
uXQWCaqtK1NlH4X8I8+vGfSQIfulwhvBh8poY/bHmO06NMh4lakmuIkJbPLE
yehBb3TOTvVgkxABElv9qmWCmRB26v7WwQkP5Oz+LtrVHA+ekiVGClVM6Cxk
Kl8OcUeP0s+l9zJxcD+0q0elE8vLgecCshpd0DveS+6tL3Bg9WLTwkQLpgM1
BGVfzzihBZ1g2wdl/6vzP15V5+fepvnsbxDmv15w2N31MkcSgcENs5MEMOZ6
M/Eb87mf2I7IPLpngkr7WM0O/SHC6Yfb5ntraVAnt8O3o/w8eiobwJlzmgyC
jU2VyBTz929kd25br4WkB170WhIocPPxLo/OeUzvM7YeSiw5gnbNv/R8coD2
r87fsarO3/9WSPLbQyYIuebY72BxQ3YGj/NrT+HBP6t/766v//k/rz/jlvw3
0F6hbRsphTgoNXp/lkJkQoXqm4L5Akdkaqlzbt0VHLSxSlrnYjp5hmJbfveF
Paruun7kwy3cvz7u76vq/1b1f2oOD2D6NmTwMVXEEI0Xny0iDBLhWqnLJtl+
GqR7d2dsmdBBN6tPDzZLksG8KAvn60mF+mgFgYs1qmjZZVKqtIECUkJPtRv5
KJAcfYt1S7AsUld7nWfCQ/tX/9+yqv7/cb/FtuIBJvCWR2iT111FV83xwQIh
OKhKP9+q/gPTvdcdOa8oXUGc9nqDNgo40HStqBegM8FH9LtIc4kNqpDkdmPV
w/3rj96+qj/aluUZoWcMW3dfdk8ICmsh/BPhV4E8ZPib5bWT9z4VNj17OxyG
6aUAISFPs3wKhFRf2qdymALjzksn65ql0HGJ6xcLF6n/zgW+rDoX2PnDfFJp
AdMRHHtuauGskWX+179snDhY3uFYs2eaCcUh/AeYkRZoNN5i7Ok+3L8+4sZV
fcQJG9aV4pKpsFR8oOvmlePo/jf6jZlnFHDTSiFkq1JAW8ZDbnb7fqQoFl0a
zKT+Oy84tvq8oCvunNFfJrg/uHaqg8UUfW/wzr/FjvvXPyu8qn82jPVY8JQB
BT5wl4yQ3cWRLzU6d2EI+9zeNSzHtlNAhk/oprJOEWKffv24A9MV/61TvVxV
p/pvf0T3qv6IvpbeZ92HadC1ae/O2LWZyMIiJsWcSYbyWpNSKez7GC9fMLnO
ko6uHyjzfxRGgRIpbrVl0f/crzh8gnkoD9078iJ8X9X/6lQyq+pU/+0XCF3V
LxCapBvWkEqHv7aS/MdOPkVrTGR13SVIkCJgf0FjPx3kfY5JelfGo1N3Lmcb
NZBAJ236oDGmdw4OFnL3mMQh4WaNJ44PySDB/JbJfEOBKqXsP+tzstEvFPMt
NgjLX47VY3U0GnCZHD7A2PsSiU5vcLvIRYapny92V2Pr8PuUI2dWQCrKtVZ/
XF1JBLGCuKA8LwY4KuuKWxUko45Hbfvx8wSwXOHwB1Zx+FnF0xHa5gw4ohLQ
5/cjCuF+zY1OixJhaGb4nvI4Hdj81Ko8iiKQXraBaWUtEUaKdkseM6RDq+dO
ZPUkDM2RYuLN4kgwlOuypeA2DWi398r2SAehWRlxa5anZNibMJSodWQU7mkc
PVix6znSEjys6MhOBa3BdSlcDnTY/zLYeCPfU2QSaBle50GCReGL/CctGWBK
9TsvOxWPEjRThUt3E0FPYevtURwDbhz+Jbp46yGScxWb/WJOALySzwlNUSZc
SUjLsxl4gDay9nL2T/+Ph7+6iocX+Spm/rCRAc0uWev9y0KQrZiV3pU7BFhr
K6JJwebhR12viOna2+hhQQbHOjEi6B6od8F9poPQpxNHpBp90X2iJlHrFxH+
HL03/APbX+aiGXdGsLwpOTNnwI7pAH/Gia9ydCokVWX51ps7I5kC0tEDGhQI
suaVIUeNQpUBV+O+2ng0wyNB2lM8Ct/kLfSTi+kQY8t2/YpILHrnsvlEDRcJ
hp/JdG/MZMB0Os9USzemuxJuBLKUE+Ca7N+1XCJMUNBcN+R0KwL5zgw8jZjD
w8t7M/491kz4MGF5dKggHB3NW+DYFoeH5++8ci/7Ynl8me8Or1IoUgnZKC5y
7X8ce90qjl3szwsNQSx/XVYSki0d9kFHWQbUGHsIoOt6bf/fdAYkeHXz+Mt6
on0DUuFS1QR4KMX+NoWXAcax4c2kTDd0//wDMc8YIvASzuW7nqNj/v63ma+1
E5riKfDb+pQEkk69VB9MD9aeN/15LcUOaRhEpbzE9KI57YV+IKYf/W3af3ZM
maIWaf7NVz1H/3HgR1dx4IN/6vLW81LhOd8YPn9/CGJ7xrs2Qmr0H8/MWMUz
t7E1efg4YnnZ5hGy1rmCDF2qr8iF40G/OPzp9gNUiB1u2+TvG4A+KX6XjNqK
rVeVPrNpJQbIx9dcyTD1QobS+WkHLhD/cbw3V3G83t3bt5v4M6Hhs0W3yylr
VLJcsOa6A5ZPM67kT+5kwsM3ws2iKZdRja7Xbh1WTIfIkNVzT1Ih+jLfrUU/
b9T2YmRoLeYH/KwzRffpMkBW+CcuztMdbbtqJhShTIQCvtEYUykmRMcJ4cgs
LihYe9zUeBT/j3e9sIp35a3JPvv+HhOUpFlSeh6bobk1Nt1qenhIKP5gKnmA
CcPXp/L440zQn5p5zx90PAxYzfA0YOuNlhwnkJ9viE7o7mSXwtabXIbwAv4c
FTjCjU5FVNxEDiVOyaRxCjjGz9zUMGOAMoso7zFeZzS3fNJFTIII6+b7EmnH
sXne0GWR9tsRuYS3agl24iHG4Ufai9dMEPMIHkzrske29dF873jx/zhS+VUc
6dCSqVHQYyagPKpcy14T1HbjEbuOEh74bn5KzjvKhO9G65+ofDZEJsdlHrb2
4CH8uVbm0XcM2HIXb76fWx/Z/lboIWcSwEehiPLhDx0c/7iu+1qqjXBu+0m/
3xJB2PVs3Z3LVAjl4Q5aLnRFZn31RDscBTTV7HZtcWBA+6Q1v1GCI0rTyvVb
2k4ELp50zSvq2P5yMmju2WmPOCP67+z6iAeL0eQHlzCdvOeo9UZpN1tUslt7
zximk0sCcgj7JzGdfC0i2uu4NfqAm+ezPo4D4grPObWK56xNyy2+9IIJsqFV
hklVhuhyvPjhUElMn2vIJe1SZcJQ15Ji2Ud9tDy5K3ioAQ9n45ZPe1Uz4EPm
58IbyjrIp6yZrTeeADS+c5/m1jGg8nTa2dI+DSS83T+S9JwIcxefiAVuokNE
XeBA7G5AjuNS1e5jJGBySx3f4sYAUkCd/w1uexTdHO5ps54IGZ6n2zWx+BB+
NpgRyGuL0n37CJnv8HDz4/KNBMwv4DQPXsmJs0K5Lw/Ka1Nx8PklW8PmOSZk
qutmUz9eRoOMjzl8QjjQ8PF8Jrp5DMp55NojXS8hVYsj9761/Y/DjF/FYeY+
OJxYhPkUrnXbh55znUeBblrtRzGfEuqwtWj+DBNMM/tS+OTPIi65QUmXD3go
9nX0WsbiOfXhsxMXPbRQCOl0hA4Wz0Wt+oYteRjwhjrhvadTFZ3J0PytH0uE
GeO+0B/b6YB/d8sdF62E/AIWG9lGSLAvZFLep5QKVaIci9ufyKIkJZWK7ADK
/3l+999zeeNV5/L/5RZ+reIWfqzwBmqreIMHE/07zi/iobr0uz5TqAkdDDij
ro35hP/WqdJX1an6cBfbR1JHIXw3PkbauAzxhD4z/npjFIZWzqmTVs6pJ1fO
qf97br521bn56r5d/pW+3ZBxxtd9SxSIGM768tXuA2KkKEebb6XCiSrRM9/l
aMDrfZhUV/kGpWhO60QPkeHSSt/xj5W+44aVvuP/B6RyzCQ=
    "]],
  Axes->True,
  AxesLabel->{
    FormBox["\"\[Epsilon]\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*OverscriptBox[\\(c\\), \\(_\\)]\\)\"", TraditionalForm], 
    FormBox["\"ncross\"", TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{0, 1}, {0, 20}, {0., 1.4878617361080708`}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.4009332319423485`*^9, 3.40093324402973*^9}, {
   3.4009332952533855`*^9, 3.4009333588247967`*^9}, 3.40093339449609*^9, 
   3.4011925787692847`*^9, 3.401193716154765*^9, 3.4112980425186787`*^9, 
   3.41234142681723*^9, 3.412341460605816*^9, 3.412341735050448*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Percolation", "Subsubsection",
 Editable->False,
 CellChangeTimes->{{3.4123386388783712`*^9, 3.4123386409813952`*^9}}],

Cell["\<\
We can make an alternative estimate of the percolation threshold by assuming \
that the number of crossings per fibre is a Poisson variable. If the fraction \
of fibres making no contact is less than 1%, then the expected number of \
crossings per fibre at the percolation threshold is:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412338647080165*^9, 3.41233878936476*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ncrossperc", " ", "=", " ", 
  RowBox[{"ncrossbar", "/.", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "ncrossbar"}]], "\[Equal]", "0.01"}], ",", " ", 
      "ncrossbar"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.401189598884421*^9, 3.401189628737347*^9}, {
  3.401192920741016*^9, 3.4011929475295362`*^9}}],

Cell[BoxData["4.605170185988091`"], "Output",
 CellChangeTimes->{3.4011929495524445`*^9, 3.40119371707609*^9, 
  3.41129804582343*^9, 3.4123414274881954`*^9, 3.412341462508552*^9, 
  3.412341737323717*^9}]
}, Open  ]],

Cell["The fractional contact area of the percolated network is:", "Text",
 Editable->False,
 CellChangeTimes->{{3.412338806679658*^9, 3.412338856781701*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[CapitalPhi]2dperc", " ", "=", " ", 
  RowBox[{"ncrossperc", " ", 
   RowBox[{"a1", "/", 
    RowBox[{"(", 
     RowBox[{"2", " ", "A", " ", 
      SuperscriptBox["\[Omega]", "2"]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.4011931514627776`*^9, 3.401193169819173*^9}}],

Cell[BoxData[
 FractionBox["2.931742395517711`", "A"]], "Output",
 CellChangeTimes->{3.4011931742555523`*^9, 3.401193717116147*^9, 
  3.411298046384237*^9, 3.412341427558296*^9, 3.4123414626187105`*^9, 
  3.4123417375440335`*^9}]
}, Open  ]],

Cell["\<\
At the percolation threshold, our networks can be considered two-dimensional, \
so we can use the theory for the fractional contact area of two dimensional \
networks. For very low coverage networks we can approximate the fractional \
contact area as the first term of a Taylor series, \
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4123388662953806`*^9, 3.4123388966590414`*^9}, {
  3.4123412222931395`*^9, 3.4123412645539074`*^9}, {3.4123413076859283`*^9, 
  3.4123413578280287`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalPhi]2d", "=", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "cbar"}]], "-", "1"}], ")"}], "/", "cbar"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"\[CapitalPhi]2dApprox", " ", "=", " ", 
  RowBox[{"Normal", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"\[CapitalPhi]2d", ",", " ", 
     RowBox[{"{", 
      RowBox[{"cbar", ",", "0", ",", " ", "1"}], "}"}]}], "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[CapitalPhi]2d", ",", " ", "\[CapitalPhi]2dApprox"}], "}"}], 
   ",", " ", 
   RowBox[{"{", 
    RowBox[{"cbar", ",", " ", "0", ",", " ", "0.5"}], "}"}], ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", "Dashed"}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*OverscriptBox[\(c\), \(_\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(\[CapitalPhi]\), \(2  d\)]\)\>\""}], 
     "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.401193329148277*^9, 3.40119336147476*^9}, {
  3.40119340920339*^9, 3.401193424865912*^9}, {3.4011936918598304`*^9, 
  3.4011936938627105`*^9}, {3.412340296431816*^9, 3.412340301579218*^9}, {
  3.4123403887044973`*^9, 3.412340432026792*^9}, {3.4123413800800257`*^9, 
  3.4123413803704433`*^9}, {3.412341684958419*^9, 3.4123417161132174`*^9}}],

Cell[BoxData[
 FractionBox["cbar", "2"]], "Output",
 CellChangeTimes->{
  3.4123414276183825`*^9, 3.4123414626487536`*^9, {3.4123417113764067`*^9, 
   3.4123417376141343`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVyH04E3gAB/CRjup5huIYIbXuTnZ1IaXSV3mJok5cN5emK4miK3ale3JN
z1xeu7pcVpOIXiTmZV4aMtu8ZPLeiM20k6dadbqzIsr97o/v8/1+vvb7f9p1
UJ9Coewg+b+3HXzeLX7hvYnMSYGf6yYDT6tjahodlNxhy2yaGZyv87IraC6g
iG/+wyD/9kf95ddoXqDw5kVcsHTB9+Hv6/+gBYNicnVDvIUXVKvOeWbQwkFJ
zfuTaR6MXPOdv6XS2KC8Kfh1qWk4Eo0qvkyhccFRmux7YMQGMyRPMP42Exyr
lb9efMTFgtnE0K2218G5qvBd3XEeywPfPJemFYDjZ6a/2CcTJzvcwJsoBGX1
0fc1SVdgITQd1tMTQDx5f73TgRxUaTzbOzeWY8TpRc5fnXmQHL5mHfJKCIoo
rv6HvQXQfeFuXBxTDRP9jpIe0S3oTxWZWC8XwcOZ7zDhUwjX2X1VQSV1KJ2i
puTnF6Gd69LRvKIBI7s8Wq6MF8Pugnaq8I0YXQNTUsGaUmjfq4cffyNBq60X
a3BPGQpe1rZRz0tRk/Nh0SVeOag2t/8eHZVhX9DEs5BHFUiPqozIpTfDd2za
OUorxDuPotHIMy0Yd7i0h29XBbaTTPi5tBW+VENbpns11CWytG77Nnx7MtDy
6bEaTB/u4zv8IgczTht2P/s+HDcbfoqobQePbtnDKxdh6w37Q2UWHUjWKIeU
qlqctAlb+jS0E0vm2M+P/LcOjFffLegP6ILl77RzEr0HWGQ8biT70AWxefBN
2+UNMGjgC5Zld6NmrQmLTxPjiEvtk3nbe2Cms0iZvStGkd/+3AfvesAcVN1u
XNcIndbKZOxyL2Z233RcXNeIyqCtczK9+pC+udcmx0+CM75J14VjfXAJ649T
tEtgr9o2kJ/0GJNumY13/KVYv5abSXNSgFefMhOnkCLUtnNKr1eB5OKoCMZu
GXRtGZpjif0I9754plotA8+Axd5FH4DYjd3nH9aERcOVN/RlA4gWqRyzhpow
NyEx2O34E0QKU9ed+7EZlEKWQLNwEOITGy9UqZoRe1WQsVAyiGS76NyIAy2o
d0w2Mj06BGaCk1LyrAWm22IZZ6lKRBo7x15itUL5dVfvqTolJnVup2tGWlGa
A/ooS4XoNPclMSEPsVfgamrzSYXsFuOfDTofgpOUl6i8OwxxxpOJpoA2FD+3
4VP91YgXGQ74StsQaEpd1/JBjckVYUt6N8uROlffWkncri5x1hDLpnQfx4mN
jk/7vCV21aikVtNq1H2VFmO8RQ6riuKdR4m9XnNF24k1wQGHzGeI5U+DZMRs
XvrlAx/V4I54cCs95ShO55yKJ55YxsiSEY9x2KEZxDOeZnd7iZlRoUuridm0
oc63xO7rGSXzP6lRauVpvdJLjs+U8qYy4twTp8tuEaOr4U4zcfrZNbJK4nhZ
RdoQsdERrUJG/PIeP3DurBoF3QEzGuKOhCMqJnGp7pWPnbcchrFh4hhi+lh6
yEpij4ig/LPEjAqHaHfi8h0bou4RT2hCLu4h1m5Z5d9ILPR+nX+YmL522SoF
sUlSQtUpYpajxUItMSVv/sNk4iy7BbpZ4uQrmUNZxP8BjAVucg==
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Dashing[{Small, Small}], 
    LineBox[CompressedData["
1:eJwtx39I1Hccx3F1Wi7h7GxNTrEwr0XpcDSz9fNV6XCzX5iOGdxsNLMstJKD
ahB5oav8UTHE3LRpJpT548o7daTldfftdOd5H82f1Z1fOkRcF83BzrCW7jM+
7z+ePHhGHjy+75Cfj4/PHt7/Jh+aGjD9+eVW4bqt/glhJ2SVGsKP8Hl1RZVB
FUeqsbNvtOW6KpGMw7eZbx78rEojE+GKvZBQqsok01CzdO9PRSotmQldoGHV
JVUBqUX6/hv66b/LyAIEzes0ScuqyStYmfJ6ylJcR5bhlGMDKv6pJ39BqFE5
7uurJ6vR5k6ws80tZC3MR6+H739lJOvg/WRLcFNOO3kLfrMNi8NX3ifvIH7+
+7bU5k6yEfaCOId1TRepx/Krntn61ybyLjxv5PHhz8xkC+pedtgUly2kAYqI
W39NTEikESXZrVk1aivZhpltDRNHznWT7dCulYwfW3rI3yE3S8UDkTbyPt4d
Hapc/WMv2YHo7QvnsjrsZCeSaiMP3wt1kA9xKuLAihcaRnYh5tU3QaO7+0kT
lgRPB0pv+0kT/Lsq9VFVA+QjHIvrePrhziekGQ1fH6x5OPOENMPrCVs8WT5I
WtCamvRBWeIQKeHcV4XVxskhUkKkK3nsZuEw+Rgb1xeUqdaOkFZolrFZ38ER
0gqvrdR9QjdKdqPCP0O7Tz1G9mDJeGutnzRG9iDgrC5tw8mn5B/wqc/Qu0Oe
kTbk/aovDTE/I214EH0xUJn7nOyFMjkv5rzCSdrh/LR/8Eynk7Tj7m9QT2S4
yD58p49XRsy5yD7kF97QOe+Mkw40TUVUKnbJJEOKUvFF91uZZCgK8At38hcy
SLPe99P8hQzxbpcl7J1MMoQZmvbm8hcyuNN2H176r0wyaCtKyn94L5MMTSX5
Z07zFzJM5ms1pfyFDOnZmhXt/IUMWzbGNC+ak0mGBc7ex/f4CxnQ33Xbyl/I
cFoyFD/nL2R42ViZEjAvkwyOs8dc6fyFDAvzDphy+AsZtmWl3jzPX8jQsmdT
diN/IYNnR+yuR/yFDOr1UbEj/IUMGdGhIR7+QoZry4O88/yFDP8B30J8MA==

     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox[
    "\"\\!\\(\\*OverscriptBox[\\(c\\), \\(_\\)]\\)\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(\[CapitalPhi]\\), \\(2  d\\)]\\)\"", 
     TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{{0, 0.5}, {0., 0.24999999489795918`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.4123414276183825`*^9, 3.4123414626487536`*^9, {3.4123417113764067`*^9, 
   3.4123417376441774`*^9}},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
Solving for the mean coverage provides the mean coverage at percolation:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.41234236810073*^9, 3.412342392275491*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cbarperc", " ", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{"cbar", "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"\[CapitalPhi]2dApprox", "\[Equal]", "\[CapitalPhi]2dperc"}], 
       ",", " ", "cbar"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.401193329148277*^9, 3.40119336147476*^9}, {
  3.40119340920339*^9, 3.401193424865912*^9}, {3.4011936918598304`*^9, 
  3.4011936938627105`*^9}, {3.4123413691042433`*^9, 3.412341389143058*^9}, {
  3.4123414364610977`*^9, 3.412341437592725*^9}}],

Cell[BoxData[
 FractionBox["5.863484791035422`", "A"]], "Output",
 CellChangeTimes->{
  3.401193663208632*^9, {3.401193694573733*^9, 3.401193717426594*^9}, 
   3.4112980467547693`*^9, {3.4123414280690303`*^9, 3.412341462668782*^9}, 
   3.4123417377042637`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.3.4 Absolute Contact States", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.4004879210367136`*^9, 3.4004879250925455`*^9}, {
  3.4124086644201555`*^9, 3.4124086663128767`*^9}}],

Cell[CellGroupData[{

Cell["Two-Dimensional Networks", "Subsubsection",
 Editable->False,
 CellChangeTimes->{{3.412409160853992*^9, 3.4124091677238703`*^9}}],

Cell[TextData[{
 "We obtain first expressions for the absolute contact states of \
two-dimensional networks following Kallmes ",
 StyleBox["et al.",
  FontSlant->"Italic"],
 " The fraction of the fibre length that does not make contact with other \
fibres is:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412409176406355*^9, 3.4124092444742317`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"P", "[", "c_", "]"}], " ", ":=", " ", 
  RowBox[{"PDF", "[", 
   RowBox[{
    RowBox[{"PoissonDistribution", "[", "cbar", "]"}], ",", "c"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"C0", " ", "=", " ", 
  RowBox[{
   RowBox[{"P", "[", "1", "]"}], "/", "cbar"}]}]}], "Input",
 CellChangeTimes->{{3.4004896179066925`*^9, 3.400489637615032*^9}, 
   3.400492236722365*^9}],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"-", "cbar"}]]], "Output",
 CellChangeTimes->{{3.4004896400885887`*^9, 3.4004896517353363`*^9}, {
   3.4004922375635743`*^9, 3.4004922579428787`*^9}, 3.4004980487997217`*^9, 
   3.4008288773277826`*^9, 3.4008403695127325`*^9, 3.40084118080932*^9}]
}, Open  ]],

Cell["\<\
The fraction of the total fibrous length making contact with other fibres on \
one side only is:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4124092570022464`*^9, 3.4124092901599245`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C1", " ", "=", " ", 
  RowBox[{"Factor", "[", 
   RowBox[{"2", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"P", "[", "c", "]"}], "/", "cbar"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"c", ",", " ", "2", ",", " ", "\[Infinity]"}], "}"}]}], 
     "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4004898615470304`*^9, 3.400489862708701*^9}, 
   3.400492239235979*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "cbar"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "-", "cbar", "+", 
     SuperscriptBox["\[ExponentialE]", "cbar"]}], ")"}]}], "cbar"]], "Output",\

 CellChangeTimes->{
  3.400489871050696*^9, {3.400492239656584*^9, 3.4004922611975584`*^9}, 
   3.400498054287613*^9, 3.4008289087629843`*^9, 3.4008403780450015`*^9, 
   3.400841185616232*^9}]
}, Open  ]],

Cell["\<\
and the fraction of the total fibrous length making contact with other fibres \
on both sides is:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412409311831086*^9, 3.412409327373435*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C2", " ", "=", " ", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "-", "2"}], ")"}], 
      RowBox[{
       RowBox[{"P", "[", "c", "]"}], "/", "cbar"}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"c", ",", " ", "3", ",", " ", "\[Infinity]"}], "}"}]}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.400490016990547*^9, 3.400490020545659*^9}, 
   3.400492241158744*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "cbar"}]], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "cbar", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "cbar"}], ")"}], " ", 
      SuperscriptBox["\[ExponentialE]", "cbar"]}]}], ")"}]}], 
  "cbar"]], "Output",
 CellChangeTimes->{
  3.4004900232595615`*^9, {3.4004922418497376`*^9, 3.400492262188984*^9}, 
   3.4004980554793262`*^9, 3.4008289103252306`*^9, 3.400840379487075*^9, 
   3.4008411867278304`*^9}]
}, Open  ]],

Cell["We check that the total probability sums to unity:", "Text",
 Editable->False,
 CellChangeTimes->{{3.412409346751299*^9, 3.4124093766142397`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrueQ", "[", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{"C0", "+", "C1", "+", "C2"}], "]"}], "\[Equal]", "1"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.400490211900814*^9, 3.4004902529999123`*^9}, {
  3.4004922447438993`*^9, 3.4004922471874127`*^9}}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.400490216697712*^9, 3.4004902654377966`*^9}, {
   3.4004922476580896`*^9, 3.4004922622290416`*^9}, 3.400498055699643*^9, 
   3.400828911296627*^9, 3.4008403795171185`*^9, 3.4008411869281187`*^9}]
}, Open  ]],

Cell["\<\
We generate the 'contact state diagram' by plotting the absolute contact \
states against fractional contact area, as given by theory for \
two-dimensional networks:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4124094250739217`*^9, 3.412409475796858*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalPhi]2D", " ", "=", " ", 
   RowBox[{"1", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "cbar"}]], "-", "1"}], ")"}], "/", "cbar"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cb", " ", "=", " ", 
   RowBox[{"cbar", "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"\[CapitalPhi]2D", " ", "\[Equal]", "fca"}], ",", " ", 
       "cbar"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", "C1"}], "/.", 
        RowBox[{"cbar", "\[Rule]", "cb"}]}], ",", 
       RowBox[{"C0", "/.", 
        RowBox[{"cbar", "\[Rule]", "cb"}]}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"fca", ",", " ", "0", ",", " ", "1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "None"}], ",", 
     RowBox[{"Filling", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", "\[Rule]", 
        RowBox[{"{", "2", "}"}]}], "}"}]}], ",", " ", 
     RowBox[{"FillingStyle", "\[Rule]", "LightGray"}]}], "]"}], ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[CapitalPhi]2D", ",", " ", "C0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[CapitalPhi]2D", ",", " ", 
         RowBox[{"1", "-", "C1"}]}], "}"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"cbar", ",", " ", 
       SuperscriptBox["10", 
        RowBox[{"-", "10"}]], ",", " ", "1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}], ",", " ", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[CapitalPhi]2D", ",", " ", "C0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[CapitalPhi]2D", ",", " ", 
         RowBox[{"1", "-", "C1"}]}], "}"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"cbar", ",", " ", "1", ",", " ", "1000"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Black", ",", "Dashed"}], "}"}], "}"}]}]}], "]"}], ",", " ", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", " ", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", " ", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", " ", "Automatic", ",", " ", "None", ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", " ", "0"}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{".8", ",", ".2"}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{".6", ",", ".4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{".4", ",", ".6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{".2", ",", ".8"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], ",", " ", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[CapitalPhi]2D\>\"", ",", " ", "\"\<C0\>\"", ",", "None", ",", 
      "\"\<C1\>\""}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.400495678431299*^9, 3.4004956804041357`*^9}, {
  3.4004959579131746`*^9, 3.4004961185641794`*^9}, {3.400496180363042*^9, 
  3.400496181925288*^9}, {3.4004977039138002`*^9, 3.4004978456375885`*^9}, {
  3.4004978824905806`*^9, 3.4004978857652893`*^9}, {3.4004979637874804`*^9, 
  3.4004979794700303`*^9}}],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdmXk0lV/Ux00NhhSJTBWVkKlQGe6zkyGFMhXJnErILEOZioyVKVNENBEp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    "], {{{}, {}, {}, {}, {}, {}, 
      {GrayLevel[0.85], EdgeForm[None], 
       GraphicsGroupBox[
        PolygonBox[{{1, 216, 166, 124, 91, 680, 679, 369, 413, 476, 563, 
         274}},
         VertexColors->None]]}, 
      {GrayLevel[0.85], EdgeForm[None], 
       GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwl1nfYjmUYwOEvVEaR7L33HhlRiGSUjBCJjIQysslqmsnee5NVGaUSWkZU
VlNmlL1JUeeVP87jd933e3zf977P/Twvudp0bdglUUJCwh3MMiymscWjpCEt
6UhPBjKSicxkISvZyE4OcpKL3OQhL/nITwEKUojCFKEoxShOCUpSitKUoSwP
RL2vAzqL7jShJuXida/9prPpQVMeo3y87rWDOoeePE0tqts/rSt4leepED9j
/5DOpRfNqE0N+2d0Ja/RnorxM/YP6zx605w6cf3sn9VVvM4LPBg/Y/+IzqcP
z/Ckvev6EW9TNz6bvXO6mjfoQKX4HfaP6gL60oL69v7SDYzm8fj89s7re7xJ
x7gucdBsNk+kcvxO62O6kH48SwN7N/Rj3uGJuGb2Luj7vEWnuJb27mCLeRIP
xe+0/l0X0Z9W1knZZm5JQ/Pf+gljqBfX195F/YChtLO+l13mF+MMzIn43DyZ
zub0/GB+OP6u+bgu5hWes07G9vj7NDL/o58yNq6F9f3siWsf52W+pGvizM3Z
GRb3hKbkW/NLcbbmxHxhHqD5mGKOBygDP5qrxHsyn9Alca+aszDA3FqTsyPe
I0+Zb+rGuPbm3IyLa6tp2Btnr8WoH/eFXta1ca+ZczA87kVNxXdxL2thOse9
pUkYw5fWAzU/U81dNWO8f36K664lqRqfQf/QEbpUe2hWBprbaIp4n3xjPVgL
0trcWG/FPaifxflrHmYyPs5S0zKJfXFfanHm0yDuW72io3RdPB+ak+mMiGdI
72MC38dzqEWYS5d4FvROxvKV9SAtwGymWXfTTPH5+dl6mJZiIdWsq+qfOlKX
aU/NFj/LIOu2ek98FnZaD9FCzKGNdRP9N54Z3RT3ouZNdPt7dULcQ5qOyeyP
50hLsICG8Zzp1fgO0PXxfGsuZjAyvgM0NRPZbf26FmUeXePZ1bv42jydR6hm
fVLfjbOKzxDPA9Xjda+d0uXxWeK5i3synkn71/TDOIu4bvHs2rubreYZvGzO
zC/m4VqaRdSwLuNrJrX+oMniu0W/jX9j4proDL7iOs3pzng+5RyP0ICOjGAN
xylNKUpSguIUoyhFKEwhClKA/OQjL3nITTXq04HhfMDv5KIqT/ICw3ifY+Sk
CvVoz1De4yg5aMbLjOMTzvIwT/A8b7GaI2Tnaboxlo85w0M8TjveZBWHyUZ/
pvMl12hKV8awgdNUpjeT2cwl6jKbbfxNW95gJYfIygJ2Jdz+D0A/mcYXXKUJ
c9nBTbrwPYnjHtePOEUl9nG3/Xl6r36jt+hFKuvdmkQnaQrdpBepw33We/Uu
naX36Fa9QRtSWn+nieKe1+S6Qg+Shf0ktTdfd/IvfdnDnfan6udcoTFz2M4/
dGY0H3KSB+nJRD7jArWZydf8RWteYzm/kZk+TGELl3mKl3ib9fxJRXowgY2c
pxbP8SrvcoBMNOJFRrGOP6jAY7RiCMv4lYw0pBMjWcsJylOTlgxmKb+QgXI8
yrMMYgk/k54HqEELBrKYn0hHWtJwP6nj7OJ844zi3OPs4nzjjEgW5xL3RZxt
nEXcAyRO+P+/IQllqR5/2+I/8EQ2oA==
         "],
         VertexColors->None]]}, {}, {}}, {{}, {}, {}, {}}}], {{}, {}, 
    {GrayLevel[0], LineBox[CompressedData["
1:eJxNy39QzHkcx/F+XEXoB/3YnKtUSD/onLJSXqn8PvrBYg1zydbgEGrSFDbq
Tl1bG/12NC3bmHVLXEUJbbWUfmjLtl9atk21qq0tyaEre5/+u/fMe57zmHm/
F4ZHhUbo6ejobCc73elResY+yVw3ptVqR6BT5MXVtXFCbzS9/8wUsSisPJ62
EuKbE3oTE8Rxp1nHrAPh5d3TOv6J2MzVdYflTmQvkj0bUk//X2y0M2fh85fm
RSpqBInOdkaPZ8Rgx+h+zrcS4mDJeqMvSXibM8v+aRhx5Z7lmYJsGOb+S+M/
0CDxyMzn29mFcA7mC0cWaKBUnCqQ6vKx6M7Un/SUYfhFB3pdtRGgrP9DldPg
EIIzb382bbwNlzlc9wLmEFJYxr6iyHtgnD9u4ChSo+HQjSBjaSnWaF9k8NzU
8BPJJH2m95GXsvP7luJBFPHzVomiK7BC6J/AsRqExCfLNfTmQ4QXF3++mDWA
itGCytqGR/j1jnxOruUA7FcuDmkyq8Z86bvfhNx+WJyqFGzMEYHJspj0tezH
zszNEd1lNbhwgF1Jz3oPn2a9TWFNtfBozzOC1XukiIpLK5rqIB/OqDXkq+AT
srLFViHG1XORNjdcVPDI185Sdj5FVXfpHl5VH2JKx/9xGngGtaK+vWl9H/iX
Snb1aeohVa1xTpX2QqKzKUnd1QD9dMsu7dFeDJ3lLqS6n2O/ZlKsr+1Bcn0Q
83xrI370rdp45EoPWFEJVH55E5ixuT3lq3tQpNQW6gqb0Wjy1bS//R2CjY+b
TmW0YG/VYGx/zDuMW5YxW8+/QHpHZbWNOfEWq5mGx1rx/t7HHJd73Rizawxo
dZAgw9DBOoHZjS/XXQWiXAku+8nrtk8qEXqpYH2+bhu2pOyroN1Uwk3u2Tz7
cBuk6wQByxlKPBmz4/dSbchODL67dLIL8Xo9v+isbUdSXV2wal8XNijuztz8
VzseyGMdq0sVmBTzI4zMXiLEKue1vo0CzZStcf7Jl7hTcG3ZhuS3sJ8h9KB1
voSF/km9Zao38GjQciK8pXh04qfd1xhvQHOMuRXFk4IeYMV0eiQHZ4m7yyaD
DpyKKVtd5CyH4nbWoYADHZBLk1Y18DrRsC19Xk1dByqeJPv/PrcTZrFLktNt
ZWDIZsexua9RZjgelxgrQ2gob1+a+WtcZ592r5bKcOuyp4SX9gpWiw9aX3Gl
UBlfixXmr5Cp3pqblUIh7fHw/GVcCt7HGbxC4pJ824e2xGu5e4UCYs5ZJtOU
OFK4u7aaeDdrOG80g0Lojh80auJzxemWpcQnGLLAwFQKW0ZL5tKJjVdrNePE
BvEJFv7pFEzSznzVEhexh8tWEN9K+KQ/6w8KDhmHGY7EYnonbSGx+Ck79zvi
6w5R/tuIawqdbOo5FKT3n2UXE2s+BNn/TMz5OFV4l3j0QniND/G3Fx6CKuKT
C9jh7sTO4amP24hlh2R8E2LhVwPVFHF05NTStjQKiW7zR2eQlnuHNdWQOnxb
OjGPdJ11y9G/SV+d9TFxIbUbEJdkkWpcQfMkPagICkkm7YzzdfCbvpP3jsWQ
FrJWuW0lPd2dlB1BSh9x89r1v/4HCXV5Dw==
      "]]}, 
    {GrayLevel[0], LineBox[CompressedData["
1:eJwVzg1QzHkYB/Atp5ctlQm93OjtUmlb9k4Rs3xzyqFR9OIwKS9bupxiS1I5
hXFRtK4XRbOThFstoqROtBFWL3ar1SYz//67bSl1W0dLVPZ+nplnvvOZZ74z
j/PuhJBoQwaDEUT2W34b2if5kQf31HW9fhSM0qW5BnauuCIvG0ufJpbsvJdq
643a6jLXL1+IUw7z9tv4w60iZYtOR2zFYoXODcODFCWtHf7W/7PZcTYPlOHi
bK1yFBkejsYPTZJwbUe3uVMl8SZ5gPHECeBWQOqGXcR1WxcLRPnIuj/irarT
IiPO9EXQMSHsl70OUDhrQVP8YoVBObi1C1sqBP/CL9F/aYmdCM+jxF/TP41g
k+DmJ8vmm+C1Wm9P+n0EWTzmSknMHdRfcrT/+HoY0tgrwUxFFf7uPnUnIGgY
fpIueb9lDfwbqRt5sncoLb+wTJJYiwur931nuuEd5Nw8Vsj1f6Cz46Rq5EOo
HSuueyyth/nr+c0RO4bg5O22ucWqAX4+lnR23yDm8OtEvxRIUJ85s83x0CDC
BOujVdWNYGVfWaBmDILbarhuZ8tjHGf+uGTRX2+RJblaVdvyBFMPxqgh9ltw
N3u3OVBN6F6wtzi8aQCcIr0Z3fMU53L33r/LG0BS1fhH16FnENgwnT0ZAyg/
f3tLv/Y5DhfKJk+W9kPOWHdiuFeKeHvZMd36fowczXVWql6g8lKj/QetBief
B2/LlDXDI9KBW1CiAS8hTVl0rwUx5e9+8g3SoJTWCw3ErVDP4o/KJ/uwiRlv
OX2uDT1pOYeC7/RhfG71NlnmS8yr2ej1/R7iDfNMjfbLEHiaz+m27cN7x+Y1
Mhc5ZrMt+E9fqTFRxhJJCuVwcFVzInPVCDlfHFBk0A7N5ZCaF8FqeL3xaTX/
rR2KyKzQfdZqPHrvWK5RtiMs8UCYhUKFVMO+KMaqDkw9vVY5cFGFtVSl6fqK
DkzWubNNolSYaiqPNrbqRNCb5TBbqEKr0oFZdLATRw7W+1I6Gk4mYo5tTyc4
ZvOXrJXQ4Ej1OdErFND6LtEYCmjY/pB0I+GyAqExZ2bk76CR4872XDfzFRgl
qj2DbBrUzbzYNbteoe64TanZDBrSjWetG5+Qu52r+Jy4F1bJ7ifPOnRBWhQ7
YRfRi2qj8ZSM5C5Y3PWssLHqRdmxw+wGRRcKXbdPNkoozHPbY3ORpYRwdeCt
oiMUBMOBhXlZSniHJO4+sZjCivjwy0LijlmDNanEq3K3i0XE+XaxZnziGPGv
jxuIU53PVO8kDgmdrx0mLvkv3HgV8YHwLn//00okZ5vfnlhEgblcrx0ndovR
GcUTW2Snf9YTR85VREQT30jTzTA7Q/6xfnQ3grjJt8fWmdhquioykLjMJeHn
jcTPjrvf9yBW1DzLv0r8x2Z2XB+bQs6HaWEl8ccRiaSH+OtLjugBMd0VZdNB
7LH79MN24qmChiYJsfjzzIFpYl+JkZOQOMPLfswkW4m4l+PJBcQuXxd+sSaW
emrbcoi7j3ItPInftxmmpxFrWbD1Ib42x6GTT9yTstLFjzhW5O8ZRyzkLfMK
JPbISc7cRew76rV0CzFdX9W9lfh/jrppbQ==
      "]]}}, {{}, {}, 
    {GrayLevel[0], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxN0wk0lesaAGAkx5SUyhAhQ9glHYr4//8V4ki2IUIy3yhjFJVEIhQyRRJx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      "]]}, 
    {GrayLevel[0], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwV0Hs4FFgYBvDSjfKoKGSVJMWixrJC8im7RCGSSxER2iIhKkJuyTVP2ShT
2nhQmHIpqQgtSTXNksYYl3EdM2bmYFySS3vOH+c5z++v93tfVa9ABx+JJUuW
+OJHfkOkbeCUwgTOm4oOF50e8KJautZYdIHh4g4jngEbjBO71shu5kBnZ9nR
pd9ZEKDvIvjc2AcM52N6Br0sOLIYKl+mPQDhNi8UhAmdwBiUym52HwQDiTAd
23w2rK7cXlflNQQl9td6bkh2Q8RNMdfYfBispV8/js3ogVdBGRFpK7hgGyzJ
zZPlwMiGsbpqGhfC3x927WNz4FW1jBvzwAi0GLXupOT2ATMpRDvfkAc290N9
GFIDcHHa76ZNLg/uaMS49NMGgPrMzFFujge2EqVxnw4OgmeNrTsriw+UZCcU
7jYEvlor9fTZfEg+JE/xYA6BsRYrJkxxFPyLjD9RrIZB7C22yI0bBeUDDidO
b+DCWbu6r6laAtA3FbdPHR+BP/K9djOkhGBWqpA6JceH4GV516q2CEEzWb2y
dB8f2lfOdEf/JoSPpVP9Oj58uPeTrrvGWQgHv0T67KbxYWs1beTn30Lw5HM1
VmmPgmhGefzCtBBS/E3i+wWj4Jj0bUVMsAiyDPukJYYE4C6xqPDlsgi05FiU
B+MCkArKa+BHicA7bCihfUEAjdXDUpnJIti3VmWDxkYhmEp7aXJzReDwnOVA
ByFMv5jIX3wngvnxYauFRJzb6vW1flYEjwsai+LEQrAfCa84ZoIgjzHlW4xz
nGoDeOYRCIqvslsTp0Xg0aRJ35iDoCb1KFXLAIGWtZI37ykCp0z9plYPBKq/
JiZ1vEFg7igjV3YFgVjFfw+rCcEQdJwvT0OQUCvXrEZHsCZyZ4YlFcERQYBx
UBuChx3si/0FCJT2F+dJdyDQj3Wy3PQMwUjV3rEMNgJG4CWOahWCKT2rwdAe
BHy/W82jOCfD87qJSh8ClXrpK6YNCM5lAsVsAAFTI9rzGs59bUUVwRCCsNuG
3dEtCCKeqMdPDSOYcTwkOfoZgefSVOmTIwjqJRQ3vWEg8KhczanmIag9s7Eu
BN9164SfZRcfgVoVPf1lO4IARo3tzCgC1sOI+yImAvnUmQ/jAgTaiuj2AAtB
oGaJe5MQQbeDy+tUfLdakLAzW4TAor/zuW43grPliqLDCMHX07pdd3EPkb09
B2F35T2q6+1FkPhvk8btMQRrk9Lsd+BexZMB+7eO43157FizftzXznkPDVs1
l3beDfdcPtJWsHsCwSpGoY3HIIJvjWp+D7FLUizpZri377OjrbJiBJ88C/PV
cW/3GSYKw34letorxM66VHGyDVsH+dYUcBE4lo626U4iKDrOLPTGu7hun0Lx
2OUH+b1SeJeQcPryTuzhSapUJfY7FnWb+hSC6xVGf1rjnY5HRUudw34+vyj7
DTvMRn+hHFtw78wPH7zbHWXJ9xPY2kbr0oew46PGY/Sn8f0L/cv+wjtGSTh3
BmHPL6dVDmCbaBWfL8K+4uTUfQTvKvNWLOBgK0dxWfXYUbNX7eRmEMxNzD7Y
gXfO3WqfdwDbdP8jiwTs/EjF/0KwreYoj7jY28K+fMzFNhc8yAK8e7vlfOxn
7Mc3v6/IwU5PPXaDWHlT8TpimxZaGvHdTPdfiFmUU9nEFacaKMR6TxpLiX0c
U04Qj9mkdRBzcpTKiKddFXbRsQUVu9yo2AFvA/WI2VG9vsSCzc2GxB17M4KI
FxsvmxPPpYxfJw5tYLkQ8+Mryojr/e/FEcey9Ffdxy7xmrhB7NI4uJ441946
ndg0L1OZmKr0I5vY8PdJXeJJF1caMa+s3I14i0JZBfG+XV5+xPZ0yWrif6jr
g4npO1++I86xu5BIrNiy9gOxbqbKLWJ/Hz86MbOFTiV+P1vbRpwujiwk1kqU
ZxE7yeiUE/8PB5ijSQ==
      "]]}}},
  AspectRatio->1,
  Axes->True,
  AxesOrigin->{0, 0},
  Frame->True,
  FrameLabel->{
    FormBox["\"\[CapitalPhi]2D\"", TraditionalForm], 
    FormBox["\"C0\"", TraditionalForm], None, 
    FormBox["\"C1\"", TraditionalForm]},
  FrameTicks->{Automatic, Automatic, None, {{1, 
      FormBox["0", TraditionalForm]}, {0.8, 
      FormBox["0.2`", TraditionalForm]}, {0.6, 
      FormBox["0.4`", TraditionalForm]}, {0.4, 
      FormBox["0.6`", TraditionalForm]}, {0.2, 
      FormBox["0.8`", TraditionalForm]}, {0, 
      FormBox["1", TraditionalForm]}}},
  Method->{"AxesInFront" -> True},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.4004979558761044`*^9, 3.400498033557805*^9, 
  3.400498065283424*^9, 3.400828933548624*^9, 3.4008403928162413`*^9, 
  3.400841196682144*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Finite Coverage", "Subsubsection",
 Editable->False,
 CellChangeTimes->{{3.4124094889657936`*^9, 3.4124095212722483`*^9}}],

Cell[TextData[{
 "We reinterpret the meaning of our expressions for the absolute contact \
states of two-dimensional networks as the fractions that can have the given \
contact state and weight these by the probability of contact ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[CapitalPhi]", "\[Infinity]"], "=", " ", 
    StyleBox["\[CapitalPhi]inf", "Input"]}], TraditionalForm]]],
 " to obtain the absolute contact states in networks of finite mean \
coverage:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4124095370649567`*^9, 3.412409553468544*^9}, {
  3.412409602068427*^9, 3.4124096055233955`*^9}, {3.4124096386009583`*^9, 
  3.4124097709412546`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Cc0", "=", 
  RowBox[{"Factor", "[", 
   RowBox[{"C0", " ", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[CapitalPhi]inf"}], ")"}], "C1"}], " ", "+", " ", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "\[CapitalPhi]inf"}], ")"}], "2"], "C2"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Cc1", "=", " ", 
  RowBox[{"Factor", "[", 
   RowBox[{
    RowBox[{"\[CapitalPhi]inf", " ", "C1"}], " ", "+", " ", 
    RowBox[{"2", " ", "\[CapitalPhi]inf", 
     RowBox[{"(", 
      RowBox[{"1", "-", "\[CapitalPhi]inf"}], ")"}], "C2"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Cc2", " ", "=", " ", 
  RowBox[{
   SuperscriptBox["\[CapitalPhi]inf", "2"], " ", "C2"}]}]}], "Input",
 CellChangeTimes->{{3.4005020273005247`*^9, 3.4005021050923843`*^9}, {
   3.4005021357765055`*^9, 3.4005021675521965`*^9}, {3.400829872779171*^9, 
   3.4008298844659758`*^9}, 3.4008350008830223`*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "cbar"], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "cbar"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"cbar", " ", 
      SuperscriptBox["\[ExponentialE]", "cbar"]}], "-", 
     RowBox[{"2", " ", "\[CapitalPhi]inf"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", "cbar"], " ", "\[CapitalPhi]inf"}], 
     "-", 
     RowBox[{"2", " ", "cbar", " ", 
      SuperscriptBox["\[ExponentialE]", "cbar"], " ", "\[CapitalPhi]inf"}], 
     "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[CapitalPhi]inf", "2"]}], "+", 
     RowBox[{"cbar", " ", 
      SuperscriptBox["\[CapitalPhi]inf", "2"]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", "cbar"], " ", 
      SuperscriptBox["\[CapitalPhi]inf", "2"]}], "+", 
     RowBox[{"cbar", " ", 
      SuperscriptBox["\[ExponentialE]", "cbar"], " ", 
      SuperscriptBox["\[CapitalPhi]inf", "2"]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.4008350064209857`*^9, 3.400840392886342*^9, 
  3.4008411968423743`*^9}],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", "cbar"], 
   RowBox[{"2", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "cbar"}]], " ", "\[CapitalPhi]inf", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", "cbar"], "-", 
      RowBox[{"cbar", " ", 
       SuperscriptBox["\[ExponentialE]", "cbar"]}], "+", 
      RowBox[{"2", " ", "\[CapitalPhi]inf"}], "+", 
      RowBox[{"cbar", " ", "\[CapitalPhi]inf"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", "cbar"], " ", "\[CapitalPhi]inf"}], 
      "+", 
      RowBox[{"cbar", " ", 
       SuperscriptBox["\[ExponentialE]", "cbar"], " ", "\[CapitalPhi]inf"}]}],
      ")"}]}]}]}]], "Output",
 CellChangeTimes->{3.4008350064209857`*^9, 3.400840392886342*^9, 
  3.400841196882432*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "cbar"}]], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "cbar", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "cbar"}], ")"}], " ", 
      SuperscriptBox["\[ExponentialE]", "cbar"]}]}], ")"}], " ", 
   SuperscriptBox["\[CapitalPhi]inf", "2"]}], "cbar"]], "Output",
 CellChangeTimes->{3.4008350064209857`*^9, 3.400840392886342*^9, 
  3.400841196912475*^9}]
}, Open  ]],

Cell["Again, we check that the fractions sum to unity:", "Text",
 Editable->False,
 CellChangeTimes->{{3.4124097812060146`*^9, 3.412409791400674*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Cc0", "+", "Cc1", "+", "Cc2"}], "]"}]], "Input",
 CellChangeTimes->{{3.4005021703962865`*^9, 3.400502181402112*^9}}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.4008376950971117`*^9, 3.400840392906371*^9, 
  3.400841196952533*^9}]
}, Open  ]],

Cell[TextData[{
 "We require the absolute contact states to be expressed in terms of the \
fractional contact area of networks with finite mean coverage, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[CapitalPhi]", "c"], TraditionalForm]]],
 "= ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", " ", 
    SubscriptBox["\[CapitalPhi]", "\[Infinity]"]}], TraditionalForm]]],
 ", where ",
 StyleBox["f",
  FontSlant->"Italic"],
 " is the fraction of the fibre surface available for contact as derived in \
Section 4.3.1"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412409834092061*^9, 3.4124099473449106`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"f", " ", "=", " ", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"P", "[", "0", "]"}]}], ")"}]}], " ", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", "-", "1"}], ")"}], "/", "c"}], " ", 
        RowBox[{"P", "[", "c", "]"}]}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"c", ",", " ", "2", ",", " ", "\[Infinity]"}], "}"}]}], 
      "]"}]}], ",", " ", 
    RowBox[{"cbar", ">", "0"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalPhi]inf", " ", "=", " ", 
   RowBox[{"\[CapitalPhi]c", "/", "f"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.400837772458352*^9, 3.4008377726686544`*^9}, 
   3.4008386014203405`*^9}],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox[
   RowBox[{"EulerGamma", "-", 
    RowBox[{"ExpIntegralEi", "[", "cbar", "]"}], "+", 
    RowBox[{"Log", "[", "cbar", "]"}]}], 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["\[ExponentialE]", "cbar"]}]]}]], "Output",
 CellChangeTimes->{3.400838929401955*^9, 3.400840394348445*^9, 
  3.400841198254405*^9}]
}, Open  ]],

Cell[TextData[{
 "In the limit as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[CapitalPhi]", "c"], " ", "\[Rule]", " ", "f"}], 
   TraditionalForm]]],
 ", we recover the expressions for two-dimensional networks:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4124100275902977`*^9, 3.4124100589954557`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Limit", "[", 
  RowBox[{"Cc0", ",", " ", 
   RowBox[{"\[CapitalPhi]c", "\[Rule]", "f"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Limit", "[", 
  RowBox[{"Cc1", ",", " ", 
   RowBox[{"\[CapitalPhi]c", "\[Rule]", "f"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{"Limit", "[", 
   RowBox[{"Cc2", ",", " ", 
    RowBox[{"\[CapitalPhi]c", "\[Rule]", "f"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.400834174094158*^9, 3.4008342389474125`*^9}, {
  3.400834275590102*^9, 3.4008342807875757`*^9}, {3.4008390618423953`*^9, 
  3.4008390715663776`*^9}}],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"-", "cbar"}]]], "Output",
 CellChangeTimes->{{3.4008341922903233`*^9, 3.4008342394481325`*^9}, 
   3.400834281148094*^9, {3.400839043085424*^9, 3.400839085716725*^9}, 
   3.4008403949893665`*^9, 3.4008411989253693`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "cbar"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "-", "cbar", "+", 
     SuperscriptBox["\[ExponentialE]", "cbar"]}], ")"}]}], "cbar"]], "Output",\

 CellChangeTimes->{{3.4008341922903233`*^9, 3.4008342394481325`*^9}, 
   3.400834281148094*^9, {3.400839043085424*^9, 3.400839085716725*^9}, 
   3.4008403949893665`*^9, 3.4008411992758737`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "cbar"}]], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "cbar", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "cbar"}], ")"}], " ", 
      SuperscriptBox["\[ExponentialE]", "cbar"]}]}], ")"}]}], 
  "cbar"]], "Output",
 CellChangeTimes->{{3.4008341922903233`*^9, 3.4008342394481325`*^9}, 
   3.400834281148094*^9, {3.400839043085424*^9, 3.400839085716725*^9}, 
   3.4008403949893665`*^9, 3.4008411995763054`*^9}]
}, Open  ]],

Cell[TextData[{
 "and in the limit as ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["c", "_"], TraditionalForm]]],
 " \[Rule] \[Infinity], we obtain the expressions for networks of infinite \
mean coverage:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412410064032699*^9, 3.412410122807213*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Limit", "[", 
  RowBox[{"Cc0", ",", " ", 
   RowBox[{"cbar", "\[Rule]", "\[Infinity]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Limit", "[", 
  RowBox[{"Cc1", ",", " ", 
   RowBox[{"cbar", "\[Rule]", "\[Infinity]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Limit", "[", 
  RowBox[{"Cc2", ",", " ", 
   RowBox[{"cbar", "\[Rule]", "\[Infinity]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.400834174094158*^9, 3.4008342389474125`*^9}, {
  3.400834275590102*^9, 3.400834305603259*^9}, {3.40083434848492*^9, 
  3.4008344327961535`*^9}}],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "\[CapitalPhi]c"}], ")"}], "2"]], "Output",
 CellChangeTimes->{3.4008393092781906`*^9, 3.4008404070366898`*^9, 
  3.400841210201584*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "\[CapitalPhi]c"}], ")"}], " ", 
  "\[CapitalPhi]c"}]], "Output",
 CellChangeTimes->{3.4008393092781906`*^9, 3.4008404070366898`*^9, 
  3.4008412160299644`*^9}],

Cell[BoxData[
 SuperscriptBox["\[CapitalPhi]c", "2"]], "Output",
 CellChangeTimes->{3.4008393092781906`*^9, 3.4008404070366898`*^9, 
  3.400841218173046*^9}]
}, Open  ]],

Cell[TextData[{
 "We now plot the contact state diagrams for networks of finite mean coverage \
",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["c", "_"], "=", 
    RowBox[{"5", " ", "and"}]}], TraditionalForm]]],
 " ",
 Cell[BoxData[
  RowBox[{
   OverscriptBox["c", 
    RowBox[{" ", "_"}]], "=", "10"}]]],
 ". We plot the case of infinite mean coverage using dashed lines:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4124101421850767`*^9, 3.4124102215692253`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsArray", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"1", "-", "Cc1"}], "/.", 
            RowBox[{"cbar", "\[Rule]", "5"}]}], ",", 
           RowBox[{"Cc0", "/.", 
            RowBox[{"cbar", "\[Rule]", "5"}]}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"\[CapitalPhi]c", ",", " ", "0", ",", " ", 
           RowBox[{"f", "/.", 
            RowBox[{"cbar", "\[Rule]", "5"}]}]}], "}"}], ",", 
         RowBox[{"Filling", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"1", "\[Rule]", 
            RowBox[{"{", "2", "}"}]}], "}"}]}], ",", " ", 
         RowBox[{"FillingStyle", "\[Rule]", "LightGray"}]}], "]"}], ",", " ", 
       
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", "\[CapitalPhi]c"}], ")"}], "2"], ",", 
           RowBox[{"1", "-", 
            RowBox[{"(", 
             RowBox[{"2", "\[CapitalPhi]c", 
              RowBox[{"(", 
               RowBox[{"1", "-", "\[CapitalPhi]c"}], ")"}]}], ")"}]}]}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[CapitalPhi]c", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Dashed"}]}], "]"}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", " ", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", "  ", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<\!\(\*SubscriptBox[\"\[CapitalPhi]\", 
StyleBox[\"c\",
FontSlant->\"Italic\"]]\)\>\"", ",", " ", "\"\<\!\(\*SubsuperscriptBox[
StyleBox[\"C\",
FontSlant->\"Italic\"], \"0\", 
StyleBox[\"c\",
FontSlant->\"Italic\"]]\)\>\"", ",", "None", ",", "None"}], "}"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{
       "PlotLabel", "\[Rule]", 
        "\"\<\!\(\*OverscriptBox[\(c\), \(_\)]\)=5\>\""}]}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"1", "-", "Cc1"}], "/.", 
            RowBox[{"cbar", "\[Rule]", "10"}]}], ",", 
           RowBox[{"Cc0", "/.", 
            RowBox[{"cbar", "\[Rule]", "10"}]}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"\[CapitalPhi]c", ",", " ", "0", ",", " ", 
           RowBox[{"f", "/.", 
            RowBox[{"cbar", "\[Rule]", "10"}]}]}], "}"}], ",", 
         RowBox[{"Filling", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"1", "\[Rule]", 
            RowBox[{"{", "2", "}"}]}], "}"}]}], ",", " ", 
         RowBox[{"FillingStyle", "\[Rule]", "LightGray"}]}], "]"}], ",", " ", 
       
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", "\[CapitalPhi]c"}], ")"}], "2"], ",", 
           RowBox[{"1", "-", 
            RowBox[{"(", 
             RowBox[{"2", "\[CapitalPhi]c", 
              RowBox[{"(", 
               RowBox[{"1", "-", "\[CapitalPhi]c"}], ")"}]}], ")"}]}]}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[CapitalPhi]c", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Dashed"}]}], "]"}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", " ", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", " ", 
       RowBox[{"FrameTicks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "None", ",", " ", "None", ",", " ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", " ", "0"}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{".8", ",", ".2"}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{".6", ",", ".4"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{".4", ",", ".6"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{".2", ",", ".8"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<\!\(\*SubscriptBox[\"\[CapitalPhi]\", 
StyleBox[\"c\",
FontSlant->\"Italic\"]]\)\>\"", ",", " ", "None", ",", "None", ",", 
          "\"\<\!\(\*SubsuperscriptBox[
StyleBox[\"C\",
FontSlant->\"Italic\"], \"1\", 
StyleBox[\"c\",
FontSlant->\"Italic\"]]\)\>\""}], "}"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{
       "PlotLabel", "\[Rule]", 
        "\"\<\!\(\*OverscriptBox[\(c\), \(_\)]\)=10\>\""}]}], "]"}]}], "}"}], 
   "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.4008300299752083`*^9, 3.400830058035557*^9}, {
   3.400830119624117*^9, 3.4008301476343937`*^9}, {3.40083017773768*^9, 
   3.4008302123274174`*^9}, {3.400830295957672*^9, 3.4008303859971423`*^9}, {
   3.400837794449974*^9, 3.4008378021109905`*^9}, {3.400837867244648*^9, 
   3.4008379827907953`*^9}, 3.400838061193533*^9, {3.400838119146866*^9, 
   3.400838168778232*^9}, {3.400838200994557*^9, 3.400838205200605*^9}, {
   3.400839870104619*^9, 3.400839875201949*^9}, 3.400840022744104*^9, {
   3.400840087767603*^9, 3.400840222691614*^9}, {3.400840273694954*^9, 
   3.4008403353135567`*^9}, {3.400841136145096*^9, 3.400841157175336*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdWHk0Ve33R0KKkAyh5JWUkvAS0c4QEjJPmTJc1CWSinsrVMSrSCFCNBhK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        "], {{{}, {}, {}, {}, {}, {}, {}, 
          {GrayLevel[0.85], EdgeForm[None], 
           GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwl1Hecz3UcwPEf2dvZ8+64YW9nHs52zt05W7IzipMkRMpuoowys5W9CVml
jMpsWhVCqCgZFZ4//nh+X4/396/v4/N+fL7hPQelpKYNBAJp6OyRnbYk0oIm
NKQBOchJLnITQh7yko/8FKAghShMEYpSjOKEEkY4JShJBJFEEU0pSlOGspSj
PBWoSCUqU4WqVKM6MdSgJrWoTR3qEks92pFEPE1pRBztSaYlzWhMB1qTQHM6
kkIrOtEmzeMzqx/8DueXTU9oOl2kh/mPEcxiH3/RicG8w3auEkcSfZnEOn6m
CpWpREUqUJ5ylKUMpSlFNA1IpA8TWctPRFGfVjzNBNZwjkg68hxT+ZjfqEcC
vRnPas4SQQcGMYVtXCGWlvRiHKs4Q0nak8pktnKZugxlBrv4g3jmsp9/6MlY
VnKaEizkEP8ynPfZy03aMZ8vuMNAvuI+b7OFS9ThGGnt6gPNpAf0Li+Qxfy1
PmA6Gcyf6O+0IKv5aPDe6BzNqJ/pLXqQ2fyl/s8Y0ptX6CnCOc4T3i3Qg9xj
GEcCgUeX8T3Zww3aMo/Puc0A3mIzv1KbIUxjJ9dpzmw+5W+68yof8SNhvMhM
dvMnbXiWN9nERWrxPO+yg2s0oxuv8CE/EEoKz/AGG7lATZrSldEs53uK05r+
vM4GzlODJjzFyyzjO4qRTD9eYz2/EENjujCKpXxLUarTiCcZyRK+oQiFKURB
CpCffOQlDyHkJhc5yUF2sgV3T5bgjskU3D0ZgjsmXXCvBP+p1WhIZ15iMScf
rzfwEK4Tkes=
             "],
             VertexColors->None]]}, {}, {}}, {{}, {}, 
          {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl1FWUFlQUgNFhGGbGISREGkFCSunuklLAoUEQhw7pbhCVBqVFUunuBgnp
7pDu7s79Lx72/da5D/flrHVTR7WObBUtKCgoliPQI/xNN2pTglwEE50QYhBK
GOF8RAQxA+8Qmzh8TFziEZ8EfEJCPiURiUlCUpJxlH/oTh1KkpvkHGM6Pfie
UuThIosZQFMqk4LjzKAndSlNXi6xhIE04ztScoKZ9KIeX5OPyyxlEM2J5DNO
Move/EAZbrOWP2hHfq6wjMG0oAr32cgYOpGKU8ymD/V5zBb+pCx3WMdI2lOA
qyxnCC15xjYmUpUH/MtYAgveL515yU6mBPbq/pCm5jRzAjt211ffsCewY/OP
+oSthJknBJ7UA4Hdazm9y3pCzaP0HfuIMHfQF+wg3DxZg/WgFuQaKxjKW/by
E8/ZziSq8ZBNjKMLr9jFVD7nf+bSjyie8h9/UZ57bGA0HSnEdVYyjFZUJw1n
mMfPNKAChbnBKobTmhqk5Szz6U9DvqEIN1nNCNpQk3ScYwG/0IhvKUp6zrOQ
X2lMRYrxBRnISCYyk4Uv+YqsZCM7ObjAIn6jCZUozi3W8DttqcUjNjOerrxm
N9MIsavDQR/+ipz6Hq8jgZw=
            "]]}, 
          {Hue[0.9060679774997897, 0.6, 0.6], 
           LineBox[{269, 340, 334, 329, 325, 322, 320, 270, 271, 272, 273, 
            274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 
            287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 
            300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 
            313, 314, 315, 316, 317, 318, 341, 335, 330, 326, 323, 321, 342, 
            336, 331, 327, 324, 343, 337, 332, 328, 344, 338, 333, 345, 339, 
            346, 319}]}}}], {{}, {}, 
        {Hue[0.67, 0.6, 0.6], Dashing[{Small, Small}], 
         LineBox[CompressedData["
1:eJwV13k0ldsfBnDJmH7GEJJLKpVwJUPyPkRJJCJSMiWSilCmhIzJVEniVtyU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          "]]}, 
        {Hue[0.9060679774997897, 0.6, 0.6], Dashing[{Small, Small}], 
         LineBox[CompressedData["
1:eJw12Hk8VOsbAHAGUcpWEi2WkNCG0oLHRZYQQpakruIiFKlQLrpkCakQIWup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          "]]}}},
      AspectRatio->1,
      Axes->True,
      AxesOrigin->{0, 0},
      Frame->True,
      FrameLabel->{
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\\"\[CapitalPhi]\\\", \\n \
StyleBox[\\\"c\\\",\\nFontSlant->\\\"Italic\\\"]]\\)\"", TraditionalForm], 
        FormBox[
        "\"\\!\\(\\*SubsuperscriptBox[\\n StyleBox[\\\"C\\\",\\nFontSlant->\\\
\"Italic\\\"], \\\"0\\\", \\n \
StyleBox[\\\"c\\\",\\nFontSlant->\\\"Italic\\\"]]\\)\"", TraditionalForm], 
        None, None},
      Method->{"AxesInFront" -> True},
      PlotLabel->FormBox[
       "\"\\!\\(\\*OverscriptBox[\\(c\\), \\(_\\)]\\)=5\"", TraditionalForm],
      PlotRange->{{0, 1}, {0, 1}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], {192., -189.}, ImageScaled[{0.5, 0.5}], {360., 360.}],
     InsetBox[
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdWHc4lf8btveKMrJHEkLRkjyRVEaJtqSsiLKlKFklFUKiRLL3TkaypSQr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        "], {{{}, {}, {}, {}, {}, {}, {}, 
          {GrayLevel[0.85], EdgeForm[None], 
           GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwl1HeciHUcwPGjS4m44+x5xuHOnb3HmWec4+5wdxzJpkFSVrJpGJU9y2gY
ZRZFQ2XvhmiJECJZJWS8n5c/3s/n9fu9Xs/r9bye7/P8InsMTB2QNSQkJAtd
XcJIJ4U2tKQ5TQknD3mJIB/5KUBBClGYIhSlGMUpQUkiKUVpylCWKMpRngpE
E0NFYomjEpWpQlWqUZ0a1KQWtalDXepRnwY0JJ5GNCaDVJJoRQLN6ER72tKa
FnSmA+1IJJOOJNOFtCz331mT4Jm8v9x6WLPp27qfO7zAQrbzL515lhl8yl80
IYX+vMoGTlGVKlSmEnHEUpEYoqlAecoRRVnKUJrGJNOPV1jPSUrRiHb05WXW
8TuRxNOWPrzEWk5Qkk4MYjpbuEBDkujNJNZwnBJk8AxvsJnzNGAoc/mSK7Sh
FxNZzW8UZwQL2MY/pDOQ1/mEP6nPEOawlcsk8iY7+Y+eTOADjlGMZezjNsP5
hqzmN1+z69d6jTQetf5OQ3WxPqK79SYDyGl9UIOf6TV5SD/Wc9Qjl/X3+qAu
0Ry6R2/xPIeCW+3N1of1C71Ea77lAXuLdAfX6cEB7jKe9/mVoixlL/8zjHl8
xVU68ha7uMHTTGMTZ6nLc8zic/6mFd0Zxyp+oQgdeIqpbOQMdRjMTD7jIi15
nLGs5GcK054nmcJH/EFtWtCNMazgJwqRyhNM5kNOU4sEHmM0y/mRgtSkOV0Z
xXscpQA1aEYXXuRdjpCffESQlzyEE0buYI7BtxDMO5hh8B2QPZhZMHOyBTMm
NJgZwflanaZkMpJ3+CHk/rl7D9GqkwU=
             "],
             VertexColors->None]]}, {}, {}}, {{}, {}, 
          {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl1FW4FlUAhtH/UHKQkJYO6ZaQRrpbSkpKurtBuhWklG6kS1pBGgw6DKS7
u2MNXKx5nz0Xc/PtZ1I16VC9fVgoFIrlEfQEC+hLPUqQmwhEJBKRicIHRCWc
aHxIdGIQM/gmHxGbOMQlHvFJwEkW0o/6lCQPCTnFIvrTgFJ8xsf8zWIG0JDS
5OUS6xhNa6qTiH/4iYF8RRnycZmfGUMbviAx/7KEb2hEWW7zCxPpQn6usJ6x
tKUGSfiPpQyiMeW4w69MoisFuMoGxtGOZ+xjFjV5wA5+oCcv+Z25JOU0yxjM
G/6iCU/Yw4xgM6Me0fLcZVuwmXeTNUwPaTdecCDY0Ls5wcZ6LNhRC+o1Ngab
O38bCr27LAeDvbW9Pmd/cA+cZ2skPRrcBa2lD9lJuPOPGkEPay9e8QfzSMb/
LGcITXnKXmZSgXtsZwrdKcR1NvEdHajNI3Yxjd4k5wwrGEozKnKf35hKDwpz
g82MpyN1SMFZVjKMr6lEEW6yhQl04ktSco5VDKc5lfmcVJxnNSNoQRWKkpoL
rGEkLalKMT4hDWlJR3oykJFMZCYLWclGdnLwKTm5yFpG0YpqFOcWW/meztTl
MbuZTh9e8yfziWK/46H3/41c+hbD9oHM
            "]]}, 
          {Hue[0.9060679774997897, 0.6, 0.6], 
           LineBox[{272, 343, 337, 332, 328, 325, 323, 273, 274, 275, 276, 
            277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 
            290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 
            303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 
            316, 317, 318, 319, 320, 321, 344, 338, 333, 329, 326, 324, 345, 
            339, 334, 330, 327, 346, 340, 335, 331, 347, 341, 336, 348, 342, 
            349, 322}]}}}], {{}, {}, 
        {Hue[0.67, 0.6, 0.6], Dashing[{Small, Small}], 
         LineBox[CompressedData["
1:eJwV13k0ldsfBnDJmH7GEJJLKpVwJUPyPkRJJCJSMiWSilCmhIzJVEniVtyU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          "]]}, 
        {Hue[0.9060679774997897, 0.6, 0.6], Dashing[{Small, Small}], 
         LineBox[CompressedData["
1:eJw12Hk8VOsbAHAGUcpWEi2WkNCG0oLHRZYQQpakruIiFKlQLrpkCakQIWup
yJaS7KEku8o2M+fMjOyMiqRSv2f++P11Pt/5nPOe8573Wd4zsi5nj7hSuLi4
VnNzcXGOh1zHuuvHbXX2wNqJP3/YwKsvdY6Q1ADlY1umF3+wQT0zJf2ppAFU
2e99OTfPBtP2vrIMSRso++5QNjXJBrvTCzW3JE/D/Ls0qZE+NtB2ROrHSfpD
d53ku9/FbMgSt7gWIxkOBPV3wZuTbAgTeLolWjIRLKa8vSuaZsDeIbt49nMe
FFWoC20LngbBP2FORpuKYYWofk61/RQoWM2MNV4vh4YvfvV3DCfhUsc+SJmr
BLPcqXcHVSZAolyUzs1dB4eSihSEd47Dc6Z+W6fWKziy7GGT+vYxeOWZsd5h
qgnquydvpcEozCtqCz/xfgNqf3+JW+UzApTFApH1Cq1wOItpx536Cfb8Ofnc
uqgNBnjSlc8Sw9AWrtHxWrkT7l0tHP6zexikEyYXH810Qd5ZLj6FWBZMLhD0
Dzt7QGCZRNmbH0zIm6hqFYrvhcZnhywizjBBaGM+e3j4PfS0hrQ4TTMg1uOZ
W5b8RzClTX3ICWfAN92CYfeQPnhllC+vJMuA6rzJtEvhfcBz1j2mS5oBVwVU
ra9F98H7e2+rAzcxQKirsCH3dh8or/OK7FjPAMUTRffo+X2Q7burPGwtA44G
l9rbdPVBdV3NGaGVDHhWWdEGsv2Q00I90rBAgr9aU/naxn7QitPgjusmwU1D
JutmSz9YSnhtsewiwX7PlesrO/rhmt0n7TWdJBzYr+FCGeiHoz/SD2S2kUDR
yxOememH8LcyQfVvSLhhFe7ZLDUA6+ODeHbWkvD4nIGMv98AaJRcNGosICHd
L0uQfWkAzv0evpD3mIQ4/1/fPIIHoIOSlHjtEQnnAsrbT0QNwNS2lznm+SRo
hspfNr03AC9WSVJGc0housH7Ua51AKK/KrUb3iWBKGq63i07CJL2NxNfRpPQ
Nc07pbZlEFK1Fy7URpFQr3rQLFF1EN5HftVpjCQh63HzSjvNQbh8qDiyM4IE
lwev46hmgxAVpT73JYyEkYyWG6OXBiFv1GefaxAJ07Ftt5faB6F/V6n/whkS
6O9Wzjn3DkJxEct4HbpjhblNff8g6CYU8u73JKEoqn3Nf6xBuBnGrR7qjvMJ
70gSWByEuQ0vPCVcSZi73HVntfwQVO6xN/R1JuGn5/u0rUFDYPDtVFGPFQk2
e47f3B4yBGUHtC5uRBdyj1xTDx+CTK4cfg9LEpxTFny144dgVmBtJMWChIZm
KWOrnCEIWJ31XceMhEiZv+cCWodASkTrAc2QhNUfp81apKiQn39bpUyLBK/s
i3rt0lRoo65XWItu8vqj2SNPhbM3d40FHSDhIo/oZup2KmwP5HtnuJ+EgZ0a
i2w9KtzSs+AZ0yQh83rQfYkzVJiq9tSxVCdB5S/+325VVBizaKBXKJNQ8rhg
S389FWLSe4SU0RprLK1MXlOBKtWtkrGVBK3RlDyVbiokFiapXlMi4XCcsuns
CBUM5bVNTimS4DdgnhIoRoMXp/nYJnIkfNP70jAhQYOTbePTrbIkXC5Mnjy2
kQaVrlUDZujwEEJHR4kGQdsUA6xlSEhW8P1E0aGBrqhU15lNJFT6JqrFetCA
tvXyVIsUCTpDe52WfGgQU6j20h79yoAW4eNPg7GTff7jkiS0SigOWIbQoNx5
rGQVmlpTESKeRIMbRUoGf0uQwLViqO1ePQ1sM+X6NNaQYJQj+0+pBB1km38W
xQnhfFOEFF9voEMv3TVOFy0T/3N4UJYOReIO++dWkfAj8IMLryodqIODf46j
n1hFO9vp0kGy0XTfgZW4XtyfbZfc6SAjyHLdsALvt0BbI+ZDB5sFuip1OQlT
U629iufpUMZ1+lU6+nV/npVlMB1GPJc7yKADS+zNc2/SYVdGg8YuAcyPE/UG
Ji/pYBk4ej9wGQlttk94nOvoILD3gq0h+oXp3Vd+TXSYWB3buxp9S9NfN72D
DvKbbQ+U8pFwUFhJi82kw+VMm8p5XhLU+MR/8ozR4aKRCq0Fvekn98t103RI
WXm9Mx39fWRIU2+BDkdnPkkboQtqb6gnCRJQLrz87H0eElLKr3x5JEIAO0uJ
PwQd/tijtFacAGuLbm8HtHOy/o4xaQISeWofiKBFfRaUD2gQsPCW900UhYTf
p4bHLfYRcMHAu9cdPeHQ/fC0DgFSVOciE3TTwQLFeGMC6C60zlXoSxtPyDGc
CDDuMGrI5MZ8t9x5lPo3AZ8tleuvoQ//xx3T50bAhpq4CB+04nju5/ZzBCxa
9Z3SRYttuKDw9gIBhUE1V5TRS4cNHZqCCCBj5Z3E0e/Lx+pfhhPQ433BZ5oL
681o5dyzaALitU5kD6ILpK4rlcYT0Db39m4L+mrotoT8FAK6ZOUYD9A+T383
5mQQkJwsvP0O2mGkcyEjB59/LvivKPROM78TiYU4f29alRd6Q4j+7RulBLyO
6pA7ieYvW/Mm5jnOP07X0gb9ZfjTj4gqAmaC1A1M0HSJiu1h9QQYHMn/rYNu
PRTlcqWZgE2r00N2o58FOyRfaiUgqEb0jSo6q0S51a+TAHsrgQ/y6FjWzyXv
9wRUdoQ82ogOWNu+y2OAgPTdAQYS6FMm91xP0wmgXPt8XxR9+MrZ1BMsAibq
JttXovcX67Y7jhFgy3KrFkArMkW5j04ToDfr4suHFhVnaVh9IaB0hJiioH8Z
lbubLRCQ+5q2nRs9FhSRbvSLgHUJTppc6ImjKu7ZeBTSd1rG8cnZ1RRpjJMo
gprG8cfoX2npGLfhrvQFzvWmmz/tlsI8oHw4KcXLWZ/q9s47mFeU7ad5+NF7
jj73EMc8jDg3VrYCXci+x3NbmMT6Na0kjJaLjswQEcM4KDvvugadIndOMx7z
fmNpkLsU5zmq7bsFsS48TqWoyaLDbf86E411o/KM4Csl9OLMVj7+DfgcW5LW
7eKsd5RYZjjWpRNtmbv3o4dlf+6lYB375qgiaYDusmnzWlLA8TSa1R3RhjPl
yy5jnWwJ6fV0Q1dHZmR9x7rqXu7ifh6d/9Ln/dcdGCeDPBU3OPFhY+fjq4Z9
+524QCb61jQIsDVwvg8eShej/5UR1ZrYx4kLq5xu9Fzl4od/sA+IFLutGkZ7
WjPPftLBPNqxpLOAtr32NJfUJ6FsunBeGuNddcpWsM8c+9wxidIg9Asbs7oY
7EublVTPJaH1a/TO61iTwE4k1pWiHeN3DN23JyHeQm7LJDp65/IC/1MkMI0l
ND0xP9ek/nFWcsP3u05WPxadxf1NjIp9MzXy7d5i9IseZpC+D9ZJo2/kAnrE
v/qQWCD2ZdM6+URcdz9a2e/myyT0b6wNrkEvHXxUFvgvCVIJx+pH0WskkqUY
/5GQZ+tHAaxH+pVnJ4rj8T2fFg76js5akosxz8P4uc2veQfrn6qbpA437jvG
PWe3dqIrOoS/lOO+JIt5aZkAP/b7zF8OG4pJWPvU5coV9NJfH7dOVpIg2Z9/
7BzGmeO16LdRuE8KU5sd/Q/jbGQmJFirhwQ74Ub/VrSv3cVds+8xTmI1JkUF
8b5Kp1LtBvG8f74m5qKft2p5KH7COM0hh7o5/UB4VqDpB8a1UqCmI8ZlT01M
pMkSrqd3yYNH6FteCss6/5Awe8eRsYgWa3XkGeRlgFgOf2W6CDqieYktxADf
yKbPk6K4zj/vflm/mYH15m1UCcZx16PdvtkKDBg23FG8UpyEBPsutqISA+Zp
/NkeaOHnfNO7tjHAqV50VGEtxrvvuVEjTQYYHI36lY9xv3L0IPW8KQOCX3OZ
92A/bUsiHRfNGTDDTFQ+sB7rh8HlgX8tGSAzktabhxbMKfkYbcuAtixKVBDm
xYrj67szTzAARtWCdmBeCPTONr87z4CYF5vC6zAveOvSijenM6DWa/P2ANw/
DGoZGBP3GECp4j/Lh3lQ/HKKvJvNgMceo/duox2fa4uJ5TNAeSzlXZkKCaVP
CH+uMpyfR5P9r23YX9I376e9YYBxqLZeNebJi8CCpuSvDHj7vcKKjXkQv2B9
/Mg3BhRYC/jd1cb6duHX/KpFBnwRsgkz1OHM33xLxG8GFD+geWUDCa7u7Ojz
y5kw4lh5yUUP37eduoWlNBN0P95yEjUm4YxG1cByUyYUrutwkbPBde36UPjC
nAmPYwWejaLFvWdD/rFkQi0ldfqJLQl19xUUm22ZoDJfJapth+svkeAXepIJ
Il+XK7o5klC1eFpw4QITllu//pd1Et9nnZD2cBYTanLrZ2MwTwpMXLJqvzFB
OarqY2ws7kdUZXVgkQlNq2YTguJIqBUih+p+MqF7T+RqD04e9B6XaOBigfF5
mq9xAtaD4w7xjStY8CBp622RRNwv+VleadnEAvlQXffXaXj+XR37HkMWKE+5
O7Xgfn5+UkpkJJkFjjJ5XgodJCRmjL5JT2VBnpnbneOYB+oW5SHW6Tje3e4n
yfg94Vtmzq7PZsHHtNwMwV7M44DQjrRCFrDUdkdz9ZPwiW8k1uoVC54/FUpY
yyThg3Tp8pppFuhwpTl9/Yb9ytqIJ9FgGFqb1n0+i3EcYhyRWT4yDDdHc0n7
UAbI0g7150Z8ArXAh9nMUQbs1wxPlFQbAQMTL+Gdbkxw2tS5yN07Ar9MA0Bm
nAnzrXHMc2GjYFySMe8QwYIUXmf/I/JjUHtHbDxPfhhW05/lUJrG4Hu5MetU
+zDwBYfZ7PMdh/Cah5Vhtz4B1yPnYqbYBMxGt90vtRsBv7vFcWKvJkBudIP6
2wOjUKMSJSDqMwm5RZRkM+UxED3kp3pVaAr6TdI9u8THgbqtqzewegqyQkxm
XTZPQMk9kB92noaOo4ahrqqTcLx4j+jG39NQoi4i8VRrCkIjssOoj2dgXO/K
FTm/aXgytjFNyIwNVXz507xZM2AlKrT3DX6na6a5yCfg93kMH2U9FX2hpJFa
iW5anF+aRWeaH0tiofcwaY1SP9nwRHo7v+Y3Nkg9fWLhg26Wc5mmoZk25v+I
/2IDmcfTpPKdDf4pscmnltjQmKJ6l3OfJ7GhgQFo4wJnh8/okVB/pzh0xcE3
69bjOPYeTnIVaBsxrRTOuNr7VYtW/GbD9RXlqZxxl1HfNZeiGRdpDzjjQlfd
w9fo5QIBHpxxApqeXh9Cb5A1UeWMM1GYZsX3hw1ck/FlnHE6gs/Q7NGNtIcN
nHH4/U7Ue6O1ixYiONfpulnnXkXnLAs+xLmu7PABj0I8brVQec+5blJvh1kD
Hs3BJpVznrzm5h0f8ehY8dSZc56zioTYJB5tKkzkOb/fkRac5/wv8v//R/4H
376kqQ==
          "]]}}},
      AspectRatio->1,
      Axes->True,
      AxesOrigin->{0, 0},
      Frame->True,
      FrameLabel->{
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\\"\[CapitalPhi]\\\", \\n \
StyleBox[\\\"c\\\",\\nFontSlant->\\\"Italic\\\"]]\\)\"", TraditionalForm], 
        None, None, 
        FormBox[
        "\"\\!\\(\\*SubsuperscriptBox[\\n StyleBox[\\\"C\\\",\\nFontSlant->\\\
\"Italic\\\"], \\\"1\\\", \\n \
StyleBox[\\\"c\\\",\\nFontSlant->\\\"Italic\\\"]]\\)\"", TraditionalForm]},
      FrameTicks->{Automatic, None, None, {{1, 
          FormBox["0", TraditionalForm]}, {0.8, 
          FormBox["0.2`", TraditionalForm]}, {0.6, 
          FormBox["0.4`", TraditionalForm]}, {0.4, 
          FormBox["0.6`", TraditionalForm]}, {0.2, 
          FormBox["0.8`", TraditionalForm]}, {0, 
          FormBox["1", TraditionalForm]}}},
      Method->{"AxesInFront" -> True},
      PlotLabel->FormBox[
       "\"\\!\\(\\*OverscriptBox[\\(c\\), \\(_\\)]\\)=10\"", TraditionalForm],
      
      PlotRange->{{0, 1}, {0, 1}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], {576., -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.400839541381939*^9, 3.400840416229909*^9, {3.4008411383783073`*^9, 
   3.4008411586875105`*^9}, 3.4008412192245584`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{616, 750},
WindowMargins->{{55, Automatic}, {Automatic, 69}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 110, 2, 73, "Title"],
Cell[703, 27, 222, 3, 36, "Subtitle"],
Cell[928, 32, 148, 2, 29, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1101, 38, 130, 2, 75, "Section"],
Cell[CellGroupData[{
Cell[1256, 44, 154, 3, 27, "Subsubsection"],
Cell[1413, 49, 772, 19, 101, "Text"],
Cell[2188, 70, 366, 8, 62, "Input"],
Cell[2557, 80, 449, 12, 65, "Text"],
Cell[CellGroupData[{
Cell[3031, 96, 623, 15, 41, "Input"],
Cell[3657, 113, 306, 7, 56, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4012, 126, 156, 3, 27, "Subsubsection"],
Cell[4171, 131, 455, 11, 65, "Text"],
Cell[CellGroupData[{
Cell[4651, 146, 808, 19, 62, "Input"],
Cell[5462, 167, 673, 18, 55, "Output"]
}, Open  ]],
Cell[6150, 188, 222, 6, 30, "Text"],
Cell[CellGroupData[{
Cell[6397, 198, 372, 9, 41, "Input"],
Cell[6772, 209, 453, 9, 40, "Output"]
}, Open  ]],
Cell[7240, 221, 386, 10, 47, "Text"],
Cell[CellGroupData[{
Cell[7651, 235, 447, 11, 41, "Input"],
Cell[8101, 248, 268, 5, 40, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8418, 259, 213, 3, 37, "Subsection"],
Cell[8636, 265, 665, 19, 69, "Text"],
Cell[CellGroupData[{
Cell[9326, 288, 885, 21, 84, "Input"],
Cell[10214, 311, 375, 10, 60, "Output"]
}, Open  ]],
Cell[10604, 324, 402, 12, 50, "Text"],
Cell[CellGroupData[{
Cell[11031, 340, 840, 21, 86, "Input"],
Cell[11874, 363, 351, 9, 60, "Output"]
}, Open  ]],
Cell[12240, 375, 207, 7, 29, "Text"],
Cell[CellGroupData[{
Cell[12472, 386, 312, 6, 43, "Input"],
Cell[12787, 394, 341, 8, 56, "Output"]
}, Open  ]],
Cell[13143, 405, 305, 6, 65, "Text"],
Cell[CellGroupData[{
Cell[13473, 415, 482, 12, 62, "Input"],
Cell[13958, 429, 557, 16, 55, "Output"]
}, Open  ]],
Cell[14530, 448, 496, 12, 51, "Text"],
Cell[CellGroupData[{
Cell[15051, 464, 322, 7, 43, "Input"],
Cell[15376, 473, 675, 18, 60, "Output"]
}, Open  ]],
Cell[16066, 494, 263, 5, 47, "Text"],
Cell[CellGroupData[{
Cell[16354, 503, 299, 8, 41, "Input"],
Cell[16656, 513, 565, 16, 60, "Output"]
}, Open  ]],
Cell[17236, 532, 214, 5, 47, "Text"],
Cell[CellGroupData[{
Cell[17475, 541, 250, 4, 41, "Input"],
Cell[17728, 547, 479, 13, 55, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18244, 565, 256, 6, 41, "Input"],
Cell[18503, 573, 2126, 40, 242, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20678, 619, 215, 3, 37, "Subsection"],
Cell[20896, 624, 437, 11, 65, "Text"],
Cell[CellGroupData[{
Cell[21358, 639, 692, 20, 62, "Input"],
Cell[22053, 661, 300, 9, 58, "Output"]
}, Open  ]],
Cell[22368, 673, 563, 18, 50, "Text"],
Cell[CellGroupData[{
Cell[22956, 695, 421, 10, 62, "Input"],
Cell[23380, 707, 259, 7, 57, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23688, 720, 227, 3, 37, "Subsection"],
Cell[CellGroupData[{
Cell[23942, 728, 213, 5, 27, "Subsubsection"],
Cell[24158, 735, 417, 13, 50, "Text"],
Cell[CellGroupData[{
Cell[24600, 752, 1971, 53, 162, "Input"],
Cell[26574, 807, 664, 16, 59, "Output"],
Cell[27241, 825, 870, 24, 66, "Output"]
}, Open  ]],
Cell[28126, 852, 144, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[28295, 858, 1217, 27, 122, "Input"],
Cell[29515, 887, 1186, 35, 66, "Output"]
}, Open  ]],
Cell[30716, 925, 362, 9, 47, "Text"],
Cell[31081, 936, 2977, 83, 212, "Input"],
Cell[34061, 1021, 272, 9, 29, "Text"],
Cell[CellGroupData[{
Cell[34358, 1034, 1171, 24, 102, "Input"],
Cell[35532, 1060, 6130, 102, 261, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41711, 1168, 144, 2, 27, "Subsubsection"],
Cell[41858, 1172, 884, 31, 147, "Text"],
Cell[42745, 1205, 1922, 49, 132, "Input"],
Cell[44670, 1256, 297, 10, 29, "Text"],
Cell[CellGroupData[{
Cell[44992, 1270, 874, 19, 62, "Input"],
Cell[45869, 1291, 1836, 53, 60, "Output"]
}, Open  ]],
Cell[47720, 1347, 345, 9, 49, "Text"],
Cell[48068, 1358, 750, 19, 49, "Input"],
Cell[48821, 1379, 410, 9, 65, "Text"],
Cell[CellGroupData[{
Cell[49256, 1392, 327, 6, 41, "Input"],
Cell[49586, 1400, 340, 6, 40, "Output"]
}, Open  ]],
Cell[49941, 1409, 447, 12, 49, "Text"],
Cell[CellGroupData[{
Cell[50413, 1425, 1665, 43, 122, "Input"],
Cell[52081, 1470, 1410, 28, 261, "Output"]
}, Open  ]],
Cell[53506, 1501, 321, 7, 47, "Text"],
Cell[CellGroupData[{
Cell[53852, 1512, 1805, 45, 142, "Input"],
Cell[55660, 1559, 1799, 34, 255, "Output"]
}, Open  ]],
Cell[57474, 1596, 303, 6, 47, "Text"],
Cell[CellGroupData[{
Cell[57802, 1606, 1825, 45, 102, "Input"],
Cell[59630, 1653, 1329, 27, 256, "Output"]
}, Open  ]],
Cell[60974, 1683, 439, 13, 48, "Text"],
Cell[61416, 1698, 1183, 30, 64, "Input"],
Cell[CellGroupData[{
Cell[62624, 1732, 684, 14, 65, "Input"],
Cell[63311, 1748, 331, 6, 40, "Output"],
Cell[63645, 1756, 334, 6, 40, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[64052, 1770, 182, 3, 75, "Section"],
Cell[CellGroupData[{
Cell[64259, 1777, 186, 3, 37, "Subsection"],
Cell[64448, 1782, 257, 5, 47, "Text"],
Cell[CellGroupData[{
Cell[64730, 1791, 940, 24, 82, "Input"],
Cell[65673, 1817, 621, 16, 57, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[66331, 1838, 451, 11, 41, "Input"],
Cell[66785, 1851, 2727, 52, 264, "Output"]
}, Open  ]],
Cell[69527, 1906, 656, 14, 101, "Text"],
Cell[CellGroupData[{
Cell[70208, 1924, 1007, 28, 82, "Input"],
Cell[71218, 1954, 422, 10, 56, "Output"]
}, Open  ]],
Cell[71655, 1967, 480, 18, 29, "Text"],
Cell[CellGroupData[{
Cell[72160, 1989, 1044, 26, 82, "Input"],
Cell[73207, 2017, 29409, 514, 268, 23946, 423, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[102631, 2534, 276, 8, 29, "Text"],
Cell[CellGroupData[{
Cell[102932, 2546, 110, 2, 41, "Input"],
Cell[103045, 2550, 803, 24, 93, "Output"]
}, Open  ]],
Cell[103863, 2577, 155, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[104043, 2583, 582, 13, 41, "Input"],
Cell[104628, 2598, 159361, 2602, 319, 88902, 1446, "CachedBoxData", \
"BoxData", "Output"]
}, Open  ]],
Cell[264004, 5203, 222, 5, 47, "Text"],
Cell[CellGroupData[{
Cell[264251, 5212, 412, 11, 41, "Input"],
Cell[264666, 5225, 7436, 128, 243, "Output"]
}, Open  ]],
Cell[272117, 5356, 201, 5, 29, "Text"],
Cell[CellGroupData[{
Cell[272343, 5365, 412, 11, 41, "Input"],
Cell[272758, 5378, 175, 4, 40, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[272982, 5388, 217, 3, 37, "Subsection"],
Cell[273202, 5393, 431, 13, 47, "Text"],
Cell[CellGroupData[{
Cell[273658, 5410, 384, 8, 41, "Input"],
Cell[274045, 5420, 242, 3, 40, "Output"]
}, Open  ]],
Cell[274302, 5426, 815, 24, 92, "Text"],
Cell[CellGroupData[{
Cell[275142, 5454, 734, 16, 62, "Input"],
Cell[275879, 5472, 1230, 36, 89, "Output"],
Cell[277112, 5510, 200, 3, 40, "Output"]
}, Open  ]],
Cell[277327, 5516, 437, 10, 69, "Text"],
Cell[CellGroupData[{
Cell[277789, 5530, 2032, 54, 282, "Input"],
Cell[279824, 5586, 1239, 25, 244, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[281100, 5616, 124, 2, 27, "Subsubsection"],
Cell[281227, 5620, 916, 22, 155, "Text"],
Cell[282146, 5644, 1744, 36, 102, "Input"],
Cell[283893, 5682, 417, 12, 47, "Text"],
Cell[CellGroupData[{
Cell[284335, 5698, 1736, 35, 82, "Input"],
Cell[286074, 5735, 398, 7, 40, "Output"],
Cell[286475, 5744, 397, 7, 40, "Output"]
}, Open  ]],
Cell[286887, 5754, 526, 15, 65, "Text"],
Cell[CellGroupData[{
Cell[287438, 5773, 1660, 32, 102, "Input"],
Cell[289101, 5807, 366, 6, 40, "Output"]
}, Open  ]],
Cell[289482, 5816, 375, 10, 49, "Text"],
Cell[CellGroupData[{
Cell[289882, 5830, 2053, 41, 122, "Input"],
Cell[291938, 5873, 548, 14, 40, "Output"],
Cell[292489, 5889, 418, 9, 55, "Output"]
}, Open  ]],
Cell[292922, 5901, 316, 7, 48, "Text"],
Cell[293241, 5910, 3150, 83, 322, "Input"],
Cell[296394, 5995, 409, 10, 47, "Text"],
Cell[296806, 6007, 534, 8, 41, "Input"],
Cell[297343, 6017, 580, 17, 85, "Text"],
Cell[CellGroupData[{
Cell[297948, 6038, 1243, 28, 145, "Input"],
Cell[299194, 6068, 229, 3, 40, "Output"],
Cell[299426, 6073, 228, 3, 40, "Output"],
Cell[299657, 6078, 227, 3, 40, "Output"]
}, Open  ]],
Cell[299899, 6084, 630, 12, 102, "Text"],
Cell[CellGroupData[{
Cell[300554, 6100, 2530, 68, 262, "Input"],
Cell[303087, 6170, 14960, 278, 253, "Output"]
}, Open  ]],
Cell[318062, 6451, 273, 9, 30, "Text"],
Cell[CellGroupData[{
Cell[318360, 6464, 478, 11, 102, "Input"],
Cell[318841, 6477, 310, 4, 40, "Output"],
Cell[319154, 6483, 311, 4, 40, "Output"],
Cell[319468, 6489, 307, 4, 40, "Output"],
Cell[319778, 6495, 327, 5, 40, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[320166, 6507, 183, 3, 37, "Subsection"],
Cell[320352, 6512, 856, 21, 109, "Text"],
Cell[CellGroupData[{
Cell[321233, 6537, 627, 15, 82, "Input"],
Cell[321863, 6554, 375, 8, 64, "Output"]
}, Open  ]],
Cell[322253, 6565, 312, 11, 29, "Text"],
Cell[CellGroupData[{
Cell[322590, 6580, 293, 7, 41, "Input"],
Cell[322886, 6589, 284, 5, 53, "Output"]
}, Open  ]],
Cell[323185, 6597, 142, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[323352, 6603, 162, 4, 43, "Input"],
Cell[323517, 6609, 345, 7, 58, "Output"]
}, Open  ]],
Cell[323877, 6619, 250, 6, 48, "Text"],
Cell[CellGroupData[{
Cell[324152, 6629, 441, 10, 62, "Input"],
Cell[324596, 6641, 386, 6, 55, "Output"]
}, Open  ]],
Cell[324997, 6650, 317, 9, 29, "Text"],
Cell[CellGroupData[{
Cell[325339, 6663, 1624, 42, 127, "Input"],
Cell[326966, 6707, 949, 26, 93, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[327952, 6738, 640, 16, 62, "Input"],
Cell[328595, 6756, 93700, 1523, 308, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[422332, 8284, 124, 2, 27, "Subsubsection"],
Cell[422459, 8288, 393, 7, 83, "Text"],
Cell[CellGroupData[{
Cell[422877, 8299, 463, 12, 43, "Input"],
Cell[423343, 8313, 205, 3, 40, "Output"]
}, Open  ]],
Cell[423563, 8319, 157, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[423745, 8325, 298, 7, 43, "Input"],
Cell[424046, 8334, 229, 4, 55, "Output"]
}, Open  ]],
Cell[424290, 8341, 504, 9, 83, "Text"],
Cell[CellGroupData[{
Cell[424819, 8354, 1490, 38, 104, "Input"],
Cell[426312, 8394, 176, 4, 55, "Output"],
Cell[426491, 8400, 8797, 157, 264, 3404, 66, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[435303, 8560, 179, 4, 29, "Text"],
Cell[CellGroupData[{
Cell[435507, 8568, 601, 13, 41, "Input"],
Cell[436111, 8583, 260, 5, 55, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[436432, 8595, 192, 3, 37, "Subsection"],
Cell[CellGroupData[{
Cell[436649, 8602, 135, 2, 27, "Subsubsection"],
Cell[436787, 8606, 358, 9, 65, "Text"],
Cell[CellGroupData[{
Cell[437170, 8619, 410, 11, 62, "Input"],
Cell[437583, 8632, 307, 5, 40, "Output"]
}, Open  ]],
Cell[437905, 8640, 208, 5, 47, "Text"],
Cell[CellGroupData[{
Cell[438138, 8649, 423, 12, 41, "Input"],
Cell[438564, 8663, 468, 13, 60, "Output"]
}, Open  ]],
Cell[439047, 8679, 205, 5, 47, "Text"],
Cell[CellGroupData[{
Cell[439277, 8688, 478, 14, 41, "Input"],
Cell[439758, 8704, 551, 16, 60, "Output"]
}, Open  ]],
Cell[440324, 8723, 152, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[440501, 8729, 286, 7, 41, "Input"],
Cell[440790, 8738, 249, 3, 40, "Output"]
}, Open  ]],
Cell[441054, 8744, 275, 6, 47, "Text"],
Cell[CellGroupData[{
Cell[441354, 8754, 3608, 96, 274, "Input"],
Cell[444965, 8852, 25484, 437, 350, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[470498, 9295, 128, 2, 27, "Subsubsection"],
Cell[470629, 9299, 679, 15, 83, "Text"],
Cell[CellGroupData[{
Cell[471333, 9318, 966, 25, 84, "Input"],
Cell[472302, 9345, 1080, 28, 78, "Output"],
Cell[473385, 9375, 845, 22, 78, "Output"],
Cell[474233, 9399, 492, 14, 60, "Output"]
}, Open  ]],
Cell[474740, 9416, 150, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[474915, 9422, 168, 3, 41, "Input"],
Cell[475086, 9427, 119, 2, 40, "Output"]
}, Open  ]],
Cell[475220, 9432, 611, 18, 65, "Text"],
Cell[CellGroupData[{
Cell[475856, 9454, 834, 24, 82, "Input"],
Cell[476693, 9480, 370, 10, 56, "Output"]
}, Open  ]],
Cell[477078, 9493, 328, 10, 29, "Text"],
Cell[CellGroupData[{
Cell[477431, 9507, 616, 15, 82, "Input"],
Cell[478050, 9524, 280, 5, 40, "Output"],
Cell[478333, 9531, 469, 12, 60, "Output"],
Cell[478805, 9545, 548, 15, 60, "Output"]
}, Open  ]],
Cell[479368, 9563, 303, 9, 47, "Text"],
Cell[CellGroupData[{
Cell[479696, 9576, 570, 14, 82, "Input"],
Cell[480269, 9592, 224, 6, 40, "Output"],
Cell[480496, 9600, 269, 8, 40, "Output"],
Cell[480768, 9610, 157, 3, 40, "Output"]
}, Open  ]],
Cell[480940, 9616, 487, 16, 47, "Text"],
Cell[CellGroupData[{
Cell[481452, 9636, 5898, 148, 383, "Input"],
Cell[487353, 9786, 39711, 685, 213, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

